// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

// To use centroid sampling we need to have version 300 es shaders, which requires changing:
// attribute to in
// varying to out when in vertex shaders or in when in fragment shaders
// defining an out vec4 FragColor and replacing uses of gl_FragColor with FragColor
// texture2D to texture
#if __VERSION__ >= 300
#define attribute in
#define varying out

#else

#endif

uniform MAT4 WORLDVIEWPROJ;
uniform MAT4 WORLDVIEW;
uniform MAT4 PROJ;
uniform vec4 FOG_COLOR;
uniform vec4 CURRENT_COLOR;
uniform vec2 FOG_CONTROL;

attribute mediump vec4 POSITION;
attribute vec4 COLOR;

varying vec4 color;

const float fogNear = 0.3;

void main()
{
gl_Position = WORLDVIEWPROJ * POSITION;

vec4 sky = CURRENT_COLOR;
vec4 fog = FOG_COLOR;
vec4 c = COLOR;
float fog_flag = 0.0;

vec3 cD = vec3(0.15, 0.29, 0.99);
vec3 rD = vec3(170./255.,170./255.,170./255.);
vec3 cN = vec3(0.005, 0.01, 0.02) * 0.025;

if(FOG_CONTROL.x < 0.55 && FOG_CONTROL.x > 0.1){
fog_flag = 1.0;
sky.rgb = max(sky.rgb * rD, cN);
color = mix(sky, fog, c.r);
}

sky.rgb = max(sky.rgb * cD, cN);
if(fog.r > 0.15 && fog.g > 0.15){
fog.rgb = max(fog.rgb * 3.0, 0.0);}
if(fog.r < 0.15 && fog.g < 0.15){
fog.rgb = max(fog.rgb * 1.0, 0.0);}

if(fog_flag == 0.0){
color = mix(sky, fog, c.r);}
}