// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the Read Me.txt contained in the root directory of this shaderpack!

*/

// To use centroid sampling we need to have version 300 es shaders, which requires changing:
// attribute to in
// varying to out when in vertex shaders or in when in fragment shaders
// defining an out vec4 FragColor and replacing uses of gl_FragColor with FragColor
// texture2D to texture
#if __VERSION__ >= 300

// version 300 code

#define varying in
#define texture2D texture
out vec4 FragColor;
#define gl_FragColor FragColor

#else

// version 100 code

#endif

uniform sampler2D TEXTURE_0;
uniform sampler2D TEXTURE_1;

varying vec2 uv;
varying vec4 color;
varying vec4 worldPosition;
varying vec4 fogColor;

void main()
{
	vec4 albedo = texture2D( TEXTURE_0, uv);

#ifdef ALPHA_TEST
	if (albedo.a < 0.5)
		discard;
#endif

	albedo.a *= color.a;

	vec2 occlusionUV = worldPosition.xz;
	vec4 occlusionTexture = texture2D( TEXTURE_1, occlusionUV);

	// clamp the uvs
	if ( occlusionUV.x >= 0.0 && occlusionUV.x <= 1.0 && 
		 occlusionUV.y >= 0.0 && occlusionUV.y <= 1.0 && 
		 worldPosition.y < occlusionTexture.a) {
		albedo.a = 0.0;
	}

	float mixAmount = clamp ( (worldPosition.y - occlusionTexture.a)*10.0, 0.0, 1.0);
	vec3 lighting = mix(occlusionTexture.rgb, color.rgb, mixAmount);
	vec4 finalOutput = albedo;
	finalOutput.rgb *= lighting.rgb;

finalOutput.rgb = vec3(0.75);

	//apply fog
	gl_FragColor.rgb = mix( finalOutput.rgb, fogColor.rgb, fogColor.a );
	gl_FragColor.a = finalOutput.a;
}


