// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the Read Me.txt contained in the root directory of this shaderpack!

*/

// To use centroid sampling we need to have version 300 es shaders, which requires changing:
// attribute to in
// varying to out when in vertex shaders or in when in fragment shaders
// defining an out vec4 FragColor and replacing uses of gl_FragColor with FragColor
// texture2D to texture
#if __VERSION__ >= 300
#define attribute in
#define varying out

#else


#endif


uniform vec2 FOG_CONTROL;
uniform MAT4 WORLDVIEWPROJ;
uniform MAT4 WORLD;
uniform float RENDER_DISTANCE;
uniform vec4 FOG_COLOR;
uniform vec4 CURRENT_COLOR;

uniform highp float TIME;
attribute mediump vec4 POSITION;
attribute vec4 COLOR;

varying vec4 color;

const float fogNear = 0.9;


const float pi = 3.5;
const vec3 inverseLightDirection = vec3(1.0, 0.78, 0.0);
const float ambient = 1.0;

void main()
{
vec3 xyz =POSITION.xyz;
    POS4 pos = WORLDVIEWPROJ * POSITION;
	POS4 worldPos = WORLD * POSITION;
 	gl_Position = pos;

 	color = COLOR * CURRENT_COLOR;

 	float depth = length(worldPos.xyz) / RENDER_DISTANCE;
 	float fog = max(depth - fogNear, 0.3);

float s =1.5-FOG_CONTROL.x;
color.a+=s;
color.rgb*=FOG_CONTROL.x;
 //	color.a *= fog-5.0;
color.a *= 0.9-fog;
// float a = sin(TIME*0.0000001+xyz.x/4.0+xyz.z/1.0)+cos(TIME*0.0000001+xyz.x/5.0+xyz.z/5.0)+sin(TIME*0.0000001+xyz.x/8.0+xyz.z/6.0);
 float a =0.31*cos(TIME*0.80+0.25*pi*(xyz.z+xyz.z+xyz.z))*0.91*sin(TIME*0.79+0.25*pi*(xyz.x+xyz.z+xyz.z))+0.51*cos(TIME*0.79+0.65*pi*(xyz.z+xyz.z+xyz.z))*0.91*sin(TIME*0.69+0.25*pi*(xyz.x+xyz.z))+0.41*cos(TIME*0.79+0.60*pi*(xyz.z+xyz.z+xyz.x))*0.91*sin(TIME*0.69+0.25*pi*(xyz.x+xyz.x+xyz.x))+0.21*cos(TIME*0.79+0.25*pi*(xyz.z+xyz.z+xyz.z))*0.91*sin(TIME*0.69+0.25*pi*(xyz.x+xyz.z+xyz.z));
// color.a+=a*0.2;
 float b=cos(xyz.x*(FOG_CONTROL.x*0.9)+xyz.z*0.1)+sin(xyz.z*0.015*xyz.x*1.6-xyz.x*0.1)+cos(xyz.x*0.3+TIME*0.01)+sin(TIME*0.031+xyz.z*0.63)*FOG_CONTROL.x+cos(xyz.x*0.8)+sin(xyz.z*0.5);
 color.a+=a*0.85+b*0.32;

 color.rgb*=3.2;
color.a*=0.5;
color.rgb-=a*0.05+b*0.02;
gl_Position.y+=(a+b)*8.0/5.0;
//gl_Position.y-=cos(zz*xyz.z*2.0)+sin(xyz.x*1.5)*50.0;
}