// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the Read Me.txt contained in the root directory of this shaderpack!

*/

#include "vertexVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		_centroid out vec2 uv0;
		_centroid out vec2 uv1;
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		varying vec2 uv0;
		varying vec2 uv1;
	#endif
#endif

#ifndef BYPASS_PIXEL_SHADER
	varying vec4 color;
#endif

#ifdef FOG
	varying vec4 fogColor;
#endif

#ifdef GL_FRAGMENT_PRECISION_HIGH
	varying highp vec3 cPos;
#else
	varying mediump vec3 cPos;
#endif

varying POS3 wPos;
varying vec3 screen_pos;
varying highp vec3 world_pos;
varying float f_pos;
varying highp vec3 w_pos;
varying highp vec3 v_pos;
varying POS3 h_pos;
varying float far_f;
varying POS3 t_pos;
varying highp vec3 look;
varying highp vec3 position;

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"

attribute POS4 POSITION;
attribute vec4 COLOR;
attribute vec2 TEXCOORD_0;
attribute vec2 TEXCOORD_1;

const float rA = 1.0;
const float rB = 1.0;
const vec3 UNIT_Y = vec3(0,1,0);
const float DIST_DESATURATION = 56.0 / 255.0; //WARNING this value is also hardcoded in the water color, don'tchange

vec4 rgb2hsv(vec4 rgb){
    highp float rgbMax = max(rgb.r, max(rgb.g, rgb.b));
    highp float rgbMin = min(rgb.r, min(rgb.g, rgb.b));
    highp float h      = 0.0;
    highp float s      = 0.0;
    highp float v      = rgbMax;
    highp float delta  = rgbMax - rgbMin;
    if (delta != 0.0) {
        if (rgbMax == rgb.r) {h = (rgb.g - rgb.b) / delta;}
        else if (rgbMax == rgb.g) {h = 2.0 + (rgb.b - rgb.r) / delta;}
        else {h = 4.0 + (rgb.r - rgb.g) / delta;}
    }
    h *= 60.0;
    h  = h < 0.0 ? h + 360.0 : h;
    if (rgbMax != 0.0) {s = delta / rgbMax;}
    return vec4(h, s, v, rgb.a);
}

highp float hash11(highp float p){
	highp vec3 p3  = vec3(fract(p * 0.1031));
	p3 += dot(p3, p3.yzx + 19.19);
	return fract((p3.x + p3.y) * p3.z);
}

highp float random(highp float p){
	p = p/3.0+TIME;
	return mix(hash11(floor(p)),hash11(ceil(p)),smoothstep(0.0,1.0,fract(p)))*2.0;
}

void main()
{
    POS4 worldPos;
#ifdef AS_ENTITY_RENDERER
		POS4 pos = WORLDVIEWPROJ * POSITION;
		worldPos = pos;
#else
    worldPos.xyz = (POSITION.xyz * CHUNK_ORIGIN_AND_SCALE.w) + CHUNK_ORIGIN_AND_SCALE.xyz;
    worldPos.w = 1.0;


    POS4 pos = WORLDVIEW * worldPos;
    pos = PROJ * pos;
#endif
    gl_Position = pos;

t_pos = worldPos.xyz;
h_pos = worldPos.xyz+VIEW_POS;
far_f = pos.z / FAR_CHUNKS_DISTANCE;

		cPos = POSITION.xyz;
		wPos = worldPos.xyz;

#ifndef BYPASS_PIXEL_SHADER
    uv0 = TEXCOORD_0;
    uv1 = TEXCOORD_1;
	color = COLOR;
#endif

look = worldPos.xyz;
position = POSITION.xyz + VIEW_POS.xyz;

v_pos = worldPos.xyz;
w_pos = POSITION.xyz;

float rain_f = clamp((1.0-pow(FOG_CONTROL.y+0.1,10.0)),0.0,1.0);
float rainfog_f = clamp(1.0-pow(FOG_CONTROL.y,10.0)*uv1.y,0.0,1.0);

highp vec3 wav_pos = vec3(0.0);

vec2 s_pos =floor(vec2(TEXCOORD_0.x * 64.0, TEXCOORD_0.y * 32.0));

#ifdef ALPHA_TEST

wav_pos.x = (sin(TIME*4.0 + w_pos.x*1.2)+sin(TIME*3.0 + w_pos.x*0.8) + sin(TIME*6.2 + w_pos.z*2.5))*0.04;
wav_pos*=max(sin((w_pos.x+w_pos.z)*0.5+TIME*2.0),0.3*rain_f)*TEXCOORD_1.y*(1.0+rain_f);
wav_pos.x *= pow(1.0-(TEXCOORD_0.y * 32.0-s_pos.y),2.0);

if((color.r==color.g&&color.g==color.b)||(s_pos.y==7.0)){
wav_pos = vec3(0.0);
}
else if((color.r!=color.g&&color.g!=color.b)&&color.r<color.g){
wav_pos *= 3.0;
if(s_pos.y==5.0){
wav_pos.x = (sin(TIME*1.1+ w_pos.x*1.4)+sin(TIME*2.1+ w_pos.x*1.51) - sin(TIME*5.2 - w_pos.z*2.0))*0.025;
wav_pos.y = (sin(TIME*4.3 + w_pos.x*4.01)+sin(TIME*3.9+ w_pos.x*3.5) + sin(TIME*6.2 + w_pos.z*5.0))*0.01;
wav_pos*=max(sin((w_pos.x+w_pos.z)*0.5+TIME*2.0)+0.2,0.3*rain_f)*TEXCOORD_1.y*(1.0+rain_f);
}
}
else{
wav_pos = vec3(0.0);
}

#endif

bool nether = (FOG_COLOR.r > FOG_COLOR.b	&& FOG_COLOR.r < 0.5 && FOG_COLOR.b < 0.2);

#ifdef FANCY
if(color.b>color.r && nether == false)
{
gl_Position.y+=sin(TIME+ length(h_pos) )*.015;
gl_Position.y+=cos(TIME+ length(h_pos) )*.015;
gl_Position.y+=sin(TIME+ length(h_pos) )*.025;
gl_Position.y+=cos(TIME+ length(h_pos) )*.025;
}
#endif

if(FOG_CONTROL.x==0.){
POS3 p = vec3(POSITION.x==16.?0.:POSITION.x,abs(POSITION.y-8.),POSITION.z==16.?0.:POSITION.z);
gl_Position.xy+=sin(TIME+ length(h_pos) )*.015;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.015;
gl_Position.xy+=sin(TIME+ length(h_pos) )*.025;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.025;
}

#ifdef ALPHA_TEST
if(color.g>color.r)
{
gl_Position.xy+=sin(TIME+ length(h_pos) )*.001;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.001;
gl_Position.xy+=sin(TIME+ length(h_pos) )*.01;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.01;
}
#endif

#ifdef ALPHA_TEST
if(color.r>color.g)
{
gl_Position.xy+=sin(TIME+ length(h_pos) )*.001;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.001;
gl_Position.xy+=sin(TIME+ length(h_pos) )*.01;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.01;
}
#endif

if(color.a == 0.0){
gl_Position.xy+=sin(TIME+ length(h_pos) )*.001;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.001;
gl_Position.xy+=sin(TIME+ length(h_pos) )*.01;
gl_Position.xy+=cos(TIME+ length(h_pos) )*.01;
}
screen_pos.xy = pos.xy/(pos.z+1.0);
screen_pos.z = min(1.0,pos.z);
world_pos = worldPos.xyz;

f_pos = length(-worldPos.xyz) / FAR_CHUNKS_DISTANCE;
//f_pos = pos.z / FAR_CHUNKS_DISTANCE;

#ifdef FOG
if(rain_f>0.5&&FOG_COLOR.b>0.15&&(((FOG_COLOR.b>=FOG_COLOR.g*1.2)&&FOG_COLOR.b>=FOG_COLOR.r*1.3)||((FOG_COLOR.g*1.3>=FOG_COLOR.b)&&(FOG_COLOR.r*1.5<FOG_COLOR.g)))){

wav_pos.x = (sin(TIME*2.0 + v_pos.x*2.0) + sin(TIME*3.2 + v_pos.y*5.2))*0.05;
wav_pos.y = (sin(TIME*3.0 + v_pos.x*1.5) + sin(TIME*2.2 + v_pos.z*1.2))*0.03;

}//under water
#endif

gl_Position.xyz +=wav_pos.xyz;

///// find distance from the camera

#ifdef ALPHA_TEST 
#ifdef FANCY
highp vec3 wave = POSITION.stp;
vec4 uvC = vec4(COLOR.rb,uv0);

if(TEXCOORD_1.y>TEXCOORD_1.x){
if((uvC.r>=uvC.g)&&(uvC.r>uvC.b)&&(uvC.r>=1.0)&&(uvC.g>=1.0)){
gl_Position.x += sin(TIME*4.0+wave.z+wave.z+wave.x+cos(TIME*3.+wave.y+wave.x ))* sin(wave.x+wave.y)* 0.01*uv1.y; }

if(COLOR.g>COLOR.r&&COLOR.a>0.0){
gl_Position.x += sin(TIME*4.+wave.z+wave.z+wave.z+cos(TIME*3.+wave.y+wave.x))*sin(wave.x+wave.y)*0.018*uv1.y; }

if(COLOR.a==0.0){
gl_Position.x += sin(TIME*4.0+wave.y+wave.z+wave.z+cos(TIME*2.5+wave.x))*sin(wave.y+wave.y)*uv1.y*0.012; }
}
#endif
#endif

#if defined(FOG) || defined(BLEND)
	#ifdef FANCY
		vec3 relPos = -worldPos.xyz;
		float cameraDepth = length(relPos);
	#else
		float cameraDepth = pos.z;
	#endif
#endif

///// waves
#if defined ALPHA_TEST && defined(LEAVES_WAVES)
	if(color.g > color.b){
		POS3 l = POSITION.xyz;
		l.y = abs(l.y-8.0);
		gl_Position.s += sin(TIME * 3.5 + 2.0 * l.x + 2.0 * l.z + l.y) * 0.015 * random(l.x+l.y+l.z);
	}
#endif

#if !defined(BYPASS_PIXEL_SHADER) && !defined(ALPHA_TEST) && defined(WATER_WAVES)
	vec4 hsv = rgb2hsv(color);
	if (hsv.x >= 120.0 && hsv.x <= 270.0) {
		POS3 l = worldPos.xyz + VIEW_POS;
		gl_Position.t += sin(TIME * 3.5 + 2.0 * l.x + 2.0 * l.z + l.y) * 0.04 * fract(POSITION.y) * random(l.x+l.y+l.z);
		color.a *= 0.5;
	}
#endif

///// apply fog

#ifdef FOG
	float len = cameraDepth / RENDER_DISTANCE;
	#ifdef ALLOW_FADE
		len += RENDER_CHUNK_FOG_ALPHA;
	#endif

    fogColor.rgb = FOG_COLOR.rgb;
    fogColor.rgb = FOG_COLOR.rgb*vec3(220./255.,219./255.,223./255.);
	fogColor.a = clamp((len - FOG_CONTROL.x) / (FOG_CONTROL.y - FOG_CONTROL.x), 0.0, 1.0);
#endif

///// blended layer (mostly water) magic
#ifdef BLEND

	if(color.a < 0.95) {
		#ifdef FANCY  /////enhance water
		#else

			vec4 surfColor = vec4(color.rgb, 1.0);
			color = surfColor;
		#endif //FANCY

		float cameraDist = cameraDepth / FAR_CHUNKS_DISTANCE;
		float alphaFadeOut = clamp(cameraDist, 0.0, 1.0);
		color.a = mix(color.a, 1.0, alphaFadeOut);
	}
#endif

#ifndef BYPASS_PIXEL_SHADER
	#ifndef FOG

		color.rgb += FOG_COLOR.rgb * 0.000001;
	#endif
#endif
}
