// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the Read Me.txt contained in the root directory of this shaderpack!

*/

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
			_centroid in highp vec2 uv0;
			_centroid in highp vec2 uv1;
		#else
			_centroid in vec2 uv0;
			_centroid in vec2 uv1;
		#endif
	#endif

#else
	#ifndef BYPASS_PIXEL_SHADER
		varying vec2 uv0;
		varying vec2 uv1;
	#endif
#endif

varying vec4 color;
varying vec3 screen_pos;
varying highp vec3 world_pos;
varying float f_pos;
varying POS3 t_pos;
varying POS3 h_pos;
varying float far_f;
varying highp vec3 look;
varying highp vec3 position;

#ifdef FOG
varying vec4 fogColor;
#endif

#ifdef GL_FRAGMENT_PRECISION_HIGH
	varying highp vec3 cPos;
#else
	varying mediump vec3 cPos;
#endif
varying POS3 wPos;

#include "uniformShaderConstants.h"
#include "uniformPerFrameConstants.h"
#include "util.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;
LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;

#ifndef BYPASS_PIXEL_SHADER

vec4 bump_pom(vec4 d, vec2 u, float p){

vec3 pos_pom = vec3(1.0);
float test_pos = (abs(p*0.85));
float max_pos = min(1.0,max(0.0,test_pos));
pos_pom = mix(pos_pom,vec3(0.0,0.0,1.0),max_pos);
pos_pom = mix(pos_pom,vec3(1.0,1.0,0.0),1.0-max_pos);

vec2 set_height = (pos_pom.xy/pos_pom.z) * (d.r *0.001);

vec2 pom = u+(-set_height);
vec4 diffuse_pom =texture2D(TEXTURE_0, pom);
vec4 start_bump = pow(diffuse_pom, vec4(1.0))*0.35;

return start_bump;
}


vec4 wet(vec4 d, vec3 wp){
vec3 pos_kilap = d.rgb*(wp);
vec4 texturescorpio = texture2D(TEXTURE_0,pos_kilap.xz);
vec3 lekukan = (vec3(length(abs(texturescorpio.xyz)+sin(dot(texturescorpio.y,pos_kilap.z)))));
vec3 kilap_buatan= pos_kilap-lekukan.rgb;

vec4 do_weat = d*(length(kilap_buatan));
vec4 start = abs(do_weat)*0.1;
return start; }


vec4 wet_pom(vec4 d, vec3 p, vec3 wp, vec2 u, float r){
vec4 bp = bump_pom(d,u,p.z);
vec4 w = wet(d,wp);
w = d-bp+w;
bp = d*1.2-bp;

return mix(bp,w,r); }

#endif

float inrect(vec2 pos, float x1, float y1, float x2, float y2, float focus){
 return min(1.0, max(min(min(pos.x - x1, x2 - pos.x), min(pos.y - y1, y2 - pos.y)), 0.0) / focus);
}

float bongnguoichoi(){
vec3 lookvector=look;
lookvector.x*=2.0;
 vec3 pos = lookvector + vec3(0.4, 0.4, 0.4); 
 vec3 dir = vec3(-1.0, (1.25) * 0.31, 0.0);
 float factor = 1.0;
 if (pos.x < 0.2){
  factor = max(0.0, pos.x / 0.4 + 0.5);
 }
pos += dir * pos.x;
 float focus = .04;
 float footwalk = sin((position.x - lookvector.x) * 2.0 + (position.z - lookvector.z) * 2.0);
float handswalk = sin((position.x - lookvector.x) * 2.0 + (position.z - lookvector.z)) * .5;
pos.yz -= vec2(.2, .4);
 float body = max(inrect(pos.yz, -1.5 + footwalk*.4, -0.25, 0.75, .1, focus), inrect(pos.yz, -1.5 - footwalk*.4, -.1, 0.75, 0.25, focus));
 float hands = max(inrect(pos.yz, -0.5 + footwalk * .1, -0.5, 0.25, .1, focus), inrect(pos.yz, -0.5 - footwalk * 0.1, -.1, 0.25, 0.5, focus));
 return min(1.0, max(body, hands)) * factor;
}

vec3 U2TM(vec3 color)
{
	float gamma = 1.25;
	float A = 1.25;
	float B = 0.1;
	float C = 0.6;
	float D = 0.7;
	float E = 0.02;
	float F = 0.6;
	float W = 11.2;
	float exposure = 2.;
	color *= exposure;
	color = ((color * (A * color + C * B) + D * E) / (color * (A * color + B) + D * F)) - E / F;
	float white = ((W * (A * W + C * B) + D * E) / (W * (A * W + B) + D * F)) - E / F;
	color /= white;
	color = pow(color, vec3(1. / gamma));
	return color;
}

const highp float pi = 3.14159265358979;

lowp float random(lowp float x, lowp float z){
  highp float ra = sin(x+(z*0.5+(x-10.0)))*2.0;
  highp float rb = sin(z+(x*0.5+(z-10.0)));
  
  highp float rc = sin(x+cos(z+sin(x+z)));
  highp float rd = cos(z+sin(x+sin(z+x)));
  
  highp float re = sin(ra-cos(rc+sin(ra+rb)));
  highp float rf = cos(rb-cos(rd+sin(rb+rc)));
  return sin(ra-rb*rc+rd*re*rf);
}

void main()
{
#ifdef BYPASS_PIXEL_SHADER
	gl_FragColor = vec4(0);
	return;
#else

#if USE_TEXEL_AA
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv0);
#else
	vec4 diffuse = texture2D(TEXTURE_0, uv0);
#endif

#ifdef SEASONS_FAR
	diffuse.a = 1.0;
	inColor.b = 1.0;
#endif

float PerformanceCoverage = (0.960);

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
		#define ALPHA_THRESHOLD 0.05
	#else
		#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < PerformanceCoverage)
		discard;
#endif

                       vec4 inColor = color;

vec4 f_color = FOG_COLOR;
vec4 fog = FOG_COLOR;
vec4 lf_color = mix(fog,vec4(1.0),1.0-fog.b);

#if defined(BLEND)
	diffuse.a *= inColor.a;
#endif

#if !defined(ALWAYS_LIT)
	vec4 Light= texture2D( TEXTURE_1, uv1 );
 diffuse*=Light;
#endif

#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = inColor.a;

	#endif
	diffuse.rgb *= inColor.rgb;
#else
	vec2 uv = inColor.xy;
	diffuse.rgb *= mix(vec3(1.0,1.0,1.0), texture2D( TEXTURE_2, uv).rgb*2.0, inColor.b);
	diffuse.rgb *= inColor.aaa;
	diffuse.a = 1.0;
#endif

vec4 light = texture2D( TEXTURE_1, vec2(0.0,1.0) );

float shadow_a =1.0;
float light_flag =abs(light.r+light.g+light.b)/3.0;
float fog_flag =FOG_CONTROL.y;
float day_flag =max(1.0-pow(light_flag,10.0),0.0);
float night_flag =min((1.0-light_flag)*2.0,1.0);
float dusk_flag =max(1.0-pow(light_flag,10.0),0.0);
float rain_flag = (1.0-pow(fog_flag,5.0));

vec4 sun_light;

vec4 lights_color =vec4(1.0,0.55,0.3,0.4);
vec4 day_color  = vec4(1.135,1.105,1.05,0.16);
vec4 un_water_color = vec4(0./255.,233./255.,255./255.,1.0);

POS3 posxz = h_pos;

posxz.x += 0.5*sin(posxz.z*4.0+TIME*5.0)*0.1;
posxz.z += cos(posxz.x*2.0+TIME*0.5)*0.1;
			
float h0 = sin(posxz.x*7.0+posxz.z*0.5+0.1+TIME*2.0)+sin(posxz.z*1.5+2.0+TIME*1.2);
posxz.x = h_pos.x+ 4.5*sin(posxz.z*2.0+TIME*1.2)*0.1;
posxz.z = h_pos.z+8.5*cos(posxz.x*1.0+TIME*2.3)*0.1;
float h1 = cos(posxz.x*6.0+posxz.z/2.5+0.1+TIME*1.5)+cos(posxz.z/1.5+10.2+TIME*2.5);
posxz.x = h_pos.x+ 3.8*cos(posxz.z*4.0+TIME*0.5-far_f)*0.1;
posxz.z = h_pos.z+10.5*cos(posxz.x*3.0+TIME*1.8)*0.1;
float h2 = sin(posxz.x*8.0+posxz.z*0.3+0.2+TIME*1.6)+sin(posxz.z*1.3+8.4+TIME*0.8);
posxz.x = h_pos.x+ 2.3*sin(posxz.z*2.0+TIME*1.5)*0.1;
posxz.z = h_pos.z+7.9*cos(posxz.x*2.0+TIME*2.5)*0.1;
float h3 = cos(posxz.x*7.0+posxz.z/2.5+0.5+TIME*2.5)+cos(posxz.z/2.0+0.5+TIME*1.5);
posxz.x = h_pos.x+ 2.3*cos(posxz.z*3.0+TIME*4.0)*0.1;
posxz.z = h_pos.z+6.2*cos(posxz.x*4.0+TIME*2.0)*0.1;
float h4 = cos(posxz.x*9.0+posxz.z/5.2+0.7+TIME*1.0)+cos(posxz.z/1.2+14.8+TIME*2.0);
posxz.x = h_pos.x+ 2.8*sin(posxz.z*0.5+TIME*2.0)*0.1;
posxz.z = h_pos.z+5.0*cos(posxz.x*3.0+TIME*1.5)*0.1;
float h5 = cos(posxz.x*9.0+posxz.z/3.2+0.7+TIME*1.0)+cos(posxz.z/2.2+6.8+TIME*2.0);
			
float r0 = sin(posxz.x*8.0+posxz.z*0.6+0.1+TIME*2.0)+sin(posxz.z*1.5+2.0+TIME*1.2);
posxz.x = h_pos.x+ 4.5*sin(posxz.z*2.0+TIME*1.0+far_f)*0.1;
posxz.z = h_pos.z+2.5*cos(posxz.x*1.0+TIME*2.5)*0.1;
float r1 = cos(posxz.x*7.0+posxz.z/1.5+0.1+TIME*1.5)+cos(posxz.z/1.5+10.2+TIME*2.5);
posxz.x = h_pos.x+ 3.8*cos(posxz.z*4.0+TIME*1.0-far_f)*0.1;
posxz.z = h_pos.z+0.5*cos(posxz.x*3.0+TIME*1.5)*0.1;
float r2 = sin(posxz.x*9.0+posxz.z*0.4+0.2+TIME*1.6)+sin(posxz.z*1.3+8.4+TIME*0.8);
posxz.x = h_pos.x+ 2.3*sin(posxz.z*2.0+TIME*3.0+far_f)*0.1;
posxz.z = h_pos.z+1.9*cos(posxz.x*2.0+TIME*2.5)*0.1;
float r3 = cos(posxz.x*8.0+posxz.z/1.5+0.5+TIME*2.5)+cos(posxz.z/2.0+0.5+TIME*1.5);
posxz.x = h_pos.x+ 2.3*cos(posxz.z*3.0+TIME*2.5-far_f)*0.1;
posxz.z = h_pos.z+0.2*cos(posxz.x*4.0+TIME*2.0)*0.1;
float r4 = cos(posxz.x*10.0+posxz.z/4.2+0.7+TIME*1.0)+cos(posxz.z/1.2+14.8+TIME*2.0);
posxz.x = h_pos.x+ 2.8*sin(posxz.z*0.5+TIME*3.0+far_f)*0.1;
posxz.z = h_pos.z+1.0*cos(posxz.x*3.0+TIME*1.5)*0.1;
float r5 = cos(posxz.x*8.0+posxz.z/2.2+0.7+TIME*1.0)+cos(posxz.z/2.2+6.8+TIME*2.0);
			
float water_r =abs(r0-r1)+abs(r2-r3)+r4*far_f;
float water_a =(abs(h0+h1)+abs(h2+h3)+h4)*(far_f+0.2);

if(water_a>1.0){
water_a*=0.8*min(abs(far_f+0.2)*4.0,1.0);
}

POS3 cp = (t_pos);
 
highp  float x = cp.x*0.1+TIME*0.1;
highp  float z = cp.z*0.1+TIME*0.1;

float cd1 = sin(x*0.9+z*0.13)*sin(TIME * pi / 18.9) * 1.7+sin(x*0.2-z*0.6)+cos(-z*0.3+x*0.8);
float cd2 = cos(x*0.5+z*0.9)*sin(TIME * pi / 18.9) * 1.7+cos(x*0.8-z*0.3)-sin(-z*0.9+x*0.20);
float cs1 = random(x*1.0,z*1.5)-random(cd1,pi)*0.3;
float cs2 = random(x*1.0,z*1.5)-random(cd2,pi)*0.4;

POS3 vposxz = t_pos;

float c0 = sin(vposxz.x*10.8+vposxz.z*1.2+1.2+TIME*0.5)+sin(vposxz.z*1.5+2.0+TIME*1.2);
vposxz.x = t_pos.x+ 4.5*sin(vposxz.z*2.0+TIME*0.2+far_f)*0.1;
vposxz.z = t_pos.z+8.5*cos(vposxz.x*1.0+TIME*0.3)*0.1;
float c1 = cos(vposxz.x*10.3+vposxz.z*1.5+0.5+TIME*0.5)+cos(vposxz.z*1.5+10.2+TIME*1.5);
vposxz.x = t_pos.x+ 3.8*cos(vposxz.z*4.0+TIME*0.5-far_f)*0.1;
vposxz.z = t_pos.z+10.5*cos(vposxz.x*3.0+TIME*0.8)*0.1;
float c2 = sin(vposxz.x*10.2+vposxz.z*0.9+3.2+TIME*0.6)+sin(vposxz.z*1.3+8.4+TIME*0.8);
vposxz.x = t_pos.x+ 2.3*sin(vposxz.z*2.0+TIME*0.5+far_f)*0.1;
vposxz.z = t_pos.z+7.9*cos(vposxz.x*2.0+TIME*1.5)*0.1;
float c3 = cos(vposxz.x*10.1+vposxz.z*1.5+2.9+TIME*0.5)+cos(vposxz.z*2.0+0.5+TIME*1.5);
vposxz.x = t_pos.x+ 2.3*cos(vposxz.z*3.0+TIME*1.0-far_f)*0.1;
vposxz.z = t_pos.z+6.2*cos(vposxz.x*4.0+TIME*0.0)*0.1;
float c4 = cos(vposxz.x*12.0+vposxz.z*2.2+0.7+TIME*1.0)+cos(vposxz.z*1.2+14.8+TIME*1.0);
vposxz.x = h_pos.x+ 2.8*sin(vposxz.z*0.5+TIME*1.0+far_f)*0.1;
vposxz.z = h_pos.z+2.0*cos(vposxz.x*3.0+TIME*1.5)*0.1;
float c5 = cos(vposxz.x*17.0+vposxz.z*3.2+1.7+TIME*1.0)+cos(vposxz.z/2.2+6.8+TIME*2.0);

float cloud =(1.0+(abs(c0)+abs(c1)+c2+c3+c4))*0.5*random(cd2,pi)*random(cd1,pi)*0.3;

#ifdef BLEND

if(uv1.y>=0.888244){

diffuse =mix(diffuse,lf_color,max(mix(water_a+water_r-abs(water_a*water_r),water_a+water_r-abs(water_a*water_r),far_f),0.1)*0.10);

diffuse =mix(diffuse,lf_color,max(mix((water_a*2.0-abs(water_r+cloud*2.0+water_a))*(1.0-cloud),0.0,far_f),0.2)*max(far_f+0.5,1.0)*0.3);

diffuse +=lights_color*max(pow(uv1.x*1.3,5.0),0.0)*max(water_a+water_r-abs(water_a*water_r),0.5)*0.15;

}
else{

diffuse.rgb += max(water_a+water_r-abs(water_a*water_r),1.5)*0.05*f_color.rgb;

diffuse +=lights_color*max(pow(uv1.x*1.3,5.0),0.0)*max(water_a+water_r-abs(water_a*water_r),0.5)*0.15;

}

#endif

if((f_color.b>.15&&(f_color.b>f_color.g*1.2)&&(f_color.b>=f_color.r*1.8)&&(f_color.g>f_color.r*1.6))||(f_color.g*1.2>=f_color.b)&&(f_color.r*1.3<f_color.g)){

diffuse.rgb *= un_water_color.rgb+abs(day_color.rgb*vec3(water_a+water_r-abs(water_a*water_r))*0.1);

//diffuse*=1.0+hd+ggg;}

}

vec4 tex =texture2D( TEXTURE_0, uv0 );
vec3 mm_light_color =vec3(0.56,0.24,0.0);
vec3 ender_color =vec3(0.5,0.65,0.70);
float fog_flag1 =f_pos;
float f_shadow_flag =uv1.y;


vec3 mm_light=mm_light_color*pow(uv1.x*1.4,5.0);//pow(uv1.x*2.0,1.0)


if((((f_color.r>f_color.g)&&(f_color.b>f_color.g)&&(f_color.b>f_color.r))&&(f_color.r<0.05&&f_color.b<0.05&&f_color.g<0.05)&&rain_flag<=0.8&&light.r>0.22)&&(f_shadow_flag==0.0&&CURRENT_COLOR.r<=0.3)){



mm_light=vec3(0.4,0.0,0.7)*pow(uv1.x*1.2,5.0);
diffuse.rgb=tex.rgb*ender_color+mm_light;
diffuse.rgb*=inColor.rgb+(vec3(1.0)-inColor.rgb)*pow(uv1.x*1.3,4.0);
fog_flag1 =0.0;


diffuse.rgb += max(water_a+water_r-abs(water_a*water_r),1.5)*0.05*f_color.rgb;

diffuse +=lights_color*max(pow(uv1.x*1.3,5.0),0.0)*max(water_a+water_r-abs(water_a*water_r),0.5)*0.15;

float shd2 = color.r;
if(color.a<=0.1){ shd2 = color.g*1.999; }
if(shd2<0.638){ diffuse.rgb *= 0.7; }

vec3 t=vec3(1.0)*max(0.53,uv1.x);
vec3 shd=vec3(0.75,0.75,0.75)*t;
if(uv1.y<=.87)
{
diffuse.rgb*=shd;
}
if(uv1.y<=.869)
{
diffuse.rgb*=shd;
}
if(uv1.y<=.868)
{
diffuse.rgb*=shd;
}

float shd3 = length(color.rgb) / 3.;
float shd4 = mix( .8, 1., uv1.x );
if(color.a == 0.) shd3 = 1.;
if(color.b + color.b > color.r + color.g) shd3 = 1.;

if( uv1.y < .87 ) {
}else{
if( shd3 < .2 ) diffuse.rgb *= shd4;
if( shd3 < .198 ) diffuse.rgb *= shd4;
if( shd3 < .196 ) diffuse.rgb *= shd4;
}

diffuse.rgb=U2TM(diffuse.rgb);

#ifdef FANCY
if(color.b>color.r)
{
	diffuse.rgb *=vec3(128./255.,0./255.,128./255.);
}
#endif
}

vec2 uvl=uv1;
uvl.y-=bongnguoichoi()*0.5;
  diffuse *= texture2D(TEXTURE_1, uvl);

vec3 torch = pow(vec3(255, 141, 11) / 255.0 *uv1.x*0.6, vec3(2.2));
diffuse.rgb += torch;

diffuse.rgb=U2TM(diffuse.rgb);

#ifdef FANCY
if(color.b>color.r)
{
	diffuse.rgb *=vec3(0.2,0.85,1.0)*0.75;
}
#endif

vec3 clr=vec3(1.135,1.105,1.05);
diffuse.rgb*=mix(vec3(1.),clr,Light.r);

vec3 clr2=vec3(0.005,0.01,0.02)*0.00003;
diffuse.rgb*=mix(vec3(.0),clr,Light.r);

vec3 br=vec3(0.13);
diffuse.rgb+=mix(vec3(.0),br,Light.r);

bool nether = (FOG_COLOR.r > FOG_COLOR.b	&& FOG_COLOR.r < 0.5 && FOG_COLOR.b < 0.2);

if(nether == true){
    vec3 torch = pow(vec3(1.0,0.2,0.05) *uv1.x*1.0, vec3(2.2));
diffuse.rgb += torch;

	vec3 clr=vec3(1.135,1.105,1.05)*0.25;
diffuse.rgb*=mix(vec3(1.),clr,Light.r);

vec3 br=vec3(0.000013);
diffuse.rgb+=mix(vec3(.0),br,Light.r);

	diffuse.rgb=U2TM(diffuse.rgb);
	
   float udan = (1.0-pow(FOG_CONTROL.y,5.0));
   diffuse = wet_pom(diffuse,screen_pos,world_pos,uv0,udan*uv1.y);
   
float fogf = 0.0;
vec3 shadow_color = vec3(0.768,0.758,0.858)+uv1.x*vec3(0.318,0.318,0.17);

float shdY = 0.8765;
float shdX = color.g;
if(color.a==0.0){
diffuse.rgb *= 1.25;
shdY = 0.8749;
shdX = color.g*1.3;
}

#ifdef FOG
fogf = 0.5;
#endif

if(((uv1.y<shdY-0.000)||(shdX<0.630))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.001)||(shdX<0.625))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.002)||(shdX<0.620))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.003)||(shdX<0.615))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}
}

float fogf = 0.0;
vec3 shadow_color = vec3(0.768,0.758,0.858)+uv1.x*vec3(0.318,0.318,0.17);

float shdY = 0.8765;
float shdX = color.g;
if(color.a==0.0){
diffuse.rgb *= 1.25;
shdY = 0.8749;
shdX = color.g*1.3;
}

#ifdef FOG
fogf = 0.5;
#endif

if(((uv1.y<shdY-0.000)||(shdX<0.630))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.001)||(shdX<0.625))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.002)||(shdX<0.620))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.003)||(shdX<0.615))&&fogf==0.0){
diffuse.rgb *= shadow_color;
}

if(FOG_CONTROL.x<0.55&&FOG_CONTROL.x>0.1){ 
vec3 clr=vec3(1.135,1.105,1.05)*0.5;
diffuse.rgb*=mix(vec3(1.),clr,Light.r);

vec3 clr2=vec3(0.005,0.01,0.02)*0.00003;
diffuse.rgb*=mix(vec3(.0),clr,Light.r);

vec3 br=vec3(0.13);
diffuse.rgb+=mix(vec3(.0),br,Light.r);

vec3 torch = pow(vec3(255, 141, 11) / 255.0 *uv1.x*0.3, vec3(2.2));
diffuse.rgb += torch;

#ifdef FANCY
if(color.b>color.r)
{
	diffuse.rgb *=vec3(135./255.,217./255.,211./255.);
}
#endif
 }

float water_flag =0.0;
float f_b_water_flag =0.0;
float green_lea_flag =0.0;
float un_water_flag =0.0;
float dark_sh_flag = uv1.y;
float snow_lea_flag =0.0;

#ifdef FOG

if(f_b_water_flag ==1.0&&(water_flag!=1.0)&&(green_lea_flag!=1.0)){
//diffuse.rgb=vec3(f_color.r*0.78,f_color.g*0.82,f_color.b*0.87);

diffuse.rgb=vec3(f_color.r*0.58,f_color.g*0.72,f_color.b*0.87);
diffuse =mix(diffuse,lf_color,max(water_a+water_r-abs(water_a*water_r),0.1)*0.10);
diffuse +=lights_color*max(pow(uv1.x*1.4,5.0),0.0);
diffuse =mix(diffuse/2.0*sun_light,vec4(0.14,0.24,0.48,1.0),night_flag);
}

#endif

vec3 fog_change = mix(vec3(0.1),f_color.rgb/vec3(1.5,1.48,1.0),dark_sh_flag);

fog_change =mix(fog_change,f_color.rgb,un_water_flag);

if((water_flag!=1.0 && f_b_water_flag !=1.0 )||snow_lea_flag==1.0){

diffuse.rgb =mix(diffuse.rgb,fog_change,min(far_f*0.7,1.0)*abs(f_b_water_flag*dark_sh_flag-1.0)*abs(water_flag*dark_sh_flag-1.0));

}

#ifdef FOG
	diffuse.rgb = mix( diffuse.rgb, fogColor.rgb, fogColor.a );
#endif

gl_FragColor = diffuse;

#endif // BYPASS_PIXEL_SHADER
}
