// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the Read Me.txt contained in the root directory of this shaderpack!

*/

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300

#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
_centroid in highp vec2 uv;
#else
_centroid in vec2 uv;
#endif

#else

varying vec2 uv;

#endif

#include "uniformShaderConstants.h"
#include "util.h"
#include "uniformPerFrameConstants.h"

uniform sampler2D TEXTURE_0;

varying highp vec3 w_pos;
varying highp vec3 v_pos;

vec4 sun_color =vec4(1.0,0.58,0.0,0.65);
vec4 moon_color =vec4(244./255.,241./255.,201./255.,1.0);

float fnight_f;
float fsunset_f;
float frain_f;

float night_f;
float sunset_f;
float rain_f;

void flagSet(inout float night_f,inout float sunset_f,inout float rain_f,in vec4 light_f,in float f_sh_f,in float flag){

if(flag==0.0){

night_f = max(1.0-min(pow(light_f.r*1.8,5.0),1.0),0.0);
sunset_f = pow(clamp((1.0-pow(light_f.r,5.0))*1.3,0.0,1.0),8.0);
rain_f =clamp((1.0-pow(FOG_CONTROL.y+0.1,10.0)),0.0,1.0);

}

else if(flag==1.0){//fog

night_f =pow(max(min(1.0-light_f.r*1.5,1.0),0.0),1.2);
sunset_f =pow(max(min(1.0-light_f.b*1.2,1.0),0.0),0.5);
rain_f =clamp((1.0-pow(FOG_CONTROL.y+0.1,10.0))*f_sh_f,0.0,1.0);

}
}

vec4 sunmoonRender(vec3 w_pos){

flagSet(fnight_f,fsunset_f,frain_f,FOG_COLOR,1.0,1.0);

float css =1.0-pow(length(w_pos*105.0),1.8);
float c0 =1.0-pow(length(w_pos*48.0),fnight_f*20.0+0.5);
float c1 =1.0-pow(length(w_pos*2.0),0.5*max(pow(FOG_COLOR.g+0.1,10.0),0.2));

vec4 sunmoon_color=mix(sun_color,moon_color,fnight_f);

vec4 sunmoon = vec4(sunmoon_color.rgb,clamp(css,0.0,1.0));
sunmoon = mix(sunmoon,sunmoon_color,clamp(c1,0.0,1.0));
sunmoon =mix(sunmoon,sunmoon_color,clamp(c0,0.0,1.0))*(1.0-frain_f);

return sunmoon;
}

void main()
{

gl_FragColor = sunmoonRender(w_pos);

}
