// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the Read Me.txt contained in the root directory of this shaderpack!

*/

#include "vertexVersionCentroid.h"
#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		_centroid out vec2 uv0;
		_centroid out vec2 uv1;
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		varying vec2 uv0;
		varying vec2 uv1;
	#endif
#endif

#ifndef BYPASS_PIXEL_SHADER
	varying vec4 color;
#endif

#ifdef FOG
	varying vec4 fogColor;
#endif

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"

attribute POS4 POSITION;
attribute vec4 COLOR;
attribute vec2 TEXCOORD_0;
attribute vec2 TEXCOORD_1;

varying vec3 wpos;
varying highp vec3 look;
varying highp vec3 position;

const float rA = 1.0;
const float rB = 1.0;
const vec3 UNIT_Y = vec3(0,1,0);
const float DIST_DESATURATION = 56.0 / 255.0; //WARNING this value is also hardcoded in the water color, don'tchange

void main()
{
    POS4 worldPos;
#ifdef AS_ENTITY_RENDERER
		POS4 pos = WORLDVIEWPROJ * POSITION;
		worldPos = pos;
#else
    worldPos.xyz = (POSITION.xyz * CHUNK_ORIGIN_AND_SCALE.w) + CHUNK_ORIGIN_AND_SCALE.xyz;
    worldPos.w = 1.0;

    // Transform to view space before projection instead of all at once to avoid floating point errors
    // Not required for entities because they are already offset by camera translation before rendering
    // World position here is calculated above and can get huge
    POS4 pos = WORLDVIEW * worldPos;
    pos = PROJ * pos;
#endif
    gl_Position = pos;

#ifndef BYPASS_PIXEL_SHADER
    uv0 = TEXCOORD_0;
    uv1 = TEXCOORD_1;
	color = COLOR;
#endif

///// find distance from the camera

#if defined(FOG) || defined(BLEND)
	#ifdef FANCY
		vec3 relPos = -worldPos.xyz;
		float cameraDepth = length(relPos);
	#else
		float cameraDepth = pos.z;
	#endif
#endif

look = worldPos.xyz;
position = POSITION.xyz + VIEW_POS.xyz;

bool nether = (FOG_COLOR.r > FOG_COLOR.b	&& FOG_COLOR.r < 0.5 && FOG_COLOR.b < 0.2);

vec3 wave=worldPos.xyz+VIEW_POS;

#ifdef ALPHA_TEST
if(color.g>color.r)
{
gl_Position.xy+=sin(TIME+ length(wave) )*.001;
gl_Position.xy+=cos(TIME+ length(wave) )*.001;
gl_Position.xy+=sin(TIME+ length(wave) )*.01;
gl_Position.xy+=cos(TIME+ length(wave) )*.01;
}
#endif

#ifdef FANCY
if(color.b>color.r && nether == false)
{
gl_Position.y+=sin(TIME+ length(wave) )*.015;
gl_Position.y+=cos(TIME+ length(wave) )*.015;
gl_Position.y+=sin(TIME+ length(wave) )*.025;
gl_Position.y+=cos(TIME+ length(wave) )*.025;
}
#endif

#ifdef ALPHA_TEST
if(color.r>color.g)
{
gl_Position.xy+=sin(TIME+ length(wave) )*.001;
gl_Position.xy+=cos(TIME+ length(wave) )*.001;
gl_Position.xy+=sin(TIME+ length(wave) )*.01;
gl_Position.xy+=cos(TIME+ length(wave) )*.01;
}
#endif

if(FOG_CONTROL.x==0.){
POS3 p = vec3(POSITION.x==16.?0.:POSITION.x,abs(POSITION.y-8.),POSITION.z==16.?0.:POSITION.z);
gl_Position.xy+=sin(TIME+ length(wave) )*.015;
gl_Position.xy+=cos(TIME+ length(wave) )*.015;
gl_Position.xy+=sin(TIME+ length(wave) )*.025;
gl_Position.xy+=cos(TIME+ length(wave) )*.025;
}

if(color.a == 0.0){
gl_Position.xy+=sin(TIME+ length(wave) )*.001;
gl_Position.xy+=cos(TIME+ length(wave) )*.001;
gl_Position.xy+=sin(TIME+ length(wave) )*.01;
gl_Position.xy+=cos(TIME+ length(wave) )*.01;
}
///// apply fog

#ifdef FOG
	float len = cameraDepth / RENDER_DISTANCE;
	#ifdef ALLOW_FADE
		len += RENDER_CHUNK_FOG_ALPHA;
	#endif

    fogColor.rgb = FOG_COLOR.rgb;
    fogColor.rgb = FOG_COLOR.rgb*vec3(220./255.,219./255.,223./255.);
	fogColor.a = clamp((len - FOG_CONTROL.x) / (FOG_CONTROL.y - FOG_CONTROL.x), 0.0, 1.0);
#endif

///// blended layer (mostly water) magic
#ifdef BLEND
	//Mega hack: only things that become opaque are allowed to have vertex-driven transparency in the Blended layer...
	//to fix this we'd need to find more space for a flag in the vertex format. color.a is the only unused part
	bool shouldBecomeOpaqueInTheDistance = color.a < 0.95;
	if(shouldBecomeOpaqueInTheDistance) {
		#ifdef FANCY  /////enhance water
			float cameraDist = cameraDepth / FAR_CHUNKS_DISTANCE;
			color = COLOR;
		#else
			// Completely insane, but if I don't have these two lines in here, the water doesn't render on a Nexus 6
			vec4 surfColor = vec4(color.rgb, 1.0);
			color = surfColor;

			vec3 relPos = -worldPos.xyz;
			float camDist = length(relPos);
			float cameraDist = camDist / FAR_CHUNKS_DISTANCE;
		#endif //FANCY

		float alphaFadeOut = clamp(cameraDist, 0.0, 1.0);
		color.a = mix(color.a, 1.0, alphaFadeOut);
	}
#endif

#ifndef BYPASS_PIXEL_SHADER
	#ifndef FOG
		// If the FOG_COLOR isn't used, the reflection on NVN fails to compute the correct size of the constant buffer as the uniform will also be gone from the reflection data
		color.rgb += FOG_COLOR.rgb * 0.000001;
	#endif
#endif

wpos = worldPos.xyz;
}
