// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the Read Me.txt contained in the root directory of this shaderpack!

*/

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
			_centroid in highp vec2 uv0;
			_centroid in highp vec2 uv1;
		#else
			_centroid in vec2 uv0;
			_centroid in vec2 uv1;
		#endif
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		varying vec2 uv0;
		varying vec2 uv1;
	#endif
#endif

varying vec4 color;
varying highp vec3 wpos;
varying highp vec3 look;
varying highp vec3 position;

uniform vec4 FOG_COLOR;
uniform float RENDER_DISTANCE;

uniform highp float TIME;

#ifdef FOG
varying vec4 fogColor;
#endif

#include "uniformShaderConstants.h"
#include "util.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;
LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;

float inrect(vec2 pos, float x1, float y1, float x2, float y2, float focus){
 return min(1.0, max(min(min(pos.x - x1, x2 - pos.x), min(pos.y - y1, y2 - pos.y)), 0.0) / focus);
}

float bongnguoichoi(){
vec3 lookvector=look;
lookvector.x*=2.0;
 vec3 pos = lookvector + vec3(0.4, 0.4, 0.4); 
 vec3 dir = vec3(-1.0, (1.25) * 0.31, 0.0);
 float factor = 1.0;
 if (pos.x < 0.2){
  factor = max(0.0, pos.x / 0.4 + 0.5);
 }
pos += dir * pos.x;
 float focus = .04;
 float footwalk = sin((position.x - lookvector.x) * 2.0 + (position.z - lookvector.z) * 2.0);
float handswalk = sin((position.x - lookvector.x) * 2.0 + (position.z - lookvector.z)) * .5;
pos.yz -= vec2(.2, .4);
 float body = max(inrect(pos.yz, -1.5 + footwalk*.4, -0.25, 0.75, .1, focus), inrect(pos.yz, -1.5 - footwalk*.4, -.1, 0.75, 0.25, focus));
 float hands = max(inrect(pos.yz, -0.5 + footwalk * .1, -0.5, 0.25, .1, focus), inrect(pos.yz, -0.5 - footwalk * 0.1, -.1, 0.25, 0.5, focus));
 return min(1.0, max(body, hands)) * factor;
}

vec3 U2TM(vec3 color)
{
	float gamma = 1.25;
	float A = 1.25;
	float B = 0.1;
	float C = 0.6;
	float D = 0.7;
	float E = 0.02;
	float F = 0.6;
	float W = 11.2;
	float exposure = 2.;
	color *= exposure;
	color = ((color * (A * color + C * B) + D * E) / (color * (A * color + B) + D * F)) - E / F;
	float white = ((W * (A * W + C * B) + D * E) / (W * (A * W + B) + D * F)) - E / F;
	color /= white;
	color = pow(color, vec3(1. / gamma));
	return color;
}

void main()
{
#ifdef BYPASS_PIXEL_SHADER
	gl_FragColor = vec4(0, 0, 0, 0);
	return;
#else

#if USE_TEXEL_AA
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv0);
#else
	vec4 diffuse = texture2D(TEXTURE_0, uv0);
#endif

#ifdef SEASONS_FAR
	diffuse.a = 1.0;
#endif

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
	#define ALPHA_THRESHOLD 0.05
	#else
	#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

vec4 inColor = color;

#if defined(BLEND)
	diffuse.a *= inColor.a;
#endif

#if !defined(ALWAYS_LIT)
vec2 uvl = uv1;
uvl.x = mix(1.0,uvl.x,length(-wpos)/RENDER_DISTANCE *25.0);
 vec4 Light=texture2D(TEXTURE_1,uvl);
	diffuse *=Light;
#endif

#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = inColor.a;
	#endif

	diffuse.rgb *= inColor.rgb;
#else
	vec2 uv = inColor.xy;
	diffuse.rgb *= mix(vec3(1.0,1.0,1.0), texture2D( TEXTURE_2, uv).rgb*2.0, inColor.b);
	diffuse.rgb *= inColor.aaa;
	diffuse.a = 1.0;
#endif

vec3 torch = pow(vec3(255, 141, 11) / 255.0 *uv1.x*1.0, vec3(2.2));
diffuse.rgb += torch;

vec3 clr=vec3(1.135,1.105,1.05);
diffuse.rgb*=mix(vec3(1.),clr,Light.r);

vec3 clr2=vec3(0.005,0.01,0.02)*0.00003;
diffuse.rgb*=mix(vec3(.0),clr,Light.r);

vec3 br=vec3(0.13);
diffuse.rgb+=mix(vec3(.0),br,Light.r);

diffuse.rgb=U2TM(diffuse.rgb);

#ifdef BLEND
if(color.r*1.1 < color.b){
diffuse.rgb = vec3(0.2,0.85,1.0)*0.75;
diffuse.a = 0.75;
}
#endif

float fog = clamp(length(-wpos)/ RENDER_DISTANCE*1.25,0.0,1.25);
vec3 fog2 = mix(diffuse.rgb,FOG_COLOR.rgb, fog);
diffuse.rgb = fog2;

uvl.y-=bongnguoichoi()*0.5;
  diffuse *= texture2D(TEXTURE_1, uvl);

bool nether = (FOG_COLOR.r > FOG_COLOR.b	&& FOG_COLOR.r < 0.5 && FOG_COLOR.b < 0.2);

if(nether == true){
    vec3 torch = pow(vec3(1.0,0.2,0.05) *uv1.x*1.0, vec3(2.2));
diffuse.rgb += torch;

	vec3 clr=vec3(1.135,1.105,1.05)*0.25;
diffuse.rgb*=mix(vec3(1.),clr,Light.r);

vec3 br=vec3(0.000013);
diffuse.rgb+=mix(vec3(.0),br,Light.r);

	diffuse.rgb=U2TM(diffuse.rgb);
	
    float fog = clamp(length(-wpos)/ RENDER_DISTANCE*1.25,0.0,1.25);
vec3 fog2 = mix(diffuse.rgb,FOG_COLOR.rgb, fog);
diffuse.rgb = fog2;

float fog_flag = 0.0;
vec3 shadow_color = vec3(0.768,0.758,0.858)+uv1.x*vec3(0.318,0.318,0.17);

float shdY = 0.8765;
float shdX = color.g;
if(color.a==0.0){
diffuse.rgb *= 1.25;
shdY = 0.8749;
shdX = color.g*1.3;
}

#ifdef FOG
fog_flag = 0.5;
#endif

if(((uv1.y<shdY-0.000)||(shdX<0.630))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.001)||(shdX<0.625))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.002)||(shdX<0.620))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.003)||(shdX<0.615))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}
}

float fog_flag = 0.0;
vec3 shadow_color = vec3(0.768,0.758,0.858)+uv1.x*vec3(0.318,0.318,0.17);

float shdY = 0.8765;
float shdX = color.g;
if(color.a==0.0){
diffuse.rgb *= 1.25;
shdY = 0.8749;
shdX = color.g*1.3;
}

#ifdef FOG
fog_flag = 0.5;
#endif

if(((uv1.y<shdY-0.000)||(shdX<0.630))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.001)||(shdX<0.625))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.002)||(shdX<0.620))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}
if(((uv1.y<shdY-0.003)||(shdX<0.615))&&fog_flag==0.0){
diffuse.rgb *= shadow_color;
}

#ifdef FOG
	diffuse.rgb = mix( diffuse.rgb, fogColor.rgb, fogColor.a );
#endif

	gl_FragColor = diffuse;

#endif // BYPASS_PIXEL_SHADER
}
