/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.world.gen.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderBaseConfiguration;
import net.minecraftforge.common.util.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingSurfaceBuilder<C extends SurfaceBuilderBaseConfiguration, S extends SurfaceBuilder<C>>
extends SurfaceBuilder<C> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Lazy<S> delegatedSurfaceBuilder;
    private boolean logged = false;

    public LoggingSurfaceBuilder(Supplier<S> delegatedSurfaceBuilder, Codec<C> codec) {
        super(codec);
        this.delegatedSurfaceBuilder = Lazy.of(delegatedSurfaceBuilder);
    }

    public void apply(Random random, ChunkAccess chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, int p_164223_, long seed, C config) {
        ((SurfaceBuilder)this.delegatedSurfaceBuilder.get()).m_142263_(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, 0, seed, config);
        if (!this.logged) {
            this.logged = true;
            ChunkPos chunkPos = chunk.m_7697_();
            LOGGER.info("Generating {} at {},{}", (Object)biome.getRegistryName(), (Object)chunkPos.m_45604_(), (Object)chunkPos.m_45605_());
        }
    }
}

