/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.vanillatweaks.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.config.VanillaTweaksConfig;
import dev.driscollcreations.explorercraft.vanillatweaks.blocks.SleepingBagBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="explorercraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    public static void initClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::textureStitching);
    }

    private static void textureStitching(TextureStitchEvent.Pre event) {
        if (event.getMap().m_118330_() == Sheets.f_110737_) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Stitching banner textures");
            event.addSprite(new ResourceLocation("entity/banner/wales"));
            event.addSprite(new ResourceLocation("entity/banner/welshflag"));
            Explorercraft.LOGGER.log(Level.DEBUG, "Finished stitching banner textures!");
        }
        if (event.getMap().m_118330_() == Sheets.f_110738_) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Stitching shield textures");
            event.addSprite(new ResourceLocation("entity/shield/wales"));
            event.addSprite(new ResourceLocation("entity/shield/welshflag"));
            Explorercraft.LOGGER.log(Level.DEBUG, "Finished stitching shield textures!");
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (((Boolean)VanillaTweaksConfig.swimmingHorse.get()).booleanValue()) {
            AbstractHorse horse;
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_20202_() instanceof AbstractHorse && (horse = (AbstractHorse)player.m_20202_()).m_20069_()) {
                horse.m_20256_(horse.m_20184_().m_82520_(0.0, (double)0.0125f, 0.0));
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterRenderer(EntityRenderersEvent.RegisterRenderers event) {
    }

    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        Player player = evt.getPlayer();
        if (player instanceof RemotePlayer && player.m_20089_() == Pose.SLEEPING) {
            player.m_21257_().ifPresent(bedPos -> {
                PoseStack matrixStack = evt.getMatrixStack();
                Block bed = player.f_19853_.m_8055_(bedPos).m_60734_();
                if (bed instanceof SleepingBagBlock) {
                    matrixStack.m_85837_(0.0, -0.375, 0.0);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post evt) {
        Player player = evt.getPlayer();
        if (player instanceof RemotePlayer && player.m_20089_() == Pose.SLEEPING) {
            player.m_21257_().ifPresent(bedPos -> {
                PoseStack matrixStack = evt.getMatrixStack();
                Block bed = player.f_19853_.m_8055_(bedPos).m_60734_();
                if (bed instanceof SleepingBagBlock) {
                    matrixStack.m_85837_(0.0, 0.375, 0.0);
                }
            });
        }
    }
}

