/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import dev.driscollcreations.explorercraft.Explorercraft;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="explorercraft")
public final class LootInjector {
    private LootInjector() {
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Tables.get(event.getName()).ifPresent(injectorName -> {
            Explorercraft.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
            event.getTable().addPool(LootPool.m_79043_().name("explorercraft_injected").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)injectorName)).m_79082_());
        });
    }

    public static final class Tables {
        private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
        public static final ResourceLocation CHESTS_NETHER_BRIDGE = Tables.inject(BuiltInLootTables.f_78760_);
        public static final ResourceLocation CHESTS_BASTION_TREASURE = Tables.inject(BuiltInLootTables.f_78697_);
        public static final ResourceLocation CHESTS_BASTION_OTHER = Tables.inject(BuiltInLootTables.f_78698_);
        public static final ResourceLocation CHESTS_BASTION_BRIDGE = Tables.inject(BuiltInLootTables.f_78699_);
        public static final ResourceLocation CHESTS_RUINED_PORTAL = Tables.inject(BuiltInLootTables.f_78701_);
        public static final ResourceLocation CHESTS_SIMPLY_DUNGEON = Tables.inject(BuiltInLootTables.f_78742_);

        private Tables() {
        }

        public static Collection<ResourceLocation> getValues() {
            return MAP.values();
        }

        public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
            return Optional.ofNullable(MAP.get(lootTable));
        }

        private static ResourceLocation inject(ResourceLocation lootTable) {
            ResourceLocation ret = Explorercraft.getId("inject/" + lootTable.m_135815_());
            MAP.put(lootTable, ret);
            return ret;
        }
    }
}

