/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveItems;
import dev.driscollcreations.explorercraft.cymru.items.CymruItems;
import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksItems;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="explorercraft")
public final class ExplorerTrades {
    public static final int NOVICE = 1;
    public static final int APPRENTICE = 2;
    public static final int JOURNEYMAN = 3;
    public static final int EXPERT = 4;
    public static final int MASTER = 5;

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mountingEntity = event.getEntityMounting();
        Entity entityBeingMounted = event.getEntityBeingMounted();
        if (mountingEntity instanceof Player && entityBeingMounted instanceof AbstractHorse) {
            Player player = (Player)mountingEntity;
            AbstractHorse horse = (AbstractHorse)entityBeingMounted;
            if (!horse.m_30614_() && player.m_7500_()) {
                Explorercraft.LOGGER.error("Horse was tamed instantly");
                horse.m_30586_(player.m_142081_());
                horse.m_30651_(true);
            }
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        ExplorerTrades.addWandererTrades(event, new VillagerTrades.ItemListing[]{new ExplorerTrade(1, ((Block)BambooGroveBlocks.BAMBOO_SAPLING.get()).m_5456_(), 1, 3, 1)});
        ExplorerTrades.addRareWandererTrades(event, new VillagerTrades.ItemListing[]{new ExplorerTrade(1, ((Block)BambooGroveBlocks.CHERRY_SAPLING.get()).m_5456_(), 1, 3, 1), new ExplorerTrade(1, ((Block)BambooGroveBlocks.MAPLE_SAPLING.get()).m_5456_(), 1, 3, 1), new ExplorerTrade(1, ((Item)BambooGroveItems.CHERRY_BLOSSOM.get()).m_5456_(), 1, 12, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.f_35590_, 1, new VillagerTrades.ItemListing[]{new ExplorerTrade((Item)BambooGroveItems.RICE.get(), 32, 1, 16, 2), new ExplorerTrade((Item)CymruItems.LEEK.get(), 22, 1, 16, 2)});
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.f_35587_, 3, new VillagerTrades.ItemListing[]{new ExplorerTrade((Item)CymruItems.LAMB_SHANK.get(), 7, 1, 16, 5)});
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.f_35589_, 3, new VillagerTrades.ItemListing[]{new ExplorerTrade((Item)VanillaTweaksItems.NOCTILUCA.get(), 5, 1, 8, 5)});
    }

    public static void addVillagerTrades(VillagerTradesEvent event, int level, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            ((List)event.getTrades().get(level)).add(trade);
        }
    }

    public static void addVillagerTrades(VillagerTradesEvent event, VillagerProfession profession, int level, VillagerTrades.ItemListing ... trades) {
        if (event.getType() == profession) {
            ExplorerTrades.addVillagerTrades(event, level, trades);
        }
    }

    public static void addWandererTrades(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getGenericTrades().add(trade);
        }
    }

    public static void addRareWandererTrades(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getRareTrades().add(trade);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, int level, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addVillagerTrades(event, level, trades);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, VillagerProfession profession, int level, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addVillagerTrades(event, profession, level, trades);
        }
    }

    public static void addCompatWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addWandererTrades(event, trades);
        }
    }

    public static void addCompatRareWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ItemListing ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addRareWandererTrades(event, trades);
        }
    }

    public static class ExplorerTrade
    extends BasicTrade {
        public ExplorerTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMult) {
            super(input, input2, output, maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((ItemLike)input, inputCount), ItemStack.f_41583_, new ItemStack((ItemLike)output, outputCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp) {
            this(input, inputCount, output, outputCount, maxTrades, xp, 0.15f);
        }

        public ExplorerTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((ItemLike)input, inputCount), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_, emeraldCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp) {
            this(input, inputCount, emeraldCount, maxTrades, xp, 0.15f);
        }

        public ExplorerTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((ItemLike)Items.f_42616_, emeraldCount), ItemStack.f_41583_, new ItemStack((ItemLike)output, outputCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp) {
            this(emeraldCount, output, outputCount, maxTrades, xp, 0.15f);
        }
    }

    public static class EmeraldForMapTrade
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final StructureFeature<?> destination;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;

        public EmeraldForMapTrade(int emeraldCost, StructureFeature<?> structure, MapDecoration.Type decoration, int maxUsesIn, int xpValueIn) {
            this.emeraldCost = emeraldCost;
            this.destination = structure;
            this.destinationType = decoration;
            this.maxUses = maxUsesIn;
            this.villagerXp = xpValueIn;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random random) {
            if (!(trader.f_19853_ instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)trader.f_19853_;
            BlockPos blockpos = serverlevel.m_8717_(this.destination, trader.m_142538_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.destinationType);
                itemstack.m_41714_((Component)new TranslatableComponent("filled_map." + this.destination.m_67098_().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)Items.f_42522_), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }
}

