/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public final class EmptyTrigger
implements CriterionTrigger<Instance> {
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();
    private final ResourceLocation id;

    public EmptyTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    public void m_6467_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.computeIfAbsent(playerAdvancements, Listeners::new);
        listeners.add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance createInstance(JsonObject object, DeserializationContext conditions) {
        return new Instance(this.id);
    }

    public void trigger(ServerPlayer player) {
        Listeners listeners = this.listeners.get(player.m_8960_());
        if (listeners != null) {
            listeners.trigger();
        }
    }

    static class Listeners {
        private final Set<CriterionTrigger.Listener<Instance>> listeners = new HashSet<CriterionTrigger.Listener<Instance>>();
        private final PlayerAdvancements advancements;

        public Listeners(PlayerAdvancements advancements) {
            this.advancements = advancements;
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void trigger() {
            ArrayList<CriterionTrigger.Listener<Instance>> listenerList = new ArrayList<CriterionTrigger.Listener<Instance>>(this.listeners);
            for (CriterionTrigger.Listener listener : listenerList) {
                listener.m_13686_(this.advancements);
            }
        }
    }

    public static class Instance
    implements CriterionTriggerInstance {
        private final ResourceLocation id;

        Instance(ResourceLocation id) {
            this.id = id;
        }

        public ResourceLocation m_7294_() {
            return this.id;
        }

        public JsonObject m_7683_(SerializationContext p_14485_) {
            return null;
        }
    }
}

