/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import dev.driscollcreations.explorercraft.bamboogrove.blocks.PanelBlock;
import dev.driscollcreations.explorercraft.setup.ExplorerCreativeModeTabs;
import dev.driscollcreations.explorercraft.setup.Registration;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fmllegacy.RegistryObject;

public class BlockUtils {
    public static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return Registration.BLOCKS.register(name, block);
    }

    public static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        RegistryObject ret = BlockUtils.registerNoItem(name, block);
        Registration.ITEMS.register(name, () -> new BlockItem((Block)ret.get(), new Item.Properties().m_41491_(ExplorerCreativeModeTabs.EXPLORERCRAFT)));
        return ret;
    }

    public static Block createWoodBlock() {
        return new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
    }

    public static TrapDoorBlock createWoodTrapdoor() {
        return new TrapDoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(BlockUtils::neverAllowSpawn));
    }

    public static SlabBlock createWoodSlab() {
        return new SlabBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
    }

    public static WoodButtonBlock createWoodButton() {
        return new WoodButtonBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_));
    }

    public static PressurePlateBlock createWoodPressurePlate() {
        return new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_));
    }

    public static DoorBlock createWoodDoor() {
        return new DoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_());
    }

    public static PanelBlock createPanel() {
        return new PanelBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_());
    }

    public static FenceBlock createWoodFence() {
        return new FenceBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
    }

    public static FenceGateBlock createWoodFenceGate() {
        return new FenceGateBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
    }

    public static LeavesBlock createLeavesBlock() {
        return new LeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(BlockUtils::allowsSpawnOnLeaves).m_60960_(BlockUtils::isntSolid).m_60971_(BlockUtils::isntSolid));
    }

    public static Boolean allowsSpawnOnLeaves(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.f_20505_ || entity == EntityType.f_20508_;
    }

    public static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public static Boolean neverAllowSpawn(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    public static RotatedPillarBlock createLogBlock(MaterialColor topColor, MaterialColor barkColor) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : barkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
    }
}

