/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.setup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.bamboogrove.blocks.BambooLogBlock;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.BambooFoliagePlacer;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.BambooTruckPlacer;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.RicePaddyFeature;
import dev.driscollcreations.explorercraft.config.BambooGroveConfig;
import dev.driscollcreations.explorercraft.config.CymruConfig;
import dev.driscollcreations.explorercraft.config.VanillaTweaksConfig;
import dev.driscollcreations.explorercraft.cymru.blocks.CymruBlocks;
import dev.driscollcreations.explorercraft.cymru.world.AshTreeTrunkPlacer;
import dev.driscollcreations.explorercraft.cymru.world.SnowdoniaFlowerBlockStateProvider;
import dev.driscollcreations.explorercraft.setup.ExplorerBiomes;
import dev.driscollcreations.explorercraft.setup.ExplorerPlacement;
import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksBlocks;
import dev.driscollcreations.explorercraft.vanillatweaks.world.feature.NoctilucaFeature;
import dev.driscollcreations.explorercraft.vanillatweaks.world.feature.SlimeBlockFeature;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Features;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.blockplacers.BlockPlacer;
import net.minecraft.world.level.levelgen.feature.blockplacers.SimpleBlockPlacer;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HeightmapConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.ConfiguredDecorator;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;
import net.minecraft.world.level.levelgen.placement.FrequencyWithExtraChanceDecoratorConfiguration;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="explorercraft")
public class ExplorerFeature {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"explorercraft");
    public static final DeferredRegister<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FOLIAGE_PLACER_TYPES, (String)"explorercraft");
    public static final RegistryObject<Feature<TreeConfiguration>> BAMBOO_TREE = FEATURES.register("bamboo_tree", () -> new TreeFeature(TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> MAPLE_TREE = FEATURES.register("maple_tree", () -> new TreeFeature(TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> ASH_TREE = FEATURES.register("ash_tree", () -> new TreeFeature(TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> RICE_PADDY = FEATURES.register("rice_paddy", RicePaddyFeature::new);
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SLIMEY_CHUNK = FEATURES.register("slimey_chunk", SlimeBlockFeature::new);
    public static final RegistryObject<Feature<CountConfiguration>> NOCTILUCAS = FEATURES.register("noctilucas", () -> new NoctilucaFeature((Codec<CountConfiguration>)CountConfiguration.f_67568_));
    protected static final BlockState COAL_ORE = Blocks.f_49997_.m_49966_();
    public static final RegistryObject<FoliagePlacerType<BambooFoliagePlacer>> BAMBOO_FOLIAGE_TYPE = FOLIAGE_PLACER_TYPES.register("bamboo_foliage_placer", () -> new FoliagePlacerType(BambooFoliagePlacer.CODEC));

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        String bambooGroveName;
        if (event.getName() == null) {
            return;
        }
        String biome = event.getName().toString();
        Random rand = new Random();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        ResourceKey biomeResourceKey = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(event.getName(), "Biome registry name was null"));
        if (((Boolean)VanillaTweaksConfig.spawnSlimeChunkCaves.get()).booleanValue()) {
            if (biome.equals(Biomes.f_48207_.m_135782_().toString()) || biome.equals(Biomes.f_48181_.m_135782_().toString()) || event.getCategory() == Biome.BiomeCategory.SWAMP) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.SLIMEY_CHUNK_SWAMP);
            } else if (rand.nextInt(20) == 0) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.SLIMEY_CHUNK_GLOBAL);
            }
        }
        if (biome.equals(((Biome)ExplorerBiomes.FORESTED_MOUNTAIN.get()).getRegistryName().toString())) {
            if (((Boolean)VanillaTweaksConfig.spawnMarbleInForestedMountains.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.MARBLE_MOUNTAIN);
            }
            if (((Boolean)VanillaTweaksConfig.spawnTempleRuins.get()).booleanValue()) {
                // empty if block
            }
            if (((Boolean)VanillaTweaksConfig.spawnRuby.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.RUBY_ORE);
            }
        }
        if (BiomeDictionary.hasType((ResourceKey)biomeResourceKey, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD)) {
            if (((Boolean)VanillaTweaksConfig.spawnMarbleInOverworld.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.MARBLE_GENERAL);
            }
            if (((Boolean)VanillaTweaksConfig.spawnBasaltInOverworld.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.BASALT_GENERAL);
            }
            if (((Boolean)VanillaTweaksConfig.spawnAmethyst.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.AMETHYST_ORE);
            }
        }
        if (((Boolean)VanillaTweaksConfig.spawnNoctilucas.get()).booleanValue() && (biome.equals(Biomes.f_48225_.m_135782_().toString()) || biome.equals(Biomes.f_48171_.m_135782_().toString()) || biome.equals(Biomes.f_48172_.m_135782_().toString()) || biome.equals(Biomes.f_48170_.m_135782_().toString()) || biome.equals(Biomes.f_48169_.m_135782_().toString()))) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Generating noctilucas in " + biome);
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Configured.NOCTILUCAS);
        }
        if (biome.equals(((Biome)ExplorerBiomes.SNOWDONIA.get()).getRegistryName().toString())) {
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_OAK);
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_BIRCH);
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Configured.ASH_TREE);
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_FLOWERS);
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_WILD_LEEKS);
            if (((Boolean)CymruConfig.spawnSlateInSnowdonia.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.SLATE_GEN);
            }
            if (((Boolean)CymruConfig.spawnExtraCoalOre.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.ORE_COAL_EXTRA);
            }
            if (((Boolean)CymruConfig.spawnExtraGoldOre.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Features.f_126985_);
            }
        }
        if (biome.equals(bambooGroveName = ((Biome)ExplorerBiomes.BAMBOO_GROVE.get()).getRegistryName().toString())) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Generating " + biome + " features");
            generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)Configured.BAMBOO_TREE.m_65383_(0.9f), (Object)Configured.CHERRY_TREE.m_65383_(0.01f), (Object)Configured.MAPLE_TREE.m_65383_(0.01f)), Configured.BAMBOO_TREE)).m_7679_(Features.Decorators.f_127091_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(30, 0.1f, 1))));
            if (((Boolean)BambooGroveConfig.spawnJade.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, Configured.JADE_ORE);
            }
            if (((Boolean)BambooGroveConfig.spawnRicePaddies.get()).booleanValue()) {
                generation.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Configured.RICE_PADDY);
            }
            if (((Boolean)BambooGroveConfig.spawnCherryBlossomStructures.get()).booleanValue()) {
                // empty if block
            }
            if (((Boolean)BambooGroveConfig.spawnToriiGates.get()).booleanValue()) {
                // empty if block
            }
        }
    }

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> BAMBOO_TREE = ((Feature)BAMBOO_TREE.get()).m_65815_((FeatureConfiguration)Configs.BAMBOO_TREE_CONFIG).m_7679_(Features.Decorators.f_127091_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> CHERRY_TREE = Feature.f_65760_.m_65815_((FeatureConfiguration)Configs.CHERRY_TREE_CONFIG).m_7679_(Features.Decorators.f_127091_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> MAPLE_TREE = ((Feature)MAPLE_TREE.get()).m_65815_((FeatureConfiguration)Configs.MAPLE_TREE_CONFIG).m_7679_(Features.Decorators.f_127091_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(10, 0.01f, 1)));
        public static final ConfiguredFeature<?, ?> JADE_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)Configs.JADE_ORE_CONFIG).m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)20))).m_64152_();
        public static final ConfiguredFeature<?, ?> AMETHYST_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)Configs.AMETHYST_ORE_CONFIG).m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)40))).m_64152_();
        public static final ConfiguredFeature<?, ?> RUBY_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)Configs.RUBY_ORE_CONFIG).m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)20))).m_64152_();
        public static final ConfiguredFeature<?, ?> RICE_PADDY = ((Feature)RICE_PADDY.get()).m_65815_((FeatureConfiguration)NoneFeatureConfiguration.f_67737_).m_7679_(Features.Decorators.f_176972_);
        public static final ConfiguredFeature<?, ?> SLIMEY_CHUNK_SWAMP = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)SLIMEY_CHUNK.get()).m_65815_((FeatureConfiguration)NoneFeatureConfiguration.f_67737_).m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)40))).m_64152_()).m_64158_(33);
        public static final ConfiguredFeature<?, ?> SLIMEY_CHUNK_GLOBAL = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)SLIMEY_CHUNK.get()).m_65815_((FeatureConfiguration)NoneFeatureConfiguration.f_67737_).m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)40))).m_64152_()).m_64158_(20);
        public static final ConfiguredFeature<?, ?> NOCTILUCAS = (ConfiguredFeature)((Feature)NOCTILUCAS.get()).m_65815_((FeatureConfiguration)new CountConfiguration(80)).m_7679_(Features.Decorators.f_127093_).m_64160_(16);
        public static final ConfiguredFeature<?, ?> MARBLE_MOUNTAIN = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreConfiguration.Predicates.f_67854_, ((Block)VanillaTweaksBlocks.MARBLE.get()).m_49966_(), ((Integer)VanillaTweaksConfig.marbleVeinSizeInForestedMountains.get()).intValue())).m_158245_(VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158922_((int)150))).m_64152_()).m_64158_(((Integer)VanillaTweaksConfig.marbleChanceInForestedMountains.get()).intValue());
        public static final ConfiguredFeature<?, ?> MARBLE_GENERAL = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreConfiguration.Predicates.f_67854_, ((Block)VanillaTweaksBlocks.MARBLE.get()).m_49966_(), ((Integer)VanillaTweaksConfig.marbleVeinSizeInOverworld.get()).intValue())).m_158245_(VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158922_((int)40))).m_64152_()).m_64158_(((Integer)VanillaTweaksConfig.marbleChanceInOverworld.get()).intValue());
        public static final ConfiguredFeature<?, ?> BASALT_GENERAL = (ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreConfiguration.Predicates.f_67854_, ((Block)VanillaTweaksBlocks.BASALT.get()).m_49966_(), ((Integer)VanillaTweaksConfig.basaltVeinSizeInOverworld.get()).intValue())).m_7679_(FeatureDecorator.f_70692_.m_70720_((DecoratorConfiguration)Features.Decorators.f_176978_)).m_64152_()).m_64158_(((Integer)VanillaTweaksConfig.basaltChanceInOverworld.get()).intValue());
        public static final ConfiguredFeature<?, ?> ORE_COAL_EXTRA = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreConfiguration.Predicates.f_67854_, COAL_ORE, 9)).m_158245_(VerticalAnchor.m_158922_((int)30), VerticalAnchor.m_158922_((int)80))).m_64152_()).m_64158_(20);
        public static final ConfiguredFeature<?, ?> SLATE_GEN = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(OreConfiguration.Predicates.f_67854_, ((Block)CymruBlocks.SLATE.get()).m_49966_(), ((Integer)CymruConfig.slateVeinSizeInSnowdonia.get()).intValue())).m_158245_(VerticalAnchor.m_158922_((int)0), VerticalAnchor.m_158922_((int)150))).m_64152_()).m_64158_(((Integer)CymruConfig.slateChanceInSnowdonia.get()).intValue());
        public static final ConfiguredFeature<?, ?> SNOWDONIA_OAK = Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)Features.f_126965_.m_65383_(0.2f), (Object)Features.f_127007_.m_65383_(0.1f)), Features.f_126964_)).m_7679_(Decorators.WORLD_SURFACE_LOWER_THAN_100).m_7679_(Features.Decorators.f_127091_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(15, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> SNOWDONIA_BIRCH = Feature.f_65754_.m_65815_((FeatureConfiguration)new RandomFeatureConfiguration((List)ImmutableList.of((Object)Features.f_126960_.m_65383_(0.5f)), Features.f_126966_)).m_7679_(Decorators.WORLD_SURFACE_LOWER_THAN_100).m_7679_(Features.Decorators.f_127091_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(10, 0.5f, 1)));
        public static final ConfiguredFeature<?, ?> SNOWDONIA_FLOWERS = (ConfiguredFeature)Feature.f_65761_.m_65815_((FeatureConfiguration)Configs.SNOWDONIA_FLOWER_CONFIG).m_7679_(Features.Decorators.f_127090_).m_7679_(Features.Decorators.f_127091_).m_64158_(2);
        public static final ConfiguredFeature<?, ?> SNOWDONIA_WILD_LEEKS = (ConfiguredFeature)Feature.f_65763_.m_65815_((FeatureConfiguration)Configs.SNOWDONIA_WILD_LEEKS_CONFIG).m_7679_(Decorators.WORLD_SURFACE_HIGHER_THAN_100).m_7679_(Features.Decorators.f_127092_).m_158241_(10);
        public static final ConfiguredFeature<?, ?> ASH_TREE = ((Feature)ASH_TREE.get()).m_65815_((FeatureConfiguration)Configs.ASH_TREE_CONFIG).m_7679_(Decorators.WORLD_SURFACE_HIGHER_THAN_100).m_7679_(Features.Decorators.f_127091_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(0, 0.1f, 1)));

        public static void registerConfiguredFeatures() {
            Configured.register("bamboo_tree", BAMBOO_TREE);
            Configured.register("cherry_tree", CHERRY_TREE);
            Configured.register("maple_tree", MAPLE_TREE);
            Configured.register("jade_ore", JADE_ORE);
            Configured.register("amethyst_ore", AMETHYST_ORE);
            Configured.register("ruby_ore", RUBY_ORE);
            Configured.register("rice_paddy", RICE_PADDY);
            Configured.register("slimey_chunk_swamp", SLIMEY_CHUNK_SWAMP);
            Configured.register("slimey_chunk_global", SLIMEY_CHUNK_GLOBAL);
            Configured.register("noctilucas", NOCTILUCAS);
            Configured.register("marble_mountain", MARBLE_MOUNTAIN);
            Configured.register("marble_general", MARBLE_GENERAL);
            Configured.register("basalt_general", BASALT_GENERAL);
            Configured.register("ore_coal_extra", ORE_COAL_EXTRA);
            Configured.register("slate_generation", SLATE_GEN);
            Configured.register("snowdonia_flowers", SNOWDONIA_FLOWERS);
            Configured.register("snowdonia_oak", SNOWDONIA_OAK);
            Configured.register("snowdonia_birch", SNOWDONIA_BIRCH);
            Configured.register("snowdonia_wild_leeks", SNOWDONIA_WILD_LEEKS);
            Configured.register("ash_tree", ASH_TREE);
        }

        private static <FC extends FeatureConfiguration> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("explorercraft", name), configuredFeature);
        }
    }

    public static final class Decorators {
        public static final ConfiguredDecorator<HeightmapConfiguration> WORLD_SURFACE_HIGHER_THAN_100 = ((FeatureDecorator)ExplorerPlacement.HIGHER_THAN_100.get()).m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.WORLD_SURFACE_WG));
        public static final ConfiguredDecorator<HeightmapConfiguration> WORLD_SURFACE_LOWER_THAN_100 = ((FeatureDecorator)ExplorerPlacement.LOWER_THAN_100.get()).m_70720_((DecoratorConfiguration)new HeightmapConfiguration(Heightmap.Types.WORLD_SURFACE_WG));
    }

    public static final class Configs {
        public static final TreeConfiguration BAMBOO_TREE_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((BambooLogBlock)BambooGroveBlocks.BAMBOO_LOG.get()).m_49966_()), (TrunkPlacer)new BambooTruckPlacer(12, 10, 0), (BlockStateProvider)new SimpleStateProvider(((Block)BambooGroveBlocks.BAMBOO_LEAVES.get()).m_49966_()), (BlockStateProvider)new SimpleStateProvider(((Block)BambooGroveBlocks.BAMBOO_SAPLING.get()).m_49966_()), (FoliagePlacer)new BambooFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.m_146483_((int)1), 6), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68244_().m_68251_();
        public static final TreeConfiguration CHERRY_TREE_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((RotatedPillarBlock)BambooGroveBlocks.CHERRY_LOG.get()).m_49966_()), (TrunkPlacer)new FancyTrunkPlacer(6, 6, 0), (BlockStateProvider)new SimpleStateProvider(((Block)BambooGroveBlocks.CHERRY_LEAVES.get()).m_49966_()), (BlockStateProvider)new SimpleStateProvider(((Block)BambooGroveBlocks.CHERRY_SAPLING.get()).m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_().m_68251_();
        public static final TreeConfiguration MAPLE_TREE_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((RotatedPillarBlock)BambooGroveBlocks.MAPLE_LOG.get()).m_49966_()), (TrunkPlacer)new ForkingTrunkPlacer(4, 2, 2), (BlockStateProvider)new SimpleStateProvider(((Block)BambooGroveBlocks.MAPLE_LEAVES.get()).m_49966_()), (BlockStateProvider)new SimpleStateProvider(((Block)BambooGroveBlocks.MAPLE_SAPLING.get()).m_49966_()), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_();
        public static final TreeConfiguration ASH_TREE_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((RotatedPillarBlock)CymruBlocks.ASH_LOG.get()).m_49966_()), (TrunkPlacer)new AshTreeTrunkPlacer(20, 2, 0), (BlockStateProvider)new SimpleStateProvider(((Block)CymruBlocks.ASH_LEAVES.get()).m_49966_()), (BlockStateProvider)new SimpleStateProvider(((Block)CymruBlocks.ASH_SAPLING.get()).m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1, OptionalInt.of(4))).m_68244_().m_68251_();
        public static final OreConfiguration JADE_ORE_CONFIG = new OreConfiguration(OreConfiguration.Predicates.f_161028_, ((Block)BambooGroveBlocks.JADE_ORE.get()).m_49966_(), 8);
        public static final OreConfiguration RUBY_ORE_CONFIG = new OreConfiguration(OreConfiguration.Predicates.f_161028_, ((Block)VanillaTweaksBlocks.RUBY_ORE.get()).m_49966_(), 8);
        public static final OreConfiguration AMETHYST_ORE_CONFIG = new OreConfiguration(OreConfiguration.Predicates.f_161028_, ((Block)VanillaTweaksBlocks.AMETHYST_ORE.get()).m_49966_(), 8);
        public static final RandomPatchConfiguration SNOWDONIA_FLOWER_CONFIG = new RandomPatchConfiguration.GrassConfigurationBuilder((BlockStateProvider)new SnowdoniaFlowerBlockStateProvider(((Block)CymruBlocks.DAFFODIL.get()).m_49966_()), (BlockPlacer)SimpleBlockPlacer.f_67529_).m_67991_(64).m_68003_();
        public static final RandomPatchConfiguration SNOWDONIA_WILD_LEEKS_CONFIG = new RandomPatchConfiguration.GrassConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((Block)CymruBlocks.LEEK_WILD.get()).m_49966_()), (BlockPlacer)SimpleBlockPlacer.f_67529_).m_67991_(64).m_67993_((Set)ImmutableSet.of((Object)Blocks.f_50440_)).m_67995_().m_68003_();
    }
}

