/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.setup;

import dev.driscollcreations.explorercraft.bamboogrove.world.BambooGroveBiome;
import dev.driscollcreations.explorercraft.config.BambooGroveConfig;
import dev.driscollcreations.explorercraft.config.CymruConfig;
import dev.driscollcreations.explorercraft.config.VanillaTweaksConfig;
import dev.driscollcreations.explorercraft.cymru.world.SnowdoniaBiome;
import java.util.Objects;
import net.minecraft.data.worldgen.biome.VanillaBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExplorerBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"explorercraft");
    public static final RegistryObject<Biome> BAMBOO_GROVE = BIOMES.register("bamboo_grove", BambooGroveBiome::makeBambooGrove);
    public static final RegistryObject<Biome> FORESTED_MOUNTAIN = BIOMES.register("forested_mountain", () -> VanillaBiomes.m_127452_((float)0.1f, (float)1.3f));
    public static final RegistryObject<Biome> SNOWDONIA = BIOMES.register("snowdonia", SnowdoniaBiome::makeSnowdoniaBiome);

    @Mod.EventBusSubscriber(modid="explorercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void setupBiomes(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                RegistrationHandler.setupBiome((Biome)BAMBOO_GROVE.get(), (Boolean)BambooGroveConfig.spawnBambooGroves.get(), (Integer)BambooGroveConfig.bambooGroveRarity.get(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.OVERWORLD);
                RegistrationHandler.setupBiome((Biome)FORESTED_MOUNTAIN.get(), (Boolean)VanillaTweaksConfig.spawnForestedMountain.get(), (Integer)VanillaTweaksConfig.forestedMountainRarity.get(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD);
                RegistrationHandler.setupBiome((Biome)SNOWDONIA.get(), (Boolean)CymruConfig.spawnSnowdonia.get(), (Integer)CymruConfig.snowdoniaRarity.get(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD);
            });
        }

        private static void setupBiome(Biome biome, Boolean allowed, int weight, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
            if (allowed.booleanValue()) {
                BiomeDictionary.addTypes(RegistrationHandler.key(biome), (BiomeDictionary.Type[])types);
                BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistrationHandler.key(biome), weight));
            }
        }

        private static ResourceKey<Biome> key(Biome biome) {
            return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome), "Biome registry name was null"));
        }
    }
}

