/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.setup;

import com.google.common.collect.Maps;
import dev.driscollcreations.explorercraft.setup.ExplorerCreativeModeTabs;
import dev.driscollcreations.explorercraft.setup.ExplorerRarity;
import dev.driscollcreations.explorercraft.setup.Registration;
import java.util.Map;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.fmllegacy.RegistryObject;

public class ExplorerBannerPattern {
    private static final Item.Properties PATTERN_PROPS = new Item.Properties().m_41487_(1).m_41491_(ExplorerCreativeModeTabs.EXPLORERCRAFT).m_41497_(ExplorerRarity.WELSH);
    public static final Map<BannerPattern, RegistryObject<BannerPatternItem>> PATTERN_ITEMS = Maps.newHashMap();
    public static BannerPattern WELSH_FLAG;
    public static BannerPattern WALES;

    public static void init() {
        WELSH_FLAG = ExplorerBannerPattern.addBanner("welshflag", true);
        WALES = ExplorerBannerPattern.addBanner("wales", true);
    }

    public static BannerPattern addBanner(String name, Boolean requiresItem) {
        BannerPattern pattern = BannerPattern.create((String)name.toUpperCase(), (String)name, (String)("explorercraft." + name), (boolean)true);
        if (requiresItem.booleanValue()) {
            String itemName = name + "_banner_pattern";
            RegistryObject item = Registration.ITEMS.register(itemName, () -> new BannerPatternItem(pattern, PATTERN_PROPS));
            PATTERN_ITEMS.put(pattern, (RegistryObject<BannerPatternItem>)item);
        }
        return pattern;
    }
}

