/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.data.client;

import dev.driscollcreations.explorercraft.bamboogrove.blocks.BambooLogBlock;
import dev.driscollcreations.explorercraft.bamboogrove.blocks.PanelBlock;
import dev.driscollcreations.explorercraft.bamboogrove.blocks.RiceBlock;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.cymru.blocks.CymruBlocks;
import dev.driscollcreations.explorercraft.cymru.blocks.LeekBlock;
import dev.driscollcreations.explorercraft.vanillatweaks.blocks.NoctilucaBlock;
import dev.driscollcreations.explorercraft.vanillatweaks.blocks.SleepingBagBlock;
import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ExplorerBlockStateProvider
extends BlockStateProvider {
    public ExplorerBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "explorercraft", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)VanillaTweaksBlocks.SLIMEY_STONE.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.BLACK_HOLE.get());
        this.simpleBlock((Block)BambooGroveBlocks.JADE_BLOCK.get());
        this.simpleBlock((Block)BambooGroveBlocks.JADE_ORE.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.RUBY_BLOCK.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.RUBY_ORE.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.AMETHYST_BLOCK.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.AMETHYST_ORE.get());
        this.axisBlock((RotatedPillarBlock)BambooGroveBlocks.RICE_STRAW_BLOCK.get());
        this.buttonBlock((Block)BambooGroveBlocks.BAMBOO_BUTTON.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("bamboo_button", this.mcLoc("block/button"))).texture("texture", "block/bamboo_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("bamboo_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", "block/bamboo_planks"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("bamboo_button_inventory", this.mcLoc("block/button_inventory"))).texture("texture", "block/bamboo_planks"));
        this.doorBlock((DoorBlock)BambooGroveBlocks.BAMBOO_DOOR.get(), this.modLoc("block/bamboo_door_bottom"), this.modLoc("block/bamboo_door_top"));
        this.fenceBlock((FenceBlock)BambooGroveBlocks.BAMBOO_FENCE.get(), this.modLoc("block/bamboo_planks"));
        this.fenceGateBlock((FenceGateBlock)BambooGroveBlocks.BAMBOO_FENCE_GATE.get(), this.modLoc("block/bamboo_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.BAMBOO_LEAVES.get());
        this.bambooLogBlock((BambooLogBlock)BambooGroveBlocks.BAMBOO_LOG.get());
        this.simpleBlock((Block)BambooGroveBlocks.BAMBOO_PLANKS.get());
        this.simpleBlock((Block)BambooGroveBlocks.BAMBOO_PLANKS_VERTICAL.get());
        this.pressurePlateBlock((Block)BambooGroveBlocks.BAMBOO_PRESSURE_PLATE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("bamboo_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", "block/bamboo_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("bamboo_pressure_plate_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", "block/bamboo_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.BAMBOO_SAPLING.get());
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("bamboo_sapling", this.mcLoc("block/cross"))).texture("cross", "block/bamboo_sapling"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_bamboo_sapling", this.mcLoc("block/flower_pot_cross"))).texture("plant", "block/bamboo_sapling"));
        this.simpleBlock((Block)BambooGroveBlocks.POTTED_BAMBOO_SAPLING.get(), (ModelFile)this.models().getBuilder("block/potted_bamboo_sapling"));
        this.slabBlock((SlabBlock)BambooGroveBlocks.BAMBOO_SLAB.get(), this.modLoc("block/bamboo_planks"), this.modLoc("block/bamboo_planks"));
        this.stairsBlock((StairBlock)BambooGroveBlocks.BAMBOO_STAIRS.get(), this.modLoc("block/bamboo_planks"));
        this.trapdoorBlock((TrapDoorBlock)BambooGroveBlocks.BAMBOO_TRAPDOOR.get(), this.modLoc("block/bamboo_trapdoor"), true);
        this.panelBlock((PanelBlock)BambooGroveBlocks.BAMBOO_PANEL.get(), this.modLoc("block/bamboo_panel_bottom"), this.modLoc("block/bamboo_panel_top"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder("bamboo_sign")).texture("particle", "block/bamboo_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.BAMBOO_STANDING_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/bamboo_sign")));
        this.simpleBlock((Block)BambooGroveBlocks.BAMBOO_WALL_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/bamboo_sign")));
        this.buttonBlock((Block)BambooGroveBlocks.CHERRY_BUTTON.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_button", this.mcLoc("block/button"))).texture("texture", "block/cherry_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", "block/cherry_planks"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_button_inventory", this.mcLoc("block/button_inventory"))).texture("texture", "block/cherry_planks"));
        this.doorBlock((DoorBlock)BambooGroveBlocks.CHERRY_DOOR.get(), this.modLoc("block/cherry_door_bottom"), this.modLoc("block/cherry_door_top"));
        this.fenceBlock((FenceBlock)BambooGroveBlocks.CHERRY_FENCE.get(), this.modLoc("block/cherry_planks"));
        this.fenceGateBlock((FenceGateBlock)BambooGroveBlocks.CHERRY_FENCE_GATE.get(), this.modLoc("block/cherry_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_LEAVES.get());
        this.logBlock((RotatedPillarBlock)BambooGroveBlocks.CHERRY_LOG.get());
        this.logBlock((RotatedPillarBlock)BambooGroveBlocks.CHERRY_STRIPPED_LOG.get());
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_PLANKS.get());
        this.pressurePlateBlock((Block)BambooGroveBlocks.CHERRY_PRESSURE_PLATE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", "block/cherry_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_pressure_plate_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", "block/cherry_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_SAPLING.get());
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_sapling", this.mcLoc("block/cross"))).texture("cross", "block/cherry_sapling"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_cherry_sapling", this.mcLoc("block/flower_pot_cross"))).texture("plant", "block/cherry_sapling"));
        this.simpleBlock((Block)BambooGroveBlocks.POTTED_CHERRY_SAPLING.get(), (ModelFile)this.models().getBuilder("block/potted_cherry_sapling"));
        this.slabBlock((SlabBlock)BambooGroveBlocks.CHERRY_SLAB.get(), this.modLoc("block/cherry_planks"), this.modLoc("block/cherry_planks"));
        this.stairsBlock((StairBlock)BambooGroveBlocks.CHERRY_STAIRS.get(), this.modLoc("block/cherry_planks"));
        this.trapdoorBlock((TrapDoorBlock)BambooGroveBlocks.CHERRY_TRAPDOOR.get(), this.modLoc("block/cherry_trapdoor"), true);
        this.woodBlock((RotatedPillarBlock)BambooGroveBlocks.CHERRY_WOOD.get(), this.modLoc("block/cherry_log"));
        this.woodBlock((RotatedPillarBlock)BambooGroveBlocks.CHERRY_STRIPPED_WOOD.get(), this.modLoc("block/cherry_stripped_log"));
        this.panelBlock((PanelBlock)BambooGroveBlocks.CHERRY_PANEL.get(), this.modLoc("block/cherry_panel_bottom"), this.modLoc("block/cherry_panel_top"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder("cherry_sign")).texture("particle", "block/cherry_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_STANDING_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/cherry_sign")));
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_WALL_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/cherry_sign")));
        this.buttonBlock((Block)BambooGroveBlocks.CHERRY_BLOSSOM_BUTTON.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_blossom_button", this.mcLoc("block/button"))).texture("texture", "block/cherry_blossom_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_blossom_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", "block/cherry_blossom_planks"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_blossom_button_inventory", this.mcLoc("block/button_inventory"))).texture("texture", "block/cherry_blossom_planks"));
        this.doorBlock((DoorBlock)BambooGroveBlocks.CHERRY_BLOSSOM_DOOR.get(), this.modLoc("block/cherry_blossom_door_bottom"), this.modLoc("block/cherry_blossom_door_top"));
        this.fenceBlock((FenceBlock)BambooGroveBlocks.CHERRY_BLOSSOM_FENCE.get(), this.modLoc("block/cherry_blossom_planks"));
        this.fenceGateBlock((FenceGateBlock)BambooGroveBlocks.CHERRY_BLOSSOM_FENCE_GATE.get(), this.modLoc("block/cherry_blossom_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_BLOSSOM_PLANKS.get());
        this.pressurePlateBlock((Block)BambooGroveBlocks.CHERRY_BLOSSOM_PRESSURE_PLATE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_blossom_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", "block/cherry_blossom_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("cherry_blossom_pressure_plate_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", "block/cherry_blossom_planks"));
        this.slabBlock((SlabBlock)BambooGroveBlocks.CHERRY_BLOSSOM_SLAB.get(), this.modLoc("block/cherry_blossom_planks"), this.modLoc("block/cherry_blossom_planks"));
        this.stairsBlock((StairBlock)BambooGroveBlocks.CHERRY_BLOSSOM_STAIRS.get(), this.modLoc("block/cherry_blossom_planks"));
        this.trapdoorBlock((TrapDoorBlock)BambooGroveBlocks.CHERRY_BLOSSOM_TRAPDOOR.get(), this.modLoc("block/cherry_blossom_trapdoor"), true);
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder("cherry_blossom_sign")).texture("particle", "block/cherry_blossom_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_BLOSSOM_STANDING_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/cherry_blossom_sign")));
        this.simpleBlock((Block)BambooGroveBlocks.CHERRY_BLOSSOM_WALL_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/cherry_blossom_sign")));
        this.buttonBlock((Block)BambooGroveBlocks.MAPLE_BUTTON.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("maple_button", this.mcLoc("block/button"))).texture("texture", "block/maple_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("maple_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", "block/maple_planks"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("maple_button_inventory", this.mcLoc("block/button_inventory"))).texture("texture", "block/maple_planks"));
        this.doorBlock((DoorBlock)BambooGroveBlocks.MAPLE_DOOR.get(), this.modLoc("block/maple_door_bottom"), this.modLoc("block/maple_door_top"));
        this.fenceBlock((FenceBlock)BambooGroveBlocks.MAPLE_FENCE.get(), this.modLoc("block/maple_planks"));
        this.fenceGateBlock((FenceGateBlock)BambooGroveBlocks.MAPLE_FENCE_GATE.get(), this.modLoc("block/maple_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.MAPLE_LEAVES.get());
        this.logBlock((RotatedPillarBlock)BambooGroveBlocks.MAPLE_LOG.get());
        this.logBlock((RotatedPillarBlock)BambooGroveBlocks.MAPLE_STRIPPED_LOG.get());
        this.simpleBlock((Block)BambooGroveBlocks.MAPLE_PLANKS.get());
        this.pressurePlateBlock((Block)BambooGroveBlocks.MAPLE_PRESSURE_PLATE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("maple_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", "block/maple_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("maple_pressure_plate_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", "block/maple_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.MAPLE_SAPLING.get());
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("maple_sapling", this.mcLoc("block/cross"))).texture("cross", "block/maple_sapling"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_maple_sapling", this.mcLoc("block/flower_pot_cross"))).texture("plant", "block/maple_sapling"));
        this.simpleBlock((Block)BambooGroveBlocks.POTTED_MAPLE_SAPLING.get(), (ModelFile)this.models().getBuilder("block/potted_maple_sapling"));
        this.slabBlock((SlabBlock)BambooGroveBlocks.MAPLE_SLAB.get(), this.modLoc("block/maple_planks"), this.modLoc("block/maple_planks"));
        this.stairsBlock((StairBlock)BambooGroveBlocks.MAPLE_STAIRS.get(), this.modLoc("block/maple_planks"));
        this.trapdoorBlock((TrapDoorBlock)BambooGroveBlocks.MAPLE_TRAPDOOR.get(), this.modLoc("block/maple_trapdoor"), true);
        this.woodBlock((RotatedPillarBlock)BambooGroveBlocks.MAPLE_WOOD.get(), this.modLoc("block/maple_log"));
        this.woodBlock((RotatedPillarBlock)BambooGroveBlocks.MAPLE_STRIPPED_WOOD.get(), this.modLoc("block/maple_stripped_log"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder("maple_sign")).texture("particle", "block/maple_planks"));
        this.simpleBlock((Block)BambooGroveBlocks.MAPLE_STANDING_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/maple_sign")));
        this.simpleBlock((Block)BambooGroveBlocks.MAPLE_WALL_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/maple_sign")));
        this.simpleBlock((Block)VanillaTweaksBlocks.MARBLE.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.MARBLE_POLISHED.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.MARBLE_BRICKS.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.MARBLE_MOSSY.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.MARBLE_CRACKED.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.MARBLE_CHISELED.get());
        this.axisBlock((RotatedPillarBlock)VanillaTweaksBlocks.MARBLE_PILLAR.get(), this.modLoc("block/marble_pillar"), this.modLoc("block/marble_polished"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.MARBLE_SLAB.get(), this.modLoc("block/marble"), this.modLoc("block/marble"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.MARBLE_POLISHED_SLAB.get(), this.modLoc("block/marble_polished"), this.modLoc("block/marble_polished"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.MARBLE_BRICK_SLAB.get(), this.modLoc("block/marble_bricks"), this.modLoc("block/marble_bricks"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.MARBLE_MOSSY_SLAB.get(), this.modLoc("block/marble_mossy"), this.modLoc("block/marble_mossy"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.MARBLE_STAIRS.get(), this.modLoc("block/marble"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.MARBLE_POLISHED_STAIRS.get(), this.modLoc("block/marble_polished"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.MARBLE_BRICK_STAIRS.get(), this.modLoc("block/marble_bricks"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.MARBLE_MOSSY_STAIRS.get(), this.modLoc("block/marble_mossy"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.MARBLE_WALL.get(), this.modLoc("block/marble"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.MARBLE_BRICK_WALL.get(), this.modLoc("block/marble_bricks"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.MARBLE_MOSSY_WALL.get(), this.modLoc("block/marble_mossy"));
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT_POLISHED.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT_BRICKS.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT_MOSSY.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT_CRACKED.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT_CHISELED.get());
        this.axisBlock((RotatedPillarBlock)VanillaTweaksBlocks.BASALT_PILLAR.get(), this.modLoc("block/basalt_pillar"), this.modLoc("block/basalt_polished"));
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT_COBBLESTONE.get());
        this.simpleBlock((Block)VanillaTweaksBlocks.BASALT_COBBLESTONE_MOSSY.get());
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.BASALT_SLAB.get(), this.modLoc("block/basalt"), this.modLoc("block/basalt"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.BASALT_POLISHED_SLAB.get(), this.modLoc("block/basalt_polished"), this.modLoc("block/basalt_polished"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.BASALT_BRICK_SLAB.get(), this.modLoc("block/basalt_bricks"), this.modLoc("block/basalt_bricks"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.BASALT_MOSSY_SLAB.get(), this.modLoc("block/basalt_mossy"), this.modLoc("block/basalt_mossy"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.BASALT_COBBLESTONE_SLAB.get(), this.modLoc("block/basalt_cobblestone"), this.modLoc("block/basalt_cobblestone"));
        this.slabBlock((SlabBlock)VanillaTweaksBlocks.BASALT_COBBLESTONE_MOSSY_SLAB.get(), this.modLoc("block/basalt_cobblestone_mossy"), this.modLoc("block/basalt_cobblestone_mossy"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.BASALT_STAIRS.get(), this.modLoc("block/basalt"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.BASALT_POLISHED_STAIRS.get(), this.modLoc("block/basalt_polished"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.BASALT_BRICK_STAIRS.get(), this.modLoc("block/basalt_bricks"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.BASALT_MOSSY_STAIRS.get(), this.modLoc("block/basalt_mossy"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.BASALT_COBBLESTONE_STAIRS.get(), this.modLoc("block/basalt_cobblestone"));
        this.stairsBlock((StairBlock)VanillaTweaksBlocks.BASALT_COBBLESTONE_MOSSY_STAIRS.get(), this.modLoc("block/basalt_cobblestone_mossy"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.BASALT_WALL.get(), this.modLoc("block/basalt"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.BASALT_BRICK_WALL.get(), this.modLoc("block/basalt_bricks"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.BASALT_MOSSY_WALL.get(), this.modLoc("block/basalt_mossy"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.BASALT_COBBLESTONE_WALL.get(), this.modLoc("block/basalt_cobblestone"));
        this.wallBlock((WallBlock)VanillaTweaksBlocks.BASALT_COBBLESTONE_MOSSY_WALL.get(), this.modLoc("block/basalt_cobblestone_mossy"));
        this.simpleBlock((Block)CymruBlocks.SLATE.get());
        this.getVariantBuilder((Block)CymruBlocks.SLATE_POLISHED.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("slate_polished", this.mcLoc("block/cube_column"))).texture("end", "block/slate_polished_top")).texture("side", "block/slate_polished_top"))});
        this.simpleBlock((Block)CymruBlocks.SLATE_BRICKS.get());
        this.simpleBlock((Block)CymruBlocks.SLATE_MOSSY.get());
        this.simpleBlock((Block)CymruBlocks.SLATE_TILE.get());
        this.getVariantBuilder((Block)CymruBlocks.SLATE_CHISELED.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("slate_chiseled", this.mcLoc("block/cube_column"))).texture("end", "block/slate_polished_top")).texture("side", "block/slate_chiseled"))});
        this.getVariantBuilder((Block)CymruBlocks.SLATE_WELSH.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("slate_welsh", this.mcLoc("block/cube_column"))).texture("end", "block/slate_polished_top")).texture("side", "block/slate_chiseled_red"))});
        this.axisBlock((RotatedPillarBlock)CymruBlocks.SLATE_PILLAR.get(), this.modLoc("block/slate_pillar"), this.modLoc("block/slate_polished_top"));
        this.slabBlock((SlabBlock)CymruBlocks.SLATE_SLAB.get(), this.modLoc("block/slate"), this.modLoc("block/slate"));
        this.slabBlock((SlabBlock)CymruBlocks.SLATE_POLISHED_SLAB.get(), this.modLoc("block/slate_polished"), this.modLoc("block/slate_polished_top"));
        this.slabBlock((SlabBlock)CymruBlocks.SLATE_BRICK_SLAB.get(), this.modLoc("block/slate_bricks"), this.modLoc("block/slate_bricks"));
        this.slabBlock((SlabBlock)CymruBlocks.SLATE_MOSSY_SLAB.get(), this.modLoc("block/slate_mossy"), this.modLoc("block/slate_mossy"));
        this.slabBlock((SlabBlock)CymruBlocks.SLATE_TILE_SLAB.get(), this.modLoc("block/slate_tile"), this.modLoc("block/slate_tile"));
        this.stairsBlock((StairBlock)CymruBlocks.SLATE_STAIRS.get(), this.modLoc("block/slate"));
        this.stairsBlock((StairBlock)CymruBlocks.SLATE_POLISHED_STAIRS.get(), this.modLoc("block/slate_polished_top"));
        this.stairsBlock((StairBlock)CymruBlocks.SLATE_BRICK_STAIRS.get(), this.modLoc("block/slate_bricks"));
        this.stairsBlock((StairBlock)CymruBlocks.SLATE_MOSSY_STAIRS.get(), this.modLoc("block/slate_mossy"));
        this.stairsBlock((StairBlock)CymruBlocks.SLATE_TILE_STAIRS.get(), this.modLoc("block/slate_tile"));
        this.wallBlock((WallBlock)CymruBlocks.SLATE_WALL.get(), this.modLoc("block/slate"));
        this.wallBlock((WallBlock)CymruBlocks.SLATE_BRICK_WALL.get(), this.modLoc("block/slate_bricks"));
        this.wallBlock((WallBlock)CymruBlocks.SLATE_MOSSY_WALL.get(), this.modLoc("block/slate_mossy"));
        this.getVariantBuilder((Block)CymruBlocks.DAFFODIL.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("daffodil", this.mcLoc("block/cross"))).texture("cross", "block/daffodil"))});
        this.getVariantBuilder((Block)CymruBlocks.LEEK_WILD.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("leek_wild", this.mcLoc("block/cross"))).texture("cross", "block/leek_wild"))});
        this.getVariantBuilder((Block)CymruBlocks.POTTED_DAFFODIL.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_daffodil", this.mcLoc("block/flower_pot_cross"))).texture("plant", "block/daffodil"))});
        this.getVariantBuilder((Block)CymruBlocks.POTTED_WILD_LEEK.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_wild_leek", this.mcLoc("block/flower_pot_cross"))).texture("plant", "block/potted_wild_leek"))});
        this.getVariantBuilder((Block)BambooGroveBlocks.RICE_BASE.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("rice_base", this.mcLoc("block/crop"))).texture("crop", "block/rice_base"))});
        this.cropModel((Block)BambooGroveBlocks.RICE_TOP.get(), RiceBlock.f_52244_, "rice_stage");
        this.cropModel((Block)VanillaTweaksBlocks.NOCTILUCAS.get(), NoctilucaBlock.AGE, "noctiluca_stage");
        this.cropModel((Block)CymruBlocks.LEEKS.get(), LeekBlock.f_52244_, "leek_stage");
        this.buttonBlock((Block)CymruBlocks.ASH_BUTTON.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("ash_button", this.mcLoc("block/button"))).texture("texture", "block/ash_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("ash_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", "block/ash_planks"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("ash_button_inventory", this.mcLoc("block/button_inventory"))).texture("texture", "block/ash_planks"));
        this.doorBlock((DoorBlock)CymruBlocks.ASH_DOOR.get(), this.modLoc("block/ash_door_bottom"), this.modLoc("block/ash_door_top"));
        this.fenceBlock((FenceBlock)CymruBlocks.ASH_FENCE.get(), this.modLoc("block/ash_planks"));
        this.fenceGateBlock((FenceGateBlock)CymruBlocks.ASH_FENCE_GATE.get(), this.modLoc("block/ash_planks"));
        this.simpleBlock((Block)CymruBlocks.ASH_LEAVES.get());
        this.logBlock((RotatedPillarBlock)CymruBlocks.ASH_LOG.get());
        this.logBlock((RotatedPillarBlock)CymruBlocks.ASH_STRIPPED_LOG.get());
        this.simpleBlock((Block)CymruBlocks.ASH_PLANKS.get());
        this.pressurePlateBlock((Block)CymruBlocks.ASH_PRESSURE_PLATE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("ash_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", "block/ash_planks"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("ash_pressure_plate_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", "block/ash_planks"));
        this.simpleBlock((Block)CymruBlocks.ASH_SAPLING.get());
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("ash_sapling", this.mcLoc("block/cross"))).texture("cross", "block/ash_sapling"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_ash_sapling", this.mcLoc("block/flower_pot_cross"))).texture("plant", "block/ash_sapling"));
        this.simpleBlock((Block)CymruBlocks.POTTED_ASH_SAPLING.get(), (ModelFile)this.models().getBuilder("block/potted_ash_sapling"));
        this.slabBlock((SlabBlock)CymruBlocks.ASH_SLAB.get(), this.modLoc("block/ash_planks"), this.modLoc("block/ash_planks"));
        this.stairsBlock((StairBlock)CymruBlocks.ASH_STAIRS.get(), this.modLoc("block/ash_planks"));
        this.trapdoorBlock((TrapDoorBlock)CymruBlocks.ASH_TRAPDOOR.get(), this.modLoc("block/ash_trapdoor"), true);
        this.woodBlock((RotatedPillarBlock)CymruBlocks.ASH_WOOD.get(), this.modLoc("block/ash_log"));
        this.woodBlock((RotatedPillarBlock)CymruBlocks.ASH_STRIPPED_WOOD.get(), this.modLoc("block/ash_stripped_log"));
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder("ash_sign")).texture("particle", "block/ash_planks"));
        this.simpleBlock((Block)CymruBlocks.ASH_STANDING_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/ash_sign")));
        this.simpleBlock((Block)CymruBlocks.ASH_WALL_SIGN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/ash_sign")));
        this.sleepingBagModels();
    }

    public void cropModel(Block block, IntegerProperty ageProp, String name) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)ageProp);
            if (age == 0 || age == 1) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(name + "0", this.mcLoc("block/crop"))).texture("crop", "block/" + name + "0")).build();
            }
            if (age == 2 || age == 3) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(name + "1", this.mcLoc("block/crop"))).texture("crop", "block/" + name + "1")).build();
            }
            if (age == 4 || age == 5 || age == 6) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(name + "2", this.mcLoc("block/crop"))).texture("crop", "block/" + name + "2")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(name + "3", this.mcLoc("block/crop"))).texture("crop", "block/" + name + "3")).build();
        });
    }

    public void sleepingBag(String color, ResourceLocation head, ResourceLocation foot) {
        ModelFile.ExistingModelFile headModel = this.models().getExistingFile(head);
        ModelFile.ExistingModelFile footModel = this.models().getExistingFile(foot);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("explorercraft", "sleeping_bag_" + color));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ExplorerBlockStateProvider.lambda$sleepingBag$1((ModelFile)footModel, (ModelFile)headModel, arg_0), new Property[0]);
    }

    public void sleepingBagModels() {
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/sleeping_bag/sleeping_bag_foot", this.mcLoc("block/thin_block"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 2.0f, 16.0f).face(Direction.EAST).uvs(8.0f, 1.0f, 12.0f, 1.5f).texture("#sleeping_bag").cullface(Direction.EAST).end().face(Direction.NORTH).uvs(10.0f, 0.5f, 14.0f, 1.0f).texture("#sleeping_bag").cullface(Direction.NORTH).end().face(Direction.WEST).uvs(8.0f, 1.5f, 12.0f, 2.0f).texture("#sleeping_bag").cullface(Direction.WEST).end().face(Direction.UP).uvs(0.0f, 4.0f, 4.0f, 8.0f).texture("#sleeping_bag").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.DOWN).uvs(4.0f, 4.0f, 8.0f, 8.0f).texture("#sleeping_bag").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().end());
        new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/sleeping_bag/sleeping_bag_head", this.mcLoc("block/thin_block"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 2.0f, 16.0f).face(Direction.EAST).uvs(12.0f, 1.5f, 16.0f, 2.0f).texture("#sleeping_bag").cullface(Direction.EAST).end().face(Direction.SOUTH).uvs(10.0f, 0.5f, 14.0f, 1.0f).texture("#sleeping_bag").cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(12.0f, 1.0f, 16.0f, 1.5f).texture("#sleeping_bag").cullface(Direction.WEST).end().face(Direction.UP).uvs(0.0f, 0.0f, 4.0f, 4.0f).texture("#sleeping_bag").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.DOWN).uvs(4.0f, 0.0f, 8.0f, 4.0f).texture("#sleeping_bag").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().end());
        List<String> sleepingBags = Arrays.asList("black", "blue", "brown", "cyan", "gray", "green", "leather", "light_blue", "light_gray", "lime", "magenta", "orange", "pink", "purple", "red", "white", "yellow");
        for (String color : sleepingBags) {
            new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/sleeping_bag/sleeping_bag_" + color + "_head", this.modLoc("block/sleeping_bag/sleeping_bag_head"))).texture("sleeping_bag", this.modLoc("block/sleeping_bag/sleeping_bag_" + color))).texture("particle", this.modLoc("block/sleeping_bag/sleeping_bag_" + color)));
            new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/sleeping_bag/sleeping_bag_" + color + "_foot", this.modLoc("block/sleeping_bag/sleeping_bag_foot"))).texture("sleeping_bag", this.modLoc("block/sleeping_bag/sleeping_bag_" + color))).texture("particle", this.modLoc("block/sleeping_bag/sleeping_bag_" + color)));
            this.sleepingBag(color, this.modLoc("block/sleeping_bag/sleeping_bag_" + color + "_head"), this.modLoc("block/sleeping_bag/sleeping_bag_" + color + "_foot"));
        }
    }

    public void axisBlock(RotatedPillarBlock block, ResourceLocation side, ResourceLocation end) {
        this.axisBlock(block, (ModelFile)this.models().cubeColumn(this.name((Block)block), side, end), (ModelFile)this.models().cubeColumnHorizontal(this.name((Block)block) + "_horizontal", side, end));
    }

    public void bambooLogBlock(BambooLogBlock block) {
        String baseName = block.getRegistryName().toString();
        String texture = "block/bamboo_log";
        this.fourWayBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, "explorercraft:block/bamboo")).texture("texture", texture)).texture("end", "block/bamboo_log_top"), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(baseName + "_side", "explorercraft:block/bamboo_branch")).texture("texture", texture), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(baseName + "_side2", "explorercraft:block/bamboo_branch2")).texture("texture", texture));
    }

    public void fourWayBlock(BambooLogBlock block, ModelFile post, ModelFile side, ModelFile side2) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(post).addModel()).end();
        this.fourWayMultipart(builder, side, side2);
    }

    public void fourWayMultipart(MultiPartBlockStateBuilder builder, ModelFile side, ModelFile side2) {
        PipeBlock.f_55154_.forEach((dir, value) -> {
            if (dir.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).weight(5).nextModel().modelFile(side2).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).weight(5).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true});
            }
        });
    }

    public void pressurePlateBlock(Block block, ModelFile normal, ModelFile powered) {
        this.getVariantBuilder(block).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.FALSE).addModels(new ConfiguredModel[]{new ConfiguredModel(normal)}).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.TRUE).addModels(new ConfiguredModel[]{new ConfiguredModel(powered)});
    }

    public void buttonBlock(Block block, ModelFile normal, ModelFile powered) {
        this.buttonBlock(block, normal, powered, 180);
    }

    public void buttonBlock(Block block, ModelFile normal, ModelFile powered, int angleOffset) {
        this.buttonBlock(block, (BlockState $) -> normal, (BlockState $) -> powered, angleOffset);
    }

    public void buttonBlock(Block block, Function<BlockState, ModelFile> normal, Function<BlockState, ModelFile> pressed) {
        this.buttonBlock(block, normal, pressed, 180);
    }

    public void buttonBlock(Block block, Function<BlockState, ModelFile> normal, Function<BlockState, ModelFile> pressed, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            if (powered.booleanValue()) {
                return ConfiguredModel.builder().modelFile((ModelFile)pressed.apply((BlockState)state)).rotationX(((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)).ordinal() * 90).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset + (state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING ? 180 : 0)) % 360).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)normal.apply((BlockState)state)).rotationX(((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)).ordinal() * 90).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset + (state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING ? 180 : 0)) % 360).build();
        });
    }

    public void woodBlock(RotatedPillarBlock block, ResourceLocation texture) {
        ModelBuilder woodBlockModel = this.models().cubeColumn(this.name((Block)block), texture, texture);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)woodBlockModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)woodBlockModel).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)woodBlockModel).rotationX(90).rotationY(90).addModel();
    }

    private String name(Block block) {
        return block.getRegistryName().m_135815_();
    }

    public void panelBlock(PanelBlock block, ResourceLocation bottom, ResourceLocation top) {
        this.panelBLockInternal(block, block.getRegistryName().toString(), bottom, top);
    }

    private void panelBLockInternal(PanelBlock block, String baseName, ResourceLocation bottom, ResourceLocation top) {
        ModelBuilder bottomLeft = this.models().doorBottomLeft(baseName + "_bottom", bottom, top);
        ModelBuilder topLeft = this.models().doorTopLeft(baseName + "_top", bottom, top);
        this.panelBlock(block, (ModelFile)bottomLeft, (ModelFile)topLeft);
    }

    public void panelBlock(PanelBlock block, ModelFile bottomLeft, ModelFile topLeft) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            return ConfiguredModel.builder().modelFile(state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? bottomLeft : topLeft).rotationY(yRot %= 360).build();
        }, new Property[0]);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$sleepingBag$1(ModelFile footModel, ModelFile headModel, BlockState state) {
        int yRot = (int)((Direction)state.m_61143_((Property)SleepingBagBlock.f_54117_)).m_122435_();
        return ConfiguredModel.builder().modelFile(state.m_61143_(SleepingBagBlock.PART) == BedPart.FOOT ? footModel : headModel).rotationY(yRot).build();
    }
}

