/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.cymru.world;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class AshTreeTrunkPlacer
extends TrunkPlacer {
    public static final Codec<AshTreeTrunkPlacer> CODEC = RecordCodecBuilder.create(p_236883_0_ -> AshTreeTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_236883_0_).apply((Applicative)p_236883_0_, AshTreeTrunkPlacer::new));

    public AshTreeTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return TrunkPlacerType.f_70319_;
    }

    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, Random random, int freeHeight, BlockPos blockPos, TreeConfiguration featureConfig) {
        int j1;
        int j = 20 + random.nextInt(12);
        int k = (int)Math.floor((double)j * 0.618);
        BlockPos dirtPos = blockPos.m_7495_();
        AshTreeTrunkPlacer.m_161880_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)dirtPos, (TreeConfiguration)featureConfig);
        AshTreeTrunkPlacer.m_161880_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)dirtPos.m_142126_(), (TreeConfiguration)featureConfig);
        AshTreeTrunkPlacer.m_161880_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)dirtPos.m_142128_(), (TreeConfiguration)featureConfig);
        AshTreeTrunkPlacer.m_161880_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)dirtPos.m_142128_().m_142126_(), (TreeConfiguration)featureConfig);
        int l = (int)Math.min(1.0, Math.floor(1.382 + Math.pow(1.0 * (double)j / 13.0, 2.0)));
        int i1 = blockPos.m_123342_() + k;
        ArrayList list = Lists.newArrayList();
        list.add(new FoliageCoords(blockPos.m_6630_(j1 - 5), i1));
        for (j1 = j; j1 >= 0; --j1) {
            float f = this.treeShape(j, j1);
            if (f < 0.0f) continue;
            for (int k1 = 0; k1 < l; ++k1) {
                BlockPos blockpos1;
                double d5;
                double d3;
                double d1 = 1.0;
                double d2 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                double d4 = d2 * Math.sin(d3 = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = blockPos.m_142022_(d4, (double)(j1 - 1), d5 = d2 * Math.cos(d3) + 0.5);
                if (!this.makeLimb(reader, consumer, random, blockpos, blockpos1 = blockpos.m_6630_(5), false, featureConfig)) continue;
                int l1 = blockPos.m_123341_() - blockpos.m_123341_();
                int i2 = blockPos.m_123343_() - blockpos.m_123343_();
                double d6 = (double)blockpos.m_123342_() - Math.sqrt(l1 * l1 + i2 * i2) * 0.381;
                int j2 = d6 > (double)i1 ? i1 : (int)d6;
                BlockPos blockpos2 = new BlockPos(blockPos.m_123341_(), j2, blockPos.m_123343_());
                if (!this.makeLimb(reader, consumer, random, blockpos2, blockpos, false, featureConfig)) continue;
                list.add(new FoliageCoords(blockpos, blockpos2.m_123342_()));
            }
        }
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        for (int i2 = 0; i2 < j; ++i2) {
            int j2 = y + i2;
            BlockPos trunkPos = new BlockPos(x, j2, z);
            if (!TreeFeature.m_67267_((LevelSimulatedReader)reader, (BlockPos)trunkPos)) continue;
            AshTreeTrunkPlacer.m_161893_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)trunkPos, (TreeConfiguration)featureConfig);
            AshTreeTrunkPlacer.m_161893_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)trunkPos.m_142126_(), (TreeConfiguration)featureConfig);
            AshTreeTrunkPlacer.m_161893_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)trunkPos.m_142128_(), (TreeConfiguration)featureConfig);
            AshTreeTrunkPlacer.m_161893_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)trunkPos.m_142126_().m_142128_(), (TreeConfiguration)featureConfig);
        }
        this.makeBranches(reader, consumer, random, j, blockPos, list, featureConfig);
        for (int l2 = -1; l2 <= 2; ++l2) {
            for (int i3 = -1; i3 <= 2; ++i3) {
                if (l2 >= 0 && l2 <= 1 && i3 >= 0 && i3 <= 1 || (l2 == -1 || i3 == -1) && (l2 == 2 || i3 == 2) || (i3 == -1 || l2 == 2) && (i3 == 2 || l2 == -1)) continue;
                int j3 = random.nextInt(4) + 2;
                BlockPos dirtPos1 = new BlockPos(x + l2, y, z + i3).m_7495_();
                AshTreeTrunkPlacer.m_161880_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)dirtPos1, (TreeConfiguration)featureConfig);
                for (int k2 = 0; k2 < j3; ++k2) {
                    AshTreeTrunkPlacer.m_161893_((LevelSimulatedReader)reader, consumer, (Random)random, (BlockPos)new BlockPos(x + l2, y + k2, z + i3), (TreeConfiguration)featureConfig);
                }
            }
        }
        ArrayList list1 = Lists.newArrayList();
        for (FoliageCoords fancytrunkplacer$foliage : list) {
            if (!this.trimBranches(j, fancytrunkplacer$foliage.getBranchBase() - blockPos.m_123342_())) continue;
            list1.add(fancytrunkplacer$foliage.attachment);
        }
        return list1;
    }

    private void makeBranches(LevelSimulatedReader p_161808_, BiConsumer<BlockPos, BlockState> p_161809_, Random p_161810_, int p_161811_, BlockPos p_161812_, List<FoliageCoords> p_161813_, TreeConfiguration p_161814_) {
        for (FoliageCoords ashtreetrunkplacer$foliagecoords : p_161813_) {
            int i = ashtreetrunkplacer$foliagecoords.getBranchBase();
            BlockPos blockpos = new BlockPos(p_161812_.m_123341_(), i, p_161812_.m_123343_());
            if (blockpos.equals((Object)ashtreetrunkplacer$foliagecoords.attachment.m_161451_()) || !this.trimBranches(p_161811_, i - p_161812_.m_123342_())) continue;
            this.makeLimb(p_161808_, p_161809_, p_161810_, blockpos, ashtreetrunkplacer$foliagecoords.attachment.m_161451_(), true, p_161814_);
        }
    }

    private float treeShape(int p_236890_1_, int p_236890_2_) {
        if ((float)p_236890_2_ < (float)p_236890_1_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_236890_1_ / 2.0f;
        float f1 = f - (float)p_236890_2_;
        float f2 = (float)Math.sqrt(f * f - f1 * f1);
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    private boolean trimBranches(int p_236885_1_, int p_236885_2_) {
        return (double)p_236885_2_ >= (double)p_236885_1_ * 0.2;
    }

    private boolean makeLimb(LevelSimulatedReader p_236887_1_, BiConsumer<BlockPos, BlockState> p_161817_, Random p_236887_2_, BlockPos p_236887_3_, BlockPos p_236887_4_, boolean p_236887_5_, TreeConfiguration p_236887_8_) {
        if (!p_236887_5_ && Objects.equals(p_236887_3_, p_236887_4_)) {
            return true;
        }
        BlockPos blockpos = p_236887_4_.m_142082_(-p_236887_3_.m_123341_(), -p_236887_3_.m_123342_(), -p_236887_3_.m_123343_());
        int i = this.getSteps(blockpos);
        float f = (float)blockpos.m_123341_() / (float)i;
        float f1 = (float)blockpos.m_123342_() / (float)i;
        float f2 = (float)blockpos.m_123343_() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = p_236887_3_.m_142022_((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (p_236887_5_) {
                TrunkPlacer.m_161886_((LevelSimulatedReader)p_236887_1_, p_161817_, (Random)p_236887_2_, (BlockPos)blockpos1, (TreeConfiguration)p_236887_8_, p_161826_ -> (BlockState)p_161826_.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)this.getLogAxis(p_236887_3_, blockpos1)));
                continue;
            }
            if (TreeFeature.m_67262_((LevelSimulatedReader)p_236887_1_, (BlockPos)blockpos1)) continue;
            return false;
        }
        return true;
    }

    private int getSteps(BlockPos p_236888_1_) {
        int i = Math.abs(p_236888_1_.m_123341_());
        int j = Math.abs(p_236888_1_.m_123342_());
        int k = Math.abs(p_236888_1_.m_123343_());
        return Math.max(i, Math.max(j, k));
    }

    private Direction.Axis getLogAxis(BlockPos p_236889_1_, BlockPos p_236889_2_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_236889_2_.m_123341_() - p_236889_1_.m_123341_());
        int k = Math.max(i, j = Math.abs(p_236889_2_.m_123343_() - p_236889_1_.m_123343_()));
        if (k > 0) {
            direction$axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return direction$axis;
    }

    static class FoliageCoords {
        final FoliagePlacer.FoliageAttachment attachment;
        private final int branchBase;

        public FoliageCoords(BlockPos pAttachmentPos, int pBranchBase) {
            this.attachment = new FoliagePlacer.FoliageAttachment(pAttachmentPos, 0, false);
            this.branchBase = pBranchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

