/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.cymru.blocks;

import dev.driscollcreations.explorercraft.cymru.blocks.DragonHeartBlock;
import dev.driscollcreations.explorercraft.cymru.blocks.trees.AshTree;
import dev.driscollcreations.explorercraft.setup.ExplorerSigns;
import dev.driscollcreations.explorercraft.util.BlockUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fmllegacy.RegistryObject;

public class CymruBlocks {
    public static final WoodType ASH_WOODTYPE = WoodType.create((String)new ResourceLocation("explorercraft", "ash").toString());
    public static final BlockBehaviour.Properties stoneBlockProps = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f);
    public static final RegistryObject<Block> SLATE = BlockUtils.register("slate", () -> new Block(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_POLISHED = BlockUtils.register("slate_polished", () -> new Block(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_BRICKS = BlockUtils.register("slate_bricks", () -> new Block(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_MOSSY = BlockUtils.register("slate_mossy", () -> new Block(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_TILE = BlockUtils.register("slate_tile", () -> new RotatedPillarBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_CHISELED = BlockUtils.register("slate_chiseled", () -> new Block(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_PILLAR = BlockUtils.register("slate_pillar", () -> new RotatedPillarBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_WELSH = BlockUtils.register("slate_welsh", () -> new Block(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_SLAB = BlockUtils.register("slate_slab", () -> new SlabBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_BRICK_SLAB = BlockUtils.register("slate_brick_slab", () -> new SlabBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_MOSSY_SLAB = BlockUtils.register("slate_mossy_slab", () -> new SlabBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_POLISHED_SLAB = BlockUtils.register("slate_polished_slab", () -> new SlabBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_TILE_SLAB = BlockUtils.register("slate_tile_slab", () -> new SlabBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_STAIRS = BlockUtils.register("slate_stairs", () -> new StairBlock(() -> ((Block)((Block)SLATE.get())).m_49966_(), stoneBlockProps));
    public static final RegistryObject<Block> SLATE_BRICK_STAIRS = BlockUtils.register("slate_brick_stairs", () -> new StairBlock(() -> ((Block)((Block)SLATE_BRICKS.get())).m_49966_(), stoneBlockProps));
    public static final RegistryObject<Block> SLATE_MOSSY_STAIRS = BlockUtils.register("slate_mossy_stairs", () -> new StairBlock(() -> ((Block)((Block)SLATE_MOSSY.get())).m_49966_(), stoneBlockProps));
    public static final RegistryObject<Block> SLATE_POLISHED_STAIRS = BlockUtils.register("slate_polished_stairs", () -> new StairBlock(() -> ((Block)((Block)SLATE_POLISHED.get())).m_49966_(), stoneBlockProps));
    public static final RegistryObject<Block> SLATE_TILE_STAIRS = BlockUtils.register("slate_tile_stairs", () -> new StairBlock(() -> ((Block)((Block)SLATE_TILE.get())).m_49966_(), stoneBlockProps));
    public static final RegistryObject<Block> SLATE_WALL = BlockUtils.register("slate_wall", () -> new WallBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_BRICK_WALL = BlockUtils.register("slate_brick_wall", () -> new WallBlock(stoneBlockProps));
    public static final RegistryObject<Block> SLATE_MOSSY_WALL = BlockUtils.register("slate_mossy_wall", () -> new WallBlock(stoneBlockProps));
    public static final RegistryObject<Block> DRAGON_HEART = BlockUtils.register("dragon_heart", () -> new DragonHeartBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76286_, (MaterialColor)MaterialColor.f_76364_).m_60913_(3.0f, 9.0f).m_60953_(light -> 1).m_60955_()));
    public static final RegistryObject<Block> DAFFODIL = BlockUtils.register("daffodil", () -> new FlowerBlock(MobEffects.f_19598_, 6, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> LEEK_WILD = BlockUtils.register("leek_wild", () -> new FlowerBlock(MobEffects.f_19611_, 6, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> LEEKS = BlockUtils.registerNoItem("leeks", () -> new CropBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60918_(SoundType.f_56758_)));
    public static final RegistryObject<Block> POTTED_WILD_LEEK = BlockUtils.registerNoItem("potted_wild_leek", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> LEEK_WILD.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_()));
    public static final RegistryObject<Block> POTTED_DAFFODIL = BlockUtils.registerNoItem("potted_daffodil", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> LEEK_WILD.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_()));
    public static final RegistryObject<Block> ASH_LEAVES = BlockUtils.register("ash_leaves", BlockUtils::createLeavesBlock);
    public static final RegistryObject<RotatedPillarBlock> ASH_LOG = BlockUtils.register("ash_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> ASH_BUTTON = BlockUtils.register("ash_button", BlockUtils::createWoodButton);
    public static final RegistryObject<Block> ASH_DOOR = BlockUtils.register("ash_door", BlockUtils::createWoodDoor);
    public static final RegistryObject<Block> ASH_FENCE = BlockUtils.register("ash_fence", BlockUtils::createWoodFence);
    public static final RegistryObject<Block> ASH_FENCE_GATE = BlockUtils.register("ash_fence_gate", BlockUtils::createWoodFenceGate);
    public static final RegistryObject<Block> ASH_PLANKS = BlockUtils.register("ash_planks", BlockUtils::createWoodBlock);
    public static final RegistryObject<Block> ASH_PRESSURE_PLATE = BlockUtils.register("ash_pressure_plate", BlockUtils::createWoodPressurePlate);
    public static final RegistryObject<Block> ASH_SAPLING = BlockUtils.register("ash_sapling", () -> new SaplingBlock((AbstractTreeGrower)new AshTree(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> POTTED_ASH_SAPLING = BlockUtils.registerNoItem("potted_ash_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> ASH_SAPLING.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_()));
    public static final RegistryObject<Block> ASH_SLAB = BlockUtils.register("ash_slab", BlockUtils::createWoodSlab);
    public static final RegistryObject<Block> ASH_STAIRS = BlockUtils.register("ash_stairs", () -> new StairBlock(() -> ((Block)ASH_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ASH_PLANKS.get()))));
    public static final RegistryObject<Block> ASH_TRAPDOOR = BlockUtils.register("ash_trapdoor", BlockUtils::createWoodTrapdoor);
    public static final RegistryObject<RotatedPillarBlock> ASH_WOOD = BlockUtils.register("ash_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<RotatedPillarBlock> ASH_STRIPPED_LOG = BlockUtils.register("ash_stripped_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<RotatedPillarBlock> ASH_STRIPPED_WOOD = BlockUtils.register("ash_stripped_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 10.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<ExplorerSigns.CustomStandingSignBlock> ASH_STANDING_SIGN = BlockUtils.registerNoItem("ash_sign", () -> new ExplorerSigns.CustomStandingSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), ASH_WOODTYPE));
    public static final RegistryObject<ExplorerSigns.CustomWallSignBlock> ASH_WALL_SIGN = BlockUtils.registerNoItem("ash_wall_sign", () -> new ExplorerSigns.CustomWallSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), ASH_WOODTYPE));

    public static void register() {
    }
}

