/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.bamboogrove.world.feature;

import dev.driscollcreations.explorercraft.bamboogrove.blocks.BambooLogBlock;
import dev.driscollcreations.explorercraft.bamboogrove.blocks.RiceBlock;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.IPlantable;

public class RicePaddyFeature
extends Feature<NoneFeatureConfiguration> {
    private final Block block = Blocks.f_49990_;
    private static final Random randomAge = new Random();
    private static final BlockState water = Blocks.f_49990_.m_49966_();
    private static final BlockState base = ((Block)BambooGroveBlocks.RICE_BASE.get()).m_49966_();

    public RicePaddyFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        Random random = pContext.m_159776_();
        WorldGenLevel world = pContext.m_159774_();
        BlockPos position = pContext.m_159777_();
        position = position.m_142082_(-8, 0, -8);
        while (position.m_123342_() > 5 && world.m_46859_(position)) {
            position = position.m_7495_();
        }
        if (position.m_123342_() <= 4) {
            return false;
        }
        position = position.m_6625_(4);
        boolean[] aboolean = new boolean[2048];
        int i = random.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = random.nextDouble() * 6.0 + 3.0;
            double d1 = random.nextDouble() * 4.0 + 2.0;
            double d2 = random.nextDouble() * 6.0 + 3.0;
            double d3 = random.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && aboolean[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && aboolean[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && aboolean[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && aboolean[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && aboolean[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && aboolean[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = world.m_8055_(position.m_142082_(k1, k, l2)).m_60767_();
                    if (k >= 4 && material.m_76332_()) {
                        return false;
                    }
                    if (k >= 4 || material.m_76333_() || world.m_8055_(position.m_142082_(k1, k, l2)).m_60734_() == this.block) continue;
                    return false;
                }
            }
        }
        ArrayList<BlockPos> possibles = new ArrayList<BlockPos>();
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 5; ++i4) {
                    BlockPos target;
                    if (!aboolean[(l1 * 16 + i3) * 8 + i4]) continue;
                    BlockPos down = target = position.m_142082_(l1, i4, i3);
                    BlockState state = world.m_8055_(down);
                    boolean isSoil = state.m_60734_().canSustainPlant(state, (BlockGetter)world, down, Direction.UP, (IPlantable)((SaplingBlock)Blocks.f_50746_));
                    if (i4 >= 4) {
                        if (world.m_8055_(target) == ((Block)BambooGroveBlocks.RICE_TOP.get()).m_49966_() || world.m_8055_(target) == base || world.m_8055_(target) == ((BambooLogBlock)BambooGroveBlocks.BAMBOO_LOG.get()).m_49966_() || world.m_8055_(target.m_7494_()).m_60734_() == BambooGroveBlocks.BAMBOO_LOG.get() || isSoil) continue;
                        world.m_7731_(target, Blocks.f_50016_.m_49966_(), 2);
                        continue;
                    }
                    if (world.m_8055_(target.m_7494_()).m_60734_() == BambooGroveBlocks.BAMBOO_LOG.get() && isSoil) {
                        world.m_7731_(target, Blocks.f_50493_.m_49966_(), 2);
                        continue;
                    }
                    world.m_7731_(target, Blocks.f_49990_.m_49966_(), 2);
                    Block below = world.m_8055_(target.m_7495_()).m_60734_();
                    if (below != Blocks.f_50493_ && below != Blocks.f_50034_ && below != Blocks.f_49992_) continue;
                    possibles.add(target);
                }
            }
        }
        int riceCount = 0;
        int riceMax = random.nextInt(6) + 1;
        while (riceCount <= riceMax && possibles.size() > 0) {
            BlockPos rice = (BlockPos)possibles.remove(random.nextInt(possibles.size()));
            if (!world.m_46861_(rice.m_7494_()) || !world.m_46859_(rice.m_7494_())) continue;
            BlockState top = (BlockState)((Block)BambooGroveBlocks.RICE_TOP.get()).m_49966_().m_61124_((Property)RiceBlock.f_52244_, (Comparable)Integer.valueOf(randomAge.nextInt(6)));
            world.m_7731_(rice, base, 2);
            world.m_7731_(rice.m_7494_(), top, 3);
            ++riceCount;
        }
        if (this.block.m_49966_().m_60767_() == Material.f_76307_) {
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k3 = 0; k3 < 16; ++k3) {
                    for (int k4 = 0; k4 < 8; ++k4) {
                        boolean flag1;
                        boolean bl = flag1 = !aboolean[(j2 * 16 + k3) * 8 + k4] && (j2 < 15 && aboolean[((j2 + 1) * 16 + k3) * 8 + k4] || j2 > 0 && aboolean[((j2 - 1) * 16 + k3) * 8 + k4] || k3 < 15 && aboolean[(j2 * 16 + k3 + 1) * 8 + k4] || k3 > 0 && aboolean[(j2 * 16 + (k3 - 1)) * 8 + k4] || k4 < 7 && aboolean[(j2 * 16 + k3) * 8 + k4 + 1] || k4 > 0 && aboolean[(j2 * 16 + k3) * 8 + (k4 - 1)]);
                        if (!flag1 || k4 >= 4 && random.nextInt(2) == 0 || !world.m_8055_(position.m_142082_(j2, k4, k3)).m_60767_().m_76333_()) continue;
                        world.m_7731_(position.m_142082_(j2, k4, k3), Blocks.f_50069_.m_49966_(), 2);
                    }
                }
            }
        }
        return true;
    }
}

