/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.bamboogrove.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TatamiBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public TatamiBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return fluidIn == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (fluidStateIn.m_76152_() == Fluids.f_76193_) {
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
                worldIn.m_6217_().m_5945_(pos, (Object)fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == TatamiBlock.getDirectionToOther((BedPart)stateIn.m_61143_(PART), (Direction)stateIn.m_61143_((Property)f_54117_))) {
            return facingState.m_60734_() == this && facingState.m_61143_(PART) != stateIn.m_61143_(PART) ? stateIn : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            worldIn.m_7471_(pos, false);
        }
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BedPart bedpart = (BedPart)state.m_61143_(PART);
        BlockPos blockpos = pos.m_142300_(TatamiBlock.getDirectionToOther(bedpart, (Direction)state.m_61143_((Property)f_54117_)));
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (blockstate.m_60734_() == this && blockstate.m_61143_(PART) != bedpart) {
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
            player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction enumfacing = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_142300_(enumfacing);
        if (context.m_43725_().m_8055_(blockpos).m_60734_() == Blocks.f_49990_) {
            return context.m_43725_().m_8055_(blockpos1).m_60629_(context) && !context.m_43725_().m_8055_(blockpos1.m_7495_()).m_60795_() ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)enumfacing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)) : null;
        }
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) && !context.m_43725_().m_8055_(blockpos1.m_7495_()).m_60795_() ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)enumfacing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomBreakingProgress(BlockState state) {
        return true;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, WATERLOGGED});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_) {
            BlockPos blockpos = pos.m_142300_((Direction)state.m_61143_((Property)f_54117_));
            worldIn.m_7731_(blockpos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.m_46672_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), state.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockpos.m_123341_(), (int)pos.m_123342_(), (int)blockpos.m_123343_());
    }
}

