/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft;

import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveItems;
import dev.driscollcreations.explorercraft.config.Config;
import dev.driscollcreations.explorercraft.cymru.blocks.CymruBlocks;
import dev.driscollcreations.explorercraft.setup.ExplorerBannerPattern;
import dev.driscollcreations.explorercraft.setup.ExplorerConfiguredStructures;
import dev.driscollcreations.explorercraft.setup.ExplorerFeature;
import dev.driscollcreations.explorercraft.setup.ExplorerPlacement;
import dev.driscollcreations.explorercraft.setup.ExplorerTileEntities;
import dev.driscollcreations.explorercraft.setup.Registration;
import dev.driscollcreations.explorercraft.util.EntityEvents;
import dev.driscollcreations.explorercraft.util.ExplorerVanillaCompat;
import dev.driscollcreations.explorercraft.vanillatweaks.client.ClientEvents;
import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksBlocks;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="explorercraft")
public class Explorercraft {
    public static final String MOD_ID = "explorercraft";
    public static final Logger LOGGER = LogManager.getLogger();

    public Explorercraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Registration.register();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::entitySetup);
        modEventBus.addListener(this::doClientStuff);
        ExplorerPlacement.DECORATORS.register(modEventBus);
        ExplorerFeature.FEATURES.register(modEventBus);
        ExplorerTileEntities.TILE_ENTITIES.register(modEventBus);
        ExplorerFeature.FOLIAGE_PLACER_TYPES.register(modEventBus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        Config.init();
        ExplorerBannerPattern.init();
    }

    private void entitySetup(EntityAttributeCreationEvent event) {
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ExplorerFeature.Configured.registerConfiguredFeatures();
            ExplorerConfiguredStructures.registerConfiguredStructures();
            ExplorerVanillaCompat.register();
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BambooGroveBlocks.BAMBOO_SAPLING.getId(), () -> BambooGroveBlocks.POTTED_BAMBOO_SAPLING.get());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BambooGroveBlocks.CHERRY_SAPLING.getId(), () -> BambooGroveBlocks.POTTED_CHERRY_SAPLING.get());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BambooGroveBlocks.MAPLE_SAPLING.getId(), () -> BambooGroveBlocks.POTTED_MAPLE_SAPLING.get());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(CymruBlocks.ASH_SAPLING.getId(), () -> CymruBlocks.POTTED_ASH_SAPLING.get());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(CymruBlocks.LEEK_WILD.getId(), () -> CymruBlocks.POTTED_WILD_LEEK.get());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(CymruBlocks.DAFFODIL.getId(), () -> CymruBlocks.POTTED_DAFFODIL.get());
            WoodType.m_61844_((WoodType)BambooGroveBlocks.BAMBOO_WOODTYPE);
            WoodType.m_61844_((WoodType)BambooGroveBlocks.CHERRY_WOODTYPE);
            WoodType.m_61844_((WoodType)BambooGroveBlocks.CHERRY_BLOSSOM_WOODTYPE);
            WoodType.m_61844_((WoodType)BambooGroveBlocks.MAPLE_WOODTYPE);
            WoodType.m_61844_((WoodType)CymruBlocks.ASH_WOODTYPE);
        });
        EnchantmentCategory.BOW.m_7454_((Item)BambooGroveItems.JADE_BOW.get());
        MinecraftForge.EVENT_BUS.register((Object)new EntityEvents());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::initClient);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.BAMBOO_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.CHERRY_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.MAPLE_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.POTTED_BAMBOO_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.POTTED_CHERRY_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.POTTED_MAPLE_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.BAMBOO_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.MAPLE_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.MAPLE_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.RICE_BASE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BambooGroveBlocks.RICE_TOP.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)VanillaTweaksBlocks.NOCTILUCAS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)VanillaTweaksBlocks.DISSOLVED_STONE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.DAFFODIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.LEEK_WILD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.LEEKS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.POTTED_DAFFODIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.POTTED_DAFFODIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.POTTED_WILD_LEEK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.ASH_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CymruBlocks.POTTED_ASH_SAPLING.get()), (RenderType)RenderType.m_110463_());
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)BambooGroveBlocks.BAMBOO_WOODTYPE);
            Sheets.addWoodType((WoodType)BambooGroveBlocks.CHERRY_WOODTYPE);
            Sheets.addWoodType((WoodType)BambooGroveBlocks.CHERRY_BLOSSOM_WOODTYPE);
            Sheets.addWoodType((WoodType)BambooGroveBlocks.MAPLE_WOODTYPE);
            Sheets.addWoodType((WoodType)CymruBlocks.ASH_WOODTYPE);
        });
    }

    public static ResourceLocation getId(String path) {
        if (path.contains(":")) {
            throw new IllegalArgumentException("path contains namespace");
        }
        return new ResourceLocation(path);
    }
}

