/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.vanillatweaks.world.feature;

import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksBlocks;
import java.util.BitSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;

public class SlimeBlockFeature
extends Feature<NoFeatureConfig> {
    public static final RuleTest NATURAL_STONE = new TagMatchRuleTest((ITag)BlockTags.field_242172_aH);

    public SlimeBlockFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig config) {
        boolean flag;
        ChunkPos chunkpos = new ChunkPos(position);
        boolean bl = flag = SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)world.func_72905_C(), (long)987234911L).nextInt(10) == 0;
        if (random.nextInt(10) == 0 && flag) {
            float f = random.nextFloat() * (float)Math.PI;
            float f1 = 4.125f;
            int i = MathHelper.func_76123_f((float)2.5625f);
            double d0 = (double)position.func_177958_n() + Math.sin(f) * (double)f1;
            double d1 = (double)position.func_177958_n() - Math.sin(f) * (double)f1;
            double d2 = (double)position.func_177952_p() + Math.cos(f) * (double)f1;
            double d3 = (double)position.func_177952_p() - Math.cos(f) * (double)f1;
            int j = 2;
            double d4 = position.func_177956_o() + random.nextInt(3) - 2;
            double d5 = position.func_177956_o() + random.nextInt(3) - 2;
            int k = position.func_177958_n() - MathHelper.func_76123_f((float)f1) - i;
            int l = position.func_177956_o() - 2 - i;
            int i1 = position.func_177952_p() - MathHelper.func_76123_f((float)f1) - i;
            int j1 = 2 * (MathHelper.func_76123_f((float)f1) + i);
            int k1 = 2 * (2 + i);
            for (int l1 = k; l1 <= k + j1; ++l1) {
                for (int i2 = i1; i2 <= i1 + j1; ++i2) {
                    if (l > world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, l1, i2)) continue;
                    return this.doPlace((IWorld)world, random, d0, d1, d2, d3, d4, d5, k, l, i1, j1, k1);
                }
            }
        }
        return false;
    }

    protected boolean doPlace(IWorld world, Random random, double p_207803_4_, double p_207803_6_, double p_207803_8_, double p_207803_10_, double p_207803_12_, double p_207803_14_, int p_207803_16_, int p_207803_17_, int p_207803_18_, int p_207803_19_, int p_207803_20_) {
        int i = 0;
        BitSet bitset = new BitSet(p_207803_19_ * p_207803_20_ * p_207803_19_);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int j = 33;
        double[] adouble = new double[j * 4];
        for (int k = 0; k < j; ++k) {
            float f = (float)k / (float)j;
            double d0 = MathHelper.func_219803_d((double)f, (double)p_207803_4_, (double)p_207803_6_);
            double d2 = MathHelper.func_219803_d((double)f, (double)p_207803_12_, (double)p_207803_14_);
            double d4 = MathHelper.func_219803_d((double)f, (double)p_207803_8_, (double)p_207803_10_);
            double d6 = random.nextDouble() * (double)j / 16.0;
            double d7 = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * f)) + 1.0f) * d6 + 1.0) / 2.0;
            adouble[k * 4 + 0] = d0;
            adouble[k * 4 + 1] = d2;
            adouble[k * 4 + 2] = d4;
            adouble[k * 4 + 3] = d7;
        }
        for (int i3 = 0; i3 < j - 1; ++i3) {
            if (adouble[i3 * 4 + 3] <= 0.0) continue;
            for (int k3 = i3 + 1; k3 < j; ++k3) {
                double d14;
                double d13;
                double d12;
                double d15;
                if (adouble[k3 * 4 + 3] <= 0.0 || !((d15 = adouble[i3 * 4 + 3] - adouble[k3 * 4 + 3]) * d15 > (d12 = adouble[i3 * 4 + 0] - adouble[k3 * 4 + 0]) * d12 + (d13 = adouble[i3 * 4 + 1] - adouble[k3 * 4 + 1]) * d13 + (d14 = adouble[i3 * 4 + 2] - adouble[k3 * 4 + 2]) * d14)) continue;
                if (d15 > 0.0) {
                    adouble[k3 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[i3 * 4 + 3] = -1.0;
            }
        }
        for (int j3 = 0; j3 < j; ++j3) {
            double d11 = adouble[j3 * 4 + 3];
            if (d11 < 0.0) continue;
            double d1 = adouble[j3 * 4 + 0];
            double d3 = adouble[j3 * 4 + 1];
            double d5 = adouble[j3 * 4 + 2];
            int l = Math.max(MathHelper.func_76128_c((double)(d1 - d11)), p_207803_16_);
            int l3 = Math.max(MathHelper.func_76128_c((double)(d3 - d11)), p_207803_17_);
            int i1 = Math.max(MathHelper.func_76128_c((double)(d5 - d11)), p_207803_18_);
            int j1 = Math.max(MathHelper.func_76128_c((double)(d1 + d11)), l);
            int k1 = Math.max(MathHelper.func_76128_c((double)(d3 + d11)), l3);
            int l1 = Math.max(MathHelper.func_76128_c((double)(d5 + d11)), i1);
            for (int i2 = l; i2 <= j1; ++i2) {
                double d8 = ((double)i2 + 0.5 - d1) / d11;
                if (!(d8 * d8 < 1.0)) continue;
                for (int j2 = l3; j2 <= k1; ++j2) {
                    double d9 = ((double)j2 + 0.5 - d3) / d11;
                    if (!(d8 * d8 + d9 * d9 < 1.0)) continue;
                    for (int k2 = i1; k2 <= l1; ++k2) {
                        BlockPos offset;
                        int l2;
                        double d10 = ((double)k2 + 0.5 - d5) / d11;
                        if (!(d8 * d8 + d9 * d9 + d10 * d10 < 1.0) || bitset.get(l2 = i2 - p_207803_16_ + (j2 - p_207803_17_) * p_207803_19_ + (k2 - p_207803_18_) * p_207803_19_ * p_207803_20_)) continue;
                        bitset.set(l2);
                        blockpos$mutable.func_181079_c(i2, j2, k2);
                        for (Direction direction : Direction.Plane.HORIZONTAL) {
                            offset = blockpos$mutable.func_177972_a(direction);
                            if (!NATURAL_STONE.func_215181_a(world.func_180495_p((BlockPos)blockpos$mutable), random) || !world.func_175623_d(offset)) continue;
                            world.func_180501_a((BlockPos)blockpos$mutable, this.getBlock(random), 2);
                            ++i;
                        }
                        for (Direction direction : Direction.Plane.VERTICAL) {
                            offset = blockpos$mutable.func_177972_a(direction);
                            if (!NATURAL_STONE.func_215181_a(world.func_180495_p((BlockPos)blockpos$mutable), random) || !world.func_175623_d(offset)) continue;
                            world.func_180501_a((BlockPos)blockpos$mutable, this.getBlock(random), 2);
                            ++i;
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    public BlockState getBlock(Random random) {
        if (random.nextInt(15) == 0) {
            return Blocks.field_180399_cE.func_176223_P();
        }
        if (random.nextInt(6) == 1) {
            return ((Block)VanillaTweaksBlocks.DISSOLVED_STONE.get()).func_176223_P();
        }
        return ((Block)VanillaTweaksBlocks.SLIMEY_STONE.get()).func_176223_P();
    }
}

