/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.vanillatweaks.tileentities;

import dev.driscollcreations.explorercraft.setup.ExplorerTileEntities;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;

public class BlackHoleTileEntity
extends TileEntity
implements ITickableTileEntity {
    protected boolean inGravity = false;
    public static final int TICKS = 1000;
    private int timer = 1000;
    private Random random = new Random();

    public BlackHoleTileEntity() {
        super((TileEntityType)ExplorerTileEntities.BLACK_HOLE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.timer = compoundNBT.func_74762_e("Timer");
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        compoundNBT.func_74768_a("Timer", this.timer);
        return compoundNBT;
    }

    public void func_73660_a() {
        List entities;
        AxisAlignedBB bb;
        World world = this.func_145831_w();
        BlockPos blockPos = this.func_174877_v();
        --this.timer;
        if (this.timer <= 0) {
            world.func_217377_a(blockPos, false);
            world.func_175713_t(blockPos);
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(blockPos.func_177958_n() - 8, blockPos.func_177956_o() - 8, blockPos.func_177952_p() - 8, blockPos.func_177958_n() + 8, blockPos.func_177956_o() + 8, blockPos.func_177952_p() + 8);
            bb = AxisAlignedBB.func_216363_a((MutableBoundingBox)mutableboundingbox);
            entities = world.func_217357_a(Entity.class, bb);
            if (entities.size() > 0) {
                for (Entity entity : entities) {
                    this.setGravityPull(false);
                }
            }
        }
        this.renderParticles(world, blockPos);
        MutableBoundingBox mutableboundingbox2 = new MutableBoundingBox(blockPos.func_177958_n() - 8, blockPos.func_177956_o() - 8, blockPos.func_177952_p() - 8, blockPos.func_177958_n() + 8, blockPos.func_177956_o() + 8, blockPos.func_177952_p() + 8);
        bb = AxisAlignedBB.func_216363_a((MutableBoundingBox)mutableboundingbox2);
        entities = world.func_217357_a(Entity.class, bb);
        if (entities.size() > 0) {
            for (Entity entity : entities) {
                PlayerEntity player;
                if (entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_184812_l_()) continue;
                double distance = entity.func_70092_e((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
                if (distance > 8.0) {
                    this.setGravityPull(false);
                } else {
                    this.setGravityPull(true);
                }
                if (!this.isInGravityPull()) continue;
                double d6 = entity.func_226277_ct_() - (double)blockPos.func_177958_n() - 0.5;
                double d8 = entity.func_226278_cu_() - (double)blockPos.func_177956_o() - 0.5;
                double d10 = entity.func_226281_cx_() - (double)blockPos.func_177952_p() - 0.5;
                double d11 = MathHelper.func_76133_a((double)(d6 / d6 + d8 / d8 + d10 / d10));
                double d13 = (1.0 - distance) / 0.5 * 15.0;
                entity.func_213293_j((d6 /= d11) / d13, (d8 /= d11) / d13, (d10 /= d11) / d13);
                if (entity.func_233570_aj_()) continue;
                entity.func_213293_j(0.0, d8 / d13, 0.0);
            }
        }
    }

    public void renderParticles(World world, BlockPos blockPos) {
        int dist = 2;
        for (int l = blockPos.func_177958_n() - dist; l <= blockPos.func_177958_n() + dist; ++l) {
            for (int i1 = blockPos.func_177952_p() - dist; i1 <= blockPos.func_177952_p() + dist; ++i1) {
                if (l > blockPos.func_177958_n() - 2 && l < blockPos.func_177958_n() + 2 && i1 == blockPos.func_177952_p() - 1) {
                    i1 = blockPos.func_177952_p() + 2;
                }
                if (this.random.nextInt(16) != 0) continue;
                for (int j1 = blockPos.func_177956_o(); j1 <= blockPos.func_177956_o() + 1; ++j1) {
                    for (int i = 0; i < 10; ++i) {
                        world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, (double)(l - blockPos.func_177958_n()), (double)(j1 - blockPos.func_177956_o()), (double)((float)(i1 - blockPos.func_177952_p()) * 0.5f));
                    }
                }
            }
        }
    }

    public boolean isInGravityPull() {
        return this.inGravity;
    }

    public void setGravityPull(boolean inGravityPull) {
        this.inGravity = inGravityPull;
    }

    public Entity getClosestEntity(World world, double par1, double par3, double par5, double par7) {
        double d = -1.0;
        Entity entity = null;
        BlockPos blockPos = this.func_174877_v();
        MutableBoundingBox mutableboundingbox = new MutableBoundingBox(blockPos.func_177958_n() - 8, blockPos.func_177956_o() - 8, blockPos.func_177952_p() - 8, blockPos.func_177958_n() + 8, blockPos.func_177956_o() + 8, blockPos.func_177952_p() + 8);
        AxisAlignedBB bb = AxisAlignedBB.func_216363_a((MutableBoundingBox)mutableboundingbox);
        for (int i = 0; i < world.func_217357_a(Entity.class, bb).size(); ++i) {
            Entity entity1 = (Entity)world.func_217357_a(Entity.class, bb).get(i);
            double d1 = entity1.func_70092_e(par1, par3, par5);
            if (!(par7 < 0.0) && !(d1 < par7 * par7) || d != -1.0 && !(d1 < d)) continue;
            d = d1;
            entity = entity1;
        }
        return entity;
    }
}

