/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.vanillatweaks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.config.VanillaTweaksConfig;
import dev.driscollcreations.explorercraft.vanillatweaks.blocks.SleepingBagBlock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="explorercraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    public static void initClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEvents::textureStitching);
    }

    public static void textureStitching(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_() == Atlases.field_228744_c_) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Stitching banner textures");
            event.addSprite(new ResourceLocation("entity/banner/wales"));
            event.addSprite(new ResourceLocation("entity/banner/welshflag"));
            Explorercraft.LOGGER.log(Level.DEBUG, "Finished stitching banner textures!");
        }
        if (event.getMap().func_229223_g_() == Atlases.field_228745_d_) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Stitching shield textures");
            event.addSprite(new ResourceLocation("entity/shield/wales"));
            event.addSprite(new ResourceLocation("entity/shield/welshflag"));
            Explorercraft.LOGGER.log(Level.DEBUG, "Finished stitching shield textures!");
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (((Boolean)VanillaTweaksConfig.swimmingHorse.get()).booleanValue()) {
            AbstractHorseEntity horse;
            if (Minecraft.func_71410_x().func_147113_T()) {
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.func_184187_bx() instanceof AbstractHorseEntity && (horse = (AbstractHorseEntity)player.func_184187_bx()).func_70090_H()) {
                horse.func_213317_d(horse.func_213322_ci().func_72441_c(0.0, (double)0.0125f, 0.0));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        PlayerEntity player = evt.getPlayer();
        if (player instanceof RemoteClientPlayerEntity && player.func_213283_Z() == Pose.SLEEPING) {
            player.func_213374_dv().ifPresent(bedPos -> {
                MatrixStack matrixStack = evt.getMatrixStack();
                Block bed = player.field_70170_p.func_180495_p(bedPos).func_177230_c();
                if (bed instanceof SleepingBagBlock) {
                    matrixStack.func_227861_a_(0.0, -0.375, 0.0);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post evt) {
        PlayerEntity player = evt.getPlayer();
        if (player instanceof RemoteClientPlayerEntity && player.func_213283_Z() == Pose.SLEEPING) {
            player.func_213374_dv().ifPresent(bedPos -> {
                MatrixStack matrixStack = evt.getMatrixStack();
                Block bed = player.field_70170_p.func_180495_p(bedPos).func_177230_c();
                if (bed instanceof SleepingBagBlock) {
                    matrixStack.func_227861_a_(0.0, 0.375, 0.0);
                }
            });
        }
    }
}

