/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.util.ExplorercraftResourceLocation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="explorercraft")
public final class LootInjector {
    private LootInjector() {
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Tables.get(event.getName()).ifPresent(injectorName -> {
            Explorercraft.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
            event.getTable().addPool(LootPool.func_216096_a().name("explorercraft_injected").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)injectorName)).func_216044_b());
        });
    }

    public static final class Tables {
        private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
        public static final ResourceLocation CHESTS_NETHER_BRIDGE = Tables.inject(LootTables.field_186425_g);
        public static final ResourceLocation CHESTS_BASTION_TREASURE = Tables.inject(LootTables.field_237380_L_);
        public static final ResourceLocation CHESTS_BASTION_OTHER = Tables.inject(LootTables.field_237381_M_);
        public static final ResourceLocation CHESTS_BASTION_BRIDGE = Tables.inject(LootTables.field_237382_N_);
        public static final ResourceLocation CHESTS_RUINED_PORTAL = Tables.inject(LootTables.field_237384_P_);
        public static final ResourceLocation CHESTS_SIMPLY_DUNGEON = Tables.inject(LootTables.field_186422_d);

        private Tables() {
        }

        public static Collection<ResourceLocation> getValues() {
            return MAP.values();
        }

        public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
            return Optional.ofNullable(MAP.get(lootTable));
        }

        private static ResourceLocation inject(ResourceLocation lootTable) {
            ExplorercraftResourceLocation ret = Explorercraft.getId("inject/" + lootTable.func_110623_a());
            MAP.put(lootTable, ret);
            return ret;
        }
    }
}

