/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveItems;
import dev.driscollcreations.explorercraft.cymru.items.CymruItems;
import dev.driscollcreations.explorercraft.setup.ExplorerStructures;
import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksItems;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="explorercraft")
public final class ExplorerTrades {
    public static final int NOVICE = 1;
    public static final int APPRENTICE = 2;
    public static final int JOURNEYMAN = 3;
    public static final int EXPERT = 4;
    public static final int MASTER = 5;

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mountingEntity = event.getEntityMounting();
        Entity entityBeingMounted = event.getEntityBeingMounted();
        if (mountingEntity instanceof PlayerEntity && entityBeingMounted instanceof AbstractHorseEntity) {
            PlayerEntity player = (PlayerEntity)mountingEntity;
            AbstractHorseEntity horse = (AbstractHorseEntity)entityBeingMounted;
            if (!horse.func_110248_bS() && player.func_184812_l_()) {
                Explorercraft.LOGGER.error("Horse was tamed instantly");
                horse.func_184779_b(player.func_110124_au());
                horse.func_110234_j(true);
            }
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        ExplorerTrades.addWandererTrades(event, new VillagerTrades.ITrade[]{new ExplorerTrade(1, ((Block)BambooGroveBlocks.BAMBOO_SAPLING.get()).func_199767_j(), 1, 3, 1)});
        ExplorerTrades.addRareWandererTrades(event, new VillagerTrades.ITrade[]{new ExplorerTrade(1, ((Block)BambooGroveBlocks.CHERRY_SAPLING.get()).func_199767_j(), 1, 3, 1), new ExplorerTrade(1, ((Block)BambooGroveBlocks.MAPLE_SAPLING.get()).func_199767_j(), 1, 3, 1), new ExplorerTrade(1, ((Item)BambooGroveItems.CHERRY_BLOSSOM.get()).func_199767_j(), 1, 12, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.field_221156_f, 1, new VillagerTrades.ITrade[]{new ExplorerTrade((Item)BambooGroveItems.RICE.get(), 32, 1, 16, 2), new ExplorerTrade((Item)CymruItems.LEEK.get(), 22, 1, 16, 2)});
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.field_221153_c, 3, new VillagerTrades.ITrade[]{new ExplorerTrade((Item)CymruItems.LAMB_SHANK.get(), 7, 1, 16, 5)});
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.field_221155_e, 3, new VillagerTrades.ITrade[]{new ExplorerTrade((Item)VanillaTweaksItems.NOCTILUCA.get(), 5, 1, 8, 5)});
        ExplorerTrades.addVillagerTrades(event, VillagerProfession.field_221154_d, 5, new EmeraldForMapTrade(32, (Structure)ExplorerStructures.TEMPLE_RUINS.get(), MapDecoration.Type.TARGET_X, 12, 10));
    }

    public static void addVillagerTrades(VillagerTradesEvent event, int level, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            ((List)event.getTrades().get(level)).add(trade);
        }
    }

    public static void addVillagerTrades(VillagerTradesEvent event, VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        if (event.getType() == profession) {
            ExplorerTrades.addVillagerTrades(event, level, trades);
        }
    }

    public static void addWandererTrades(WandererTradesEvent event, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            event.getGenericTrades().add(trade);
        }
    }

    public static void addRareWandererTrades(WandererTradesEvent event, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            event.getRareTrades().add(trade);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, int level, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addVillagerTrades(event, level, trades);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addVillagerTrades(event, profession, level, trades);
        }
    }

    public static void addCompatWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addWandererTrades(event, trades);
        }
    }

    public static void addCompatRareWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            ExplorerTrades.addRareWandererTrades(event, trades);
        }
    }

    public static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final int emeraldCost;
        private final Structure<?> destination;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;

        public EmeraldForMapTrade(int emeraldCost, Structure<?> structure, MapDecoration.Type decoration, int maxUsesIn, int xpValueIn) {
            this.emeraldCost = emeraldCost;
            this.destination = structure;
            this.destinationType = decoration;
            this.maxUses = maxUsesIn;
            this.villagerXp = xpValueIn;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random random) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
            BlockPos blockpos = serverworld.func_241117_a_(this.destination, trader.func_233580_cy_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.destinationType);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.destination.func_143025_a().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCost), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }

    public static class ExplorerTrade
    extends BasicTrade {
        public ExplorerTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMult) {
            super(input, input2, output, maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)input, inputCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)output, outputCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp) {
            this(input, inputCount, output, outputCount, maxTrades, xp, 0.15f);
        }

        public ExplorerTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)input, inputCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp) {
            this(input, inputCount, emeraldCount, maxTrades, xp, 0.15f);
        }

        public ExplorerTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)output, outputCount), maxTrades, xp, priceMult);
        }

        public ExplorerTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp) {
            this(emeraldCount, output, outputCount, maxTrades, xp, 0.15f);
        }
    }
}

