/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public final class EmptyTrigger
implements ICriterionTrigger<Instance> {
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();
    private final ResourceLocation id;

    public EmptyTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.computeIfAbsent(playerAdvancements, Listeners::new);
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance createInstance(JsonObject object, ConditionArrayParser conditions) {
        return new Instance(this.id);
    }

    public void trigger(ServerPlayerEntity player) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger();
        }
    }

    static class Listeners {
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();
        private final PlayerAdvancements advancements;

        public Listeners(PlayerAdvancements advancements) {
            this.advancements = advancements;
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void trigger() {
            ArrayList<ICriterionTrigger.Listener<Instance>> listenerList = new ArrayList<ICriterionTrigger.Listener<Instance>>(this.listeners);
            for (ICriterionTrigger.Listener listener : listenerList) {
                listener.func_192159_a(this.advancements);
            }
        }
    }

    public static class Instance
    implements ICriterionInstance {
        private final ResourceLocation id;

        Instance(ResourceLocation id) {
            this.id = id;
        }

        public ResourceLocation func_192244_a() {
            return this.id;
        }

        public JsonObject func_230240_a_(ConditionArraySerializer conditions) {
            return new JsonObject();
        }
    }
}

