/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.util;

import dev.driscollcreations.explorercraft.bamboogrove.blocks.PanelBlock;
import dev.driscollcreations.explorercraft.setup.ExplorerItemGroups;
import dev.driscollcreations.explorercraft.setup.Registration;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.RegistryObject;

public class BlockUtils {
    public static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return Registration.BLOCKS.register(name, block);
    }

    public static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        RegistryObject ret = BlockUtils.registerNoItem(name, block);
        Registration.ITEMS.register(name, () -> new BlockItem((Block)ret.get(), new Item.Properties().func_200916_a(ExplorerItemGroups.EXPLORERCRAFT)));
        return ret;
    }

    public static Block createWoodBlock() {
        return new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
    }

    public static TrapDoorBlock createWoodTrapdoor() {
        return new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(BlockUtils::neverAllowSpawn));
    }

    public static SlabBlock createWoodSlab() {
        return new SlabBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
    }

    public static WoodButtonBlock createWoodButton() {
        return new WoodButtonBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a));
    }

    public static PressurePlateBlock createWoodPressurePlate() {
        return new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a));
    }

    public static DoorBlock createWoodDoor() {
        return new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
    }

    public static PanelBlock createPanel() {
        return new PanelBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_());
    }

    public static FenceBlock createWoodFence() {
        return new FenceBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
    }

    public static FenceGateBlock createWoodFenceGate() {
        return new FenceGateBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
    }

    public static LeavesBlock createLeavesBlock() {
        return new LeavesBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_(BlockUtils::allowsSpawnOnLeaves).func_235842_b_(BlockUtils::isntSolid).func_235847_c_(BlockUtils::isntSolid));
    }

    public static Boolean allowsSpawnOnLeaves(BlockState state, IBlockReader reader, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.field_200781_U || entity == EntityType.field_200783_W;
    }

    public static boolean isntSolid(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public static Boolean neverAllowSpawn(BlockState state, IBlockReader reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    public static RotatedPillarBlock createLogBlock(MaterialColor topColor, MaterialColor barkColor) {
        return new RotatedPillarBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, state -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? topColor : barkColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a));
    }
}

