/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.setup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import dev.driscollcreations.explorercraft.Explorercraft;
import dev.driscollcreations.explorercraft.bamboogrove.blocks.BambooLogBlock;
import dev.driscollcreations.explorercraft.bamboogrove.setup.BambooGroveBlocks;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.BambooFoliagePlacer;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.BambooTruckPlacer;
import dev.driscollcreations.explorercraft.bamboogrove.world.feature.RicePaddyFeature;
import dev.driscollcreations.explorercraft.config.BambooGroveConfig;
import dev.driscollcreations.explorercraft.config.CymruConfig;
import dev.driscollcreations.explorercraft.config.VanillaTweaksConfig;
import dev.driscollcreations.explorercraft.cymru.blocks.CymruBlocks;
import dev.driscollcreations.explorercraft.cymru.world.AshTreeTrunkPlacer;
import dev.driscollcreations.explorercraft.cymru.world.SnowdoniaFlowerBlockStateProvider;
import dev.driscollcreations.explorercraft.setup.ExplorerBiomes;
import dev.driscollcreations.explorercraft.setup.ExplorerConfiguredStructures;
import dev.driscollcreations.explorercraft.setup.ExplorerEntities;
import dev.driscollcreations.explorercraft.setup.ExplorerPlacement;
import dev.driscollcreations.explorercraft.vanillatweaks.setup.VanillaTweaksBlocks;
import dev.driscollcreations.explorercraft.vanillatweaks.world.feature.NoctilucaFeature;
import dev.driscollcreations.explorercraft.vanillatweaks.world.feature.SlimeBlockFeature;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.AcaciaFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.ForkyTrunkPlacer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="explorercraft")
public class ExplorerFeature {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"explorercraft");
    public static final DeferredRegister<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FOLIAGE_PLACER_TYPES, (String)"explorercraft");
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> BAMBOO_TREE = FEATURES.register("bamboo_tree", () -> new TreeFeature(BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> MAPLE_TREE = FEATURES.register("maple_tree", () -> new TreeFeature(BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> ASH_TREE = FEATURES.register("ash_tree", () -> new TreeFeature(BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> RICE_PADDY = FEATURES.register("rice_paddy", RicePaddyFeature::new);
    public static final RegistryObject<Feature<NoFeatureConfig>> SLIMEY_CHUNK = FEATURES.register("slimey_chunk", SlimeBlockFeature::new);
    public static final RegistryObject<Feature<FeatureSpreadConfig>> NOCTILUCAS = FEATURES.register("noctilucas", () -> new NoctilucaFeature((Codec<FeatureSpreadConfig>)FeatureSpreadConfig.field_242797_a));
    protected static final BlockState COAL_ORE = Blocks.field_150365_q.func_176223_P();
    public static final RegistryObject<FoliagePlacerType<BambooFoliagePlacer>> BAMBOO_FOLIAGE_TYPE = FOLIAGE_PLACER_TYPES.register("bamboo_foliage_placer", () -> new FoliagePlacerType(BambooFoliagePlacer.CODEC));

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        String bambooGroveName;
        if (event.getName() == null) {
            return;
        }
        String biome = event.getName().toString();
        Random rand = new Random();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        RegistryKey biomeRegistryKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(event.getName(), "Biome registry name was null"));
        event.getGeneration().getStructures().add(() -> ExplorerConfiguredStructures.CONFIGURED_WIZARD_TOWER);
        if (((Boolean)VanillaTweaksConfig.spawnSlimeChunkCaves.get()).booleanValue()) {
            if (biome.equals(Biomes.field_76780_h.func_240901_a_().toString()) || biome.equals(Biomes.field_150599_m.func_240901_a_().toString()) || event.getCategory() == Biome.Category.SWAMP) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.SLIMEY_CHUNK_SWAMP);
            } else if (rand.nextInt(20) == 0) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.SLIMEY_CHUNK_GLOBAL);
            }
        }
        if (biome.equals(((Biome)ExplorerBiomes.FORESTED_MOUNTAIN.get()).getRegistryName().toString())) {
            if (((Boolean)VanillaTweaksConfig.spawnMarbleInForestedMountains.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.MARBLE_MOUNTAIN);
            }
            if (((Boolean)VanillaTweaksConfig.spawnTempleRuins.get()).booleanValue()) {
                event.getGeneration().getStructures().add(() -> ExplorerConfiguredStructures.CONFIGURED_TEMPLE_RUINS);
            }
            if (((Boolean)VanillaTweaksConfig.spawnRuby.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.RUBY_ORE);
            }
        }
        if (BiomeDictionary.hasType((RegistryKey)biomeRegistryKey, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD)) {
            if (((Boolean)VanillaTweaksConfig.spawnMarbleInOverworld.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.MARBLE_GENERAL);
            }
            if (((Boolean)VanillaTweaksConfig.spawnBasaltInOverworld.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.BASALT_GENERAL);
            }
            if (((Boolean)VanillaTweaksConfig.spawnAmethyst.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.AMETHYST_ORE);
            }
        }
        if (((Boolean)VanillaTweaksConfig.spawnNoctilucas.get()).booleanValue() && (biome.equals(Biomes.field_150575_M.func_240901_a_().toString()) || biome.equals(Biomes.field_203619_Y.func_240901_a_().toString()) || biome.equals(Biomes.field_203620_Z.func_240901_a_().toString()) || biome.equals(Biomes.field_203618_X.func_240901_a_().toString()) || biome.equals(Biomes.field_203617_W.func_240901_a_().toString()))) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Generating noctilucas in " + biome);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.NOCTILUCAS);
        }
        if (biome.equals(((Biome)ExplorerBiomes.SNOWDONIA.get()).getRegistryName().toString())) {
            event.getGeneration().getStructures().add(() -> ExplorerConfiguredStructures.CONFIGURED_SLATE_DUNGEON);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_OAK);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_BIRCH);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.ASH_TREE);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_FLOWERS);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.SNOWDONIA_WILD_LEEKS);
            if (((Boolean)CymruConfig.spawnSlateInSnowdonia.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.SLATE_GEN);
            }
            if (((Boolean)CymruConfig.spawnExtraCoalOre.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.ORE_COAL_EXTRA);
            }
            if (((Boolean)CymruConfig.spawnExtraGoldOre.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.field_243899_bs);
            }
        }
        if (biome.equals(bambooGroveName = ((Biome)ExplorerBiomes.BAMBOO_GROVE.get()).getRegistryName().toString())) {
            Explorercraft.LOGGER.log(Level.DEBUG, "Generating " + biome + " features");
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Configured.BAMBOO_TREE.func_227227_a_(0.9f), (Object)Configured.CHERRY_TREE.func_227227_a_(0.01f), (Object)Configured.MAPLE_TREE.func_227227_a_(0.01f)), Configured.BAMBOO_TREE)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(30, 0.1f, 1))));
            if (((Boolean)BambooGroveConfig.spawnJade.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.JADE_ORE);
            }
            if (((Boolean)BambooGroveConfig.spawnRicePaddies.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.RICE_PADDY);
            }
            if (((Boolean)BambooGroveConfig.spawnCherryBlossomStructures.get()).booleanValue()) {
                event.getGeneration().getStructures().add(() -> ExplorerConfiguredStructures.CONFIGURED_SAKURA_TREE);
            }
            if (((Boolean)BambooGroveConfig.spawnToriiGates.get()).booleanValue()) {
                event.getGeneration().getStructures().add(() -> ExplorerConfiguredStructures.CONFIGURED_TORII_GATE);
            }
        }
        ExplorerEntities.onEntitySpawn(event);
    }

    public static final class Placements {
        public static final ConfiguredPlacement<NoPlacementConfig> WORLD_SURFACE_HIGHER_THAN_100 = ((Placement)ExplorerPlacement.HIGHER_THAN_100.get()).func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e);
        public static final ConfiguredPlacement<NoPlacementConfig> WORLD_SURFACE_LOWER_THAN_100 = ((Placement)ExplorerPlacement.LOWER_THAN_100.get()).func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e);
    }

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> BAMBOO_TREE = ((Feature)BAMBOO_TREE.get()).func_225566_b_((IFeatureConfig)Configs.BAMBOO_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> CHERRY_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)Configs.CHERRY_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> MAPLE_TREE = ((Feature)MAPLE_TREE.get()).func_225566_b_((IFeatureConfig)Configs.MAPLE_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.01f, 1)));
        public static final ConfiguredFeature<?, ?> JADE_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)Configs.JADE_ORE_CONFIG).func_242733_d(24)).func_242728_a();
        public static final ConfiguredFeature<?, ?> AMETHYST_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)Configs.AMETHYST_ORE_CONFIG).func_242733_d(40)).func_242728_a();
        public static final ConfiguredFeature<?, ?> RUBY_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)Configs.RUBY_ORE_CONFIG).func_242733_d(20)).func_242728_a();
        public static final ConfiguredFeature<?, ?> RICE_PADDY = ((Feature)RICE_PADDY.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
        public static final ConfiguredFeature<?, ?> SLIMEY_CHUNK_SWAMP = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)SLIMEY_CHUNK.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(40)).func_242728_a()).func_242731_b(33);
        public static final ConfiguredFeature<?, ?> SLIMEY_CHUNK_GLOBAL = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)SLIMEY_CHUNK.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(40)).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> NOCTILUCAS = (ConfiguredFeature)((Feature)NOCTILUCAS.get()).func_225566_b_((IFeatureConfig)new FeatureSpreadConfig(20)).func_227228_a_(Features.Placements.field_244003_n).func_242729_a(16);
        public static final ConfiguredFeature<?, ?> MARBLE_MOUNTAIN = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)VanillaTweaksBlocks.MARBLE.get()).func_176223_P(), ((Integer)VanillaTweaksConfig.marbleVeinSizeInForestedMountains.get()).intValue())).func_242733_d(150)).func_242728_a()).func_242731_b(((Integer)VanillaTweaksConfig.marbleChanceInForestedMountains.get()).intValue());
        public static final ConfiguredFeature<?, ?> MARBLE_GENERAL = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)VanillaTweaksBlocks.MARBLE.get()).func_176223_P(), ((Integer)VanillaTweaksConfig.marbleVeinSizeInOverworld.get()).intValue())).func_242733_d(40)).func_242728_a()).func_242731_b(((Integer)VanillaTweaksConfig.marbleChanceInOverworld.get()).intValue());
        public static final ConfiguredFeature<?, ?> BASALT_GENERAL = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)VanillaTweaksBlocks.BASALT.get()).func_176223_P(), ((Integer)VanillaTweaksConfig.basaltVeinSizeInOverworld.get()).intValue())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(30, 0, 64))).func_242728_a()).func_242731_b(((Integer)VanillaTweaksConfig.basaltChanceInOverworld.get()).intValue());
        public static final ConfiguredFeature<?, ?> ORE_COAL_EXTRA = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, COAL_ORE, 9)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(32, 32, 80))).func_242728_a()).func_242731_b(20);
        public static final ConfiguredFeature<?, ?> SLATE_GEN = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)CymruBlocks.SLATE.get()).func_176223_P(), ((Integer)CymruConfig.slateVeinSizeInSnowdonia.get()).intValue())).func_242733_d(150)).func_242728_a()).func_242731_b(((Integer)CymruConfig.slateChanceInSnowdonia.get()).intValue());
        public static final ConfiguredFeature<?, ?> SNOWDONIA_OAK = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Features.field_243879_bY.func_227227_a_(0.2f), (Object)Features.field_243921_cd.func_227227_a_(0.1f)), Features.field_243878_bX)).func_227228_a_(Placements.WORLD_SURFACE_LOWER_THAN_100).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(15, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> SNOWDONIA_BIRCH = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Features.field_243874_bT.func_227227_a_(0.5f)), Features.field_243880_bZ)).func_227228_a_(Placements.WORLD_SURFACE_LOWER_THAN_100).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.5f, 1)));
        public static final ConfiguredFeature<?, ?> SNOWDONIA_FLOWERS = (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)Configs.SNOWDONIA_FLOWER_CONFIG).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(2);
        public static final ConfiguredFeature<?, ?> SNOWDONIA_WILD_LEEKS = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Configs.SNOWDONIA_WILD_LEEKS_CONFIG).func_227228_a_(Placements.WORLD_SURFACE_HIGHER_THAN_100).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(10);
        public static final ConfiguredFeature<?, ?> ASH_TREE = ((Feature)ASH_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ASH_TREE_CONFIG).func_227228_a_(Placements.WORLD_SURFACE_HIGHER_THAN_100).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));

        public static void registerConfiguredFeatures() {
            Configured.register("bamboo_tree", BAMBOO_TREE);
            Configured.register("cherry_tree", CHERRY_TREE);
            Configured.register("maple_tree", MAPLE_TREE);
            Configured.register("jade_ore", JADE_ORE);
            Configured.register("amethyst_ore", AMETHYST_ORE);
            Configured.register("ruby_ore", RUBY_ORE);
            Configured.register("rice_paddy", RICE_PADDY);
            Configured.register("slimey_chunk_swamp", SLIMEY_CHUNK_SWAMP);
            Configured.register("slimey_chunk_global", SLIMEY_CHUNK_GLOBAL);
            Configured.register("noctilucas", NOCTILUCAS);
            Configured.register("marble_mountain", MARBLE_MOUNTAIN);
            Configured.register("marble_general", MARBLE_GENERAL);
            Configured.register("basalt_general", BASALT_GENERAL);
            Configured.register("ore_coal_extra", ORE_COAL_EXTRA);
            Configured.register("slate_generation", SLATE_GEN);
            Configured.register("snowdonia_flowers", SNOWDONIA_FLOWERS);
            Configured.register("snowdonia_oak", SNOWDONIA_OAK);
            Configured.register("snowdonia_birch", SNOWDONIA_BIRCH);
            Configured.register("snowdonia_wild_leeks", SNOWDONIA_WILD_LEEKS);
            Configured.register("ash_tree", ASH_TREE);
        }

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("explorercraft", name), configuredFeature);
        }
    }

    public static final class Configs {
        public static final BaseTreeFeatureConfig BAMBOO_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((BambooLogBlock)BambooGroveBlocks.BAMBOO_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)BambooGroveBlocks.BAMBOO_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BambooFoliagePlacer(FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242252_a((int)1), 6), (AbstractTrunkPlacer)new BambooTruckPlacer(12, 10, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_();
        public static final BaseTreeFeatureConfig CHERRY_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)BambooGroveBlocks.CHERRY_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)BambooGroveBlocks.CHERRY_LEAVES.get()).func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(6, 6, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
        public static final BaseTreeFeatureConfig MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)BambooGroveBlocks.MAPLE_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)BambooGroveBlocks.MAPLE_LEAVES.get()).func_176223_P()), (FoliagePlacer)new AcaciaFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new ForkyTrunkPlacer(4, 2, 2), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_236700_a_().func_225568_b_();
        public static final BaseTreeFeatureConfig ASH_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)CymruBlocks.ASH_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)CymruBlocks.ASH_LEAVES.get()).func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new AshTreeTrunkPlacer(20, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1, OptionalInt.of(4))).func_236700_a_().func_225568_b_();
        public static final OreFeatureConfig JADE_ORE_CONFIG = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)BambooGroveBlocks.JADE_ORE.get()).func_176223_P(), 8);
        public static final OreFeatureConfig RUBY_ORE_CONFIG = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)VanillaTweaksBlocks.RUBY_ORE.get()).func_176223_P(), 8);
        public static final OreFeatureConfig AMETHYST_ORE_CONFIG = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)VanillaTweaksBlocks.AMETHYST_ORE.get()).func_176223_P(), 8);
        public static final BlockClusterFeatureConfig SNOWDONIA_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SnowdoniaFlowerBlockStateProvider(((Block)CymruBlocks.DAFFODIL.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig SNOWDONIA_WILD_LEEKS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)CymruBlocks.LEEK_WILD.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i.getBlock())).func_227317_b_().func_227322_d_();
    }
}

