/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.setup;

import dev.driscollcreations.explorercraft.cymru.entity.WizardEntity;
import dev.driscollcreations.explorercraft.vanillatweaks.entity.enderreeper.EnderreeperEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ExplorerEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"explorercraft");
    public static final RegistryObject<EntityType<EnderreeperEntity>> ENDERREEPER = ExplorerEntities.buildEntity(EnderreeperEntity::new, "enderreeper", EntityClassification.MONSTER, 0.7f, 1.3f);
    public static final RegistryObject<EntityType<WizardEntity>> WIZARD = ExplorerEntities.buildEntity(WizardEntity::new, "wizard", EntityClassification.MONSTER, 0.6f, 1.99f);

    public static <T extends Entity> RegistryObject<EntityType<T>> buildEntity(EntityType.IFactory<T> factory, String name, EntityClassification entityClassification, float width, float height) {
        String modName = new ResourceLocation("explorercraft", name).toString();
        return ENTITIES.register(name, () -> EntityType.Builder.func_220322_a((EntityType.IFactory)factory, (EntityClassification)entityClassification).func_220321_a(width, height).func_206830_a(modName));
    }

    public static void onEntitySpawn(BiomeLoadingEvent event) {
        ExplorerEntities.addEntityToSpecificBiomes(event, (EntityType)ENDERREEPER.get(), 50, 1, 1, Biomes.field_201939_S, Biomes.field_201938_R, Biomes.field_201937_Q);
        ExplorerEntities.addEntityToSpecificBiomes(event, (EntityType)ENDERREEPER.get(), 20, 1, 1, Biomes.field_76779_k);
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            ExplorerEntities.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    @SafeVarargs
    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            ExplorerEntities.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomes(MobSpawnInfoBuilder spawns, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = spawns.getSpawner(type.func_220339_d());
        base.add(new MobSpawnInfo.Spawners(type, weight, minCount, maxCount));
    }
}

