/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.data.client;

import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ExplorerItemModelProvider
extends ItemModelProvider {
    List<String> treeTypes = Arrays.asList("bamboo", "cherry", "maple", "ash");
    List<String> oreTypes = Arrays.asList("amethyst", "jade", "ruby");

    public ExplorerItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "explorercraft", existingFileHelper);
    }

    protected void registerModels() {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
        ModelFile.ExistingModelFile itemHandheld = this.getExistingFile(this.mcLoc("item/handheld"));
        ModelFile.ExistingModelFile spawnEgg = this.getExistingFile(this.mcLoc("item/template_spawn_egg"));
        this.buildSpawnEgg((ModelFile)spawnEgg, "enderreeper_spawn_egg");
        this.buildSpawnEgg((ModelFile)spawnEgg, "wizard_spawn_egg");
        this.withExistingParent("jade_block", this.modLoc("block/jade_block"));
        this.withExistingParent("jade_ore", this.modLoc("block/jade_ore"));
        this.withExistingParent("ruby_block", this.modLoc("block/ruby_block"));
        this.withExistingParent("ruby_ore", this.modLoc("block/ruby_ore"));
        this.withExistingParent("amethyst_block", this.modLoc("block/amethyst_block"));
        this.withExistingParent("amethyst_ore", this.modLoc("block/amethyst_ore"));
        this.withExistingParent("slimey_stone", this.modLoc("block/slimey_stone"));
        this.withExistingParent("dissolved_stone", this.modLoc("block/dissolved_stone"));
        this.withExistingParent("black_hole", this.modLoc("block/black_hole"));
        this.withExistingParent("rice_straw_block", this.modLoc("block/rice_straw_block"));
        this.builderMod((ModelFile)itemGenerated, "item/rice");
        this.builderMod((ModelFile)itemGenerated, "item/rice_straw");
        this.builderMod((ModelFile)itemGenerated, "item/cherry_blossom");
        this.builderMod((ModelFile)itemGenerated, "item/rice_bowl");
        this.builderMod((ModelFile)itemGenerated, "item/onigiri");
        this.builderMod((ModelFile)itemGenerated, "item/salmon_sushi");
        this.builderMod((ModelFile)itemGenerated, "item/tamago_sushi");
        this.builderMod((ModelFile)itemGenerated, "item/leek");
        this.builderMod((ModelFile)itemGenerated, "item/dried_fruits");
        this.builderMod((ModelFile)itemGenerated, "item/cheese");
        this.builderMod((ModelFile)itemGenerated, "item/welsh_cakes");
        this.builderMod((ModelFile)itemGenerated, "item/welsh_rarebit");
        this.builderMod((ModelFile)itemGenerated, "item/lamb_shank_raw");
        this.builderMod((ModelFile)itemGenerated, "item/lamb_shank_cooked");
        this.builderMod((ModelFile)itemGenerated, "item/leek_bowl");
        this.builderMod((ModelFile)itemGenerated, "item/cawl_bowl");
        this.builderMod((ModelFile)itemGenerated, "item/welshflag_banner_pattern");
        this.builderMod((ModelFile)itemGenerated, "item/wales_banner_pattern");
        List<String> sleepingBags = Arrays.asList("black", "blue", "brown", "cyan", "gray", "green", "leather", "light_blue", "light_gray", "lime", "magenta", "orange", "pink", "purple", "red", "white", "yellow");
        for (String color : sleepingBags) {
            this.builderMod((ModelFile)itemGenerated, "item/sleeping_bag_" + color);
        }
        this.builderMod((ModelFile)itemGenerated, "item/noctiluca");
        for (String ore : this.oreTypes) {
            this.builderMod((ModelFile)itemGenerated, "item/" + ore);
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_horse_armor");
            this.builderMod((ModelFile)itemHandheld, "item/" + ore + "_axe");
            this.builderMod((ModelFile)itemHandheld, "item/" + ore + "_hoe");
            this.builderMod((ModelFile)itemHandheld, "item/" + ore + "_pickaxe");
            this.builderMod((ModelFile)itemHandheld, "item/" + ore + "_shovel");
            this.builderMod((ModelFile)itemHandheld, "item/" + ore + "_sword");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_helmet");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_chestplate");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_leggings");
            this.builderMod((ModelFile)itemGenerated, "item/" + ore + "_boots");
        }
        this.withExistingParent("cherry_blossom_button", this.modLoc("block/cherry_blossom_button_inventory"));
        this.builderMod((ModelFile)itemGenerated, "item/cherry_blossom_door");
        this.fenceInventory("cherry_blossom_fence", this.modLoc("block/cherry_blossom_planks"));
        this.fenceGate("cherry_blossom_fence_gate", this.modLoc("block/cherry_blossom_planks"));
        this.withExistingParent("cherry_blossom_planks", this.modLoc("block/cherry_blossom_planks"));
        this.withExistingParent("cherry_blossom_pressure_plate", this.modLoc("block/cherry_blossom_pressure_plate"));
        this.withExistingParent("cherry_blossom_slab", this.modLoc("block/cherry_blossom_slab"));
        this.withExistingParent("cherry_blossom_stairs", this.modLoc("block/cherry_blossom_stairs"));
        this.withExistingParent("cherry_blossom_trapdoor", this.modLoc("block/cherry_blossom_trapdoor_bottom"));
        this.builderMod((ModelFile)itemGenerated, "item/cherry_blossom_sign");
        this.builderMod((ModelFile)itemGenerated, "item/cherry_panel");
        this.builderMod((ModelFile)itemGenerated, "item/bamboo_panel");
        for (String tree : this.treeTypes) {
            this.withExistingParent(tree + "_button", this.modLoc("block/" + tree + "_button_inventory"));
            this.builderMod((ModelFile)itemGenerated, "item/" + tree + "_door");
            this.fenceInventory(tree + "_fence", this.modLoc("block/" + tree + "_planks"));
            this.fenceGate(tree + "_fence_gate", this.modLoc("block/" + tree + "_planks"));
            this.withExistingParent(tree + "_leaves", this.modLoc("block/" + tree + "_leaves"));
            this.withExistingParent(tree + "_planks", this.modLoc("block/" + tree + "_planks"));
            if (tree.equals("bamboo")) {
                this.withExistingParent(tree + "_planks_vertical", this.modLoc("block/" + tree + "_planks_vertical"));
                this.bambooInventoryBuilder(tree + "_log", this.modLoc("block/" + tree + "_log"), this.modLoc("block/" + tree + "_log_top"));
            }
            this.withExistingParent(tree + "_pressure_plate", this.modLoc("block/" + tree + "_pressure_plate"));
            this.builderMod((ModelFile)itemGenerated, tree + "_sapling", "block/" + tree + "_sapling");
            this.builderMc((ModelFile)itemGenerated, "potted_" + tree + "_sapling", "item/flower_pot");
            this.builderMod((ModelFile)itemGenerated, "item/" + tree + "_sign");
            this.withExistingParent(tree + "_slab", this.modLoc("block/" + tree + "_slab"));
            this.withExistingParent(tree + "_stairs", this.modLoc("block/" + tree + "_stairs"));
            this.withExistingParent(tree + "_trapdoor", this.modLoc("block/" + tree + "_trapdoor_bottom"));
            if (tree.equals("bamboo")) continue;
            this.withExistingParent(tree + "_log", this.modLoc("block/" + tree + "_log"));
            this.withExistingParent(tree + "_stripped_log", this.modLoc("block/" + tree + "_stripped_log"));
            this.withExistingParent(tree + "_wood", this.modLoc("block/" + tree + "_wood"));
            this.withExistingParent(tree + "_stripped_wood", this.modLoc("block/" + tree + "_stripped_wood"));
        }
        this.withExistingParent("marble", this.modLoc("block/marble"));
        this.withExistingParent("marble_bricks", this.modLoc("block/marble_bricks"));
        this.withExistingParent("marble_polished", this.modLoc("block/marble_polished"));
        this.withExistingParent("marble_mossy", this.modLoc("block/marble_mossy"));
        this.withExistingParent("marble_cracked", this.modLoc("block/marble_cracked"));
        this.withExistingParent("marble_chiseled", this.modLoc("block/marble_chiseled"));
        this.withExistingParent("marble_pillar", this.modLoc("block/marble_pillar"));
        this.withExistingParent("marble_slab", this.modLoc("block/marble_slab"));
        this.withExistingParent("marble_brick_slab", this.modLoc("block/marble_brick_slab"));
        this.withExistingParent("marble_polished_slab", this.modLoc("block/marble_polished_slab"));
        this.withExistingParent("marble_mossy_slab", this.modLoc("block/marble_mossy_slab"));
        this.withExistingParent("marble_stairs", this.modLoc("block/marble_stairs"));
        this.withExistingParent("marble_brick_stairs", this.modLoc("block/marble_brick_stairs"));
        this.withExistingParent("marble_polished_stairs", this.modLoc("block/marble_polished_stairs"));
        this.withExistingParent("marble_mossy_stairs", this.modLoc("block/marble_mossy_stairs"));
        this.wallInventory("marble_wall", this.modLoc("block/marble"));
        this.wallInventory("marble_brick_wall", this.modLoc("block/marble_bricks"));
        this.wallInventory("marble_mossy_wall", this.modLoc("block/marble_mossy"));
        this.withExistingParent("basalt", this.modLoc("block/basalt"));
        this.withExistingParent("basalt_bricks", this.modLoc("block/basalt_bricks"));
        this.withExistingParent("basalt_polished", this.modLoc("block/basalt_polished"));
        this.withExistingParent("basalt_mossy", this.modLoc("block/basalt_mossy"));
        this.withExistingParent("basalt_cracked", this.modLoc("block/basalt_cracked"));
        this.withExistingParent("basalt_chiseled", this.modLoc("block/basalt_chiseled"));
        this.withExistingParent("basalt_pillar", this.modLoc("block/basalt_pillar"));
        this.withExistingParent("basalt_cobblestone", this.modLoc("block/basalt_cobblestone"));
        this.withExistingParent("basalt_cobblestone_mossy", this.modLoc("block/basalt_cobblestone_mossy"));
        this.withExistingParent("basalt_slab", this.modLoc("block/basalt_slab"));
        this.withExistingParent("basalt_brick_slab", this.modLoc("block/basalt_brick_slab"));
        this.withExistingParent("basalt_polished_slab", this.modLoc("block/basalt_polished_slab"));
        this.withExistingParent("basalt_mossy_slab", this.modLoc("block/basalt_mossy_slab"));
        this.withExistingParent("basalt_cobblestone_slab", this.modLoc("block/basalt_cobblestone_slab"));
        this.withExistingParent("basalt_cobblestone_mossy_slab", this.modLoc("block/basalt_cobblestone_mossy_slab"));
        this.withExistingParent("basalt_stairs", this.modLoc("block/basalt_stairs"));
        this.withExistingParent("basalt_brick_stairs", this.modLoc("block/basalt_brick_stairs"));
        this.withExistingParent("basalt_polished_stairs", this.modLoc("block/basalt_polished_stairs"));
        this.withExistingParent("basalt_mossy_stairs", this.modLoc("block/basalt_mossy_stairs"));
        this.withExistingParent("basalt_cobblestone_stairs", this.modLoc("block/basalt_cobblestone_stairs"));
        this.withExistingParent("basalt_cobblestone_mossy_stairs", this.modLoc("block/basalt_cobblestone_mossy_stairs"));
        this.wallInventory("basalt_wall", this.modLoc("block/basalt"));
        this.wallInventory("basalt_brick_wall", this.modLoc("block/basalt_bricks"));
        this.wallInventory("basalt_mossy_wall", this.modLoc("block/basalt_mossy"));
        this.wallInventory("basalt_cobblestone_wall", this.modLoc("block/basalt_cobblestone"));
        this.wallInventory("basalt_cobblestone_mossy_wall", this.modLoc("block/basalt_cobblestone_mossy"));
        this.withExistingParent("slate", this.modLoc("block/slate"));
        this.withExistingParent("slate_bricks", this.modLoc("block/slate_bricks"));
        this.withExistingParent("slate_polished", this.modLoc("block/slate_polished"));
        this.withExistingParent("slate_mossy", this.modLoc("block/slate_mossy"));
        this.withExistingParent("slate_tile", this.modLoc("block/slate_tile"));
        this.withExistingParent("slate_chiseled", this.modLoc("block/slate_chiseled"));
        this.withExistingParent("slate_pillar", this.modLoc("block/slate_pillar"));
        this.withExistingParent("slate_welsh", this.modLoc("block/slate_welsh"));
        this.withExistingParent("slate_slab", this.modLoc("block/slate_slab"));
        this.withExistingParent("slate_brick_slab", this.modLoc("block/slate_brick_slab"));
        this.withExistingParent("slate_polished_slab", this.modLoc("block/slate_polished_slab"));
        this.withExistingParent("slate_mossy_slab", this.modLoc("block/slate_mossy_slab"));
        this.withExistingParent("slate_tile_slab", this.modLoc("block/slate_tile_slab"));
        this.withExistingParent("slate_stairs", this.modLoc("block/slate_stairs"));
        this.withExistingParent("slate_brick_stairs", this.modLoc("block/slate_brick_stairs"));
        this.withExistingParent("slate_polished_stairs", this.modLoc("block/slate_polished_stairs"));
        this.withExistingParent("slate_mossy_stairs", this.modLoc("block/slate_mossy_stairs"));
        this.withExistingParent("slate_tile_stairs", this.modLoc("block/slate_tile_stairs"));
        this.wallInventory("slate_wall", this.modLoc("block/slate"));
        this.wallInventory("slate_brick_wall", this.modLoc("block/slate_bricks"));
        this.wallInventory("slate_mossy_wall", this.modLoc("block/slate_mossy"));
        this.withExistingParent("dragon_heart", this.modLoc("block/dragon_heart"));
        this.builderMod((ModelFile)itemGenerated, "daffodil", "block/daffodil");
        this.builderMod((ModelFile)itemGenerated, "leek_wild", "block/leek_wild");
    }

    private ItemModelBuilder builderMod(ModelFile itemGenerated, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.modLoc(name));
    }

    private ItemModelBuilder builderMc(ModelFile itemGenerated, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.mcLoc(name));
    }

    private ItemModelBuilder buildSpawnEgg(ModelFile itemGenerated, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated);
    }

    private ItemModelBuilder builderMod(ModelFile itemGenerated, String name, String textureLoc) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.modLoc(textureLoc));
    }

    private ItemModelBuilder builderMc(ModelFile itemGenerated, String name, String textureLoc) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(itemGenerated)).texture("layer0", this.mcLoc(textureLoc));
    }

    private ItemModelBuilder bambooInventoryBuilder(String name, ResourceLocation side, ResourceLocation end) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "explorercraft:block/bamboo_inventory")).texture("side", side)).texture("end", end);
    }
}

