/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.cymru.world;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class AshTreeTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<AshTreeTrunkPlacer> CODEC = RecordCodecBuilder.create(p_236883_0_ -> AshTreeTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)p_236883_0_).apply((Applicative)p_236883_0_, AshTreeTrunkPlacer::new));

    public AshTreeTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TrunkPlacerType.field_236924_e_;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader reader, Random random, int freeHeight, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox boundingBox, BaseTreeFeatureConfig featureConfig) {
        int j1;
        int j = 20 + random.nextInt(12);
        int k = MathHelper.func_76128_c((double)((double)j * 0.618));
        if (!featureConfig.field_227372_q_) {
            BlockPos dirtPos = blockPos.func_177977_b();
            AshTreeTrunkPlacer.func_236909_a_((IWorldGenerationReader)reader, (BlockPos)dirtPos);
            AshTreeTrunkPlacer.func_236909_a_((IWorldGenerationReader)reader, (BlockPos)dirtPos.func_177974_f());
            AshTreeTrunkPlacer.func_236909_a_((IWorldGenerationReader)reader, (BlockPos)dirtPos.func_177968_d());
            AshTreeTrunkPlacer.func_236909_a_((IWorldGenerationReader)reader, (BlockPos)dirtPos.func_177968_d().func_177974_f());
        }
        int l = Math.min(1, MathHelper.func_76128_c((double)(1.382 + Math.pow(1.0 * (double)j / 13.0, 2.0))));
        int i1 = blockPos.func_177956_o() + k;
        ArrayList list = Lists.newArrayList();
        list.add(new Foliage(blockPos.func_177981_b(j1 - 5), i1));
        for (j1 = j; j1 >= 0; --j1) {
            float f = this.treeShape(j, j1);
            if (f < 0.0f) continue;
            for (int k1 = 0; k1 < l; ++k1) {
                BlockPos blockpos1;
                double d5;
                double d3;
                double d1 = 1.0;
                double d2 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                double d4 = d2 * Math.sin(d3 = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = blockPos.func_177963_a(d4, (double)(j1 - 1), d5 = d2 * Math.cos(d3) + 0.5);
                if (!this.makeLimb(reader, random, blockpos, blockpos1 = blockpos.func_177981_b(5), false, blockPosSet, boundingBox, featureConfig)) continue;
                int l1 = blockPos.func_177958_n() - blockpos.func_177958_n();
                int i2 = blockPos.func_177952_p() - blockpos.func_177952_p();
                double d6 = (double)blockpos.func_177956_o() - Math.sqrt(l1 * l1 + i2 * i2) * 0.381;
                int j2 = d6 > (double)i1 ? i1 : (int)d6;
                BlockPos blockpos2 = new BlockPos(blockPos.func_177958_n(), j2, blockPos.func_177952_p());
                if (!this.makeLimb(reader, random, blockpos2, blockpos, false, blockPosSet, boundingBox, featureConfig)) continue;
                list.add(new Foliage(blockpos, blockpos2.func_177956_o()));
            }
        }
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (int i2 = 0; i2 < j; ++i2) {
            int j2 = y + i2;
            BlockPos trunkPos = new BlockPos(x, j2, z);
            if (!TreeFeature.func_236412_d_((IWorldGenerationBaseReader)reader, (BlockPos)trunkPos)) continue;
            AshTreeTrunkPlacer.func_236911_a_((IWorldGenerationReader)reader, (Random)random, (BlockPos)trunkPos, blockPosSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)featureConfig);
            AshTreeTrunkPlacer.func_236911_a_((IWorldGenerationReader)reader, (Random)random, (BlockPos)trunkPos.func_177974_f(), blockPosSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)featureConfig);
            AshTreeTrunkPlacer.func_236911_a_((IWorldGenerationReader)reader, (Random)random, (BlockPos)trunkPos.func_177968_d(), blockPosSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)featureConfig);
            AshTreeTrunkPlacer.func_236911_a_((IWorldGenerationReader)reader, (Random)random, (BlockPos)trunkPos.func_177974_f().func_177968_d(), blockPosSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)featureConfig);
        }
        this.makeBranches(reader, random, j, blockPos, list, blockPosSet, boundingBox, featureConfig);
        for (int l2 = -1; l2 <= 2; ++l2) {
            for (int i3 = -1; i3 <= 2; ++i3) {
                if (l2 >= 0 && l2 <= 1 && i3 >= 0 && i3 <= 1 || (l2 == -1 || i3 == -1) && (l2 == 2 || i3 == 2) || (i3 == -1 || l2 == 2) && (i3 == 2 || l2 == -1)) continue;
                int j3 = random.nextInt(4) + 2;
                BlockPos dirtPos = new BlockPos(x + l2, y, z + i3).func_177977_b();
                AshTreeTrunkPlacer.func_236909_a_((IWorldGenerationReader)reader, (BlockPos)dirtPos);
                for (int k2 = 0; k2 < j3; ++k2) {
                    AshTreeTrunkPlacer.func_236911_a_((IWorldGenerationReader)reader, (Random)random, (BlockPos)new BlockPos(x + l2, y + k2, z + i3), blockPosSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)featureConfig);
                }
            }
        }
        ArrayList list1 = Lists.newArrayList();
        for (Foliage fancytrunkplacer$foliage : list) {
            if (!this.trimBranches(j, fancytrunkplacer$foliage.getBranchBase() - blockPos.func_177956_o())) continue;
            list1.add(fancytrunkplacer$foliage.attachment);
        }
        return list1;
    }

    private void makeBranches(IWorldGenerationReader p_236886_1_, Random p_236886_2_, int p_236886_3_, BlockPos p_236886_4_, List<Foliage> p_236886_5_, Set<BlockPos> p_236886_6_, MutableBoundingBox p_236886_7_, BaseTreeFeatureConfig p_236886_8_) {
        for (Foliage fancytrunkplacer$foliage : p_236886_5_) {
            int i = fancytrunkplacer$foliage.getBranchBase();
            BlockPos blockpos = new BlockPos(p_236886_4_.func_177958_n(), i, p_236886_4_.func_177952_p());
            if (blockpos.equals((Object)fancytrunkplacer$foliage.attachment.func_236763_a_()) || !this.trimBranches(p_236886_3_, i - p_236886_4_.func_177956_o())) continue;
            this.makeLimb(p_236886_1_, p_236886_2_, blockpos, fancytrunkplacer$foliage.attachment.func_236763_a_(), true, p_236886_6_, p_236886_7_, p_236886_8_);
        }
    }

    private float treeShape(int p_236890_1_, int p_236890_2_) {
        if ((float)p_236890_2_ < (float)p_236890_1_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_236890_1_ / 2.0f;
        float f1 = f - (float)p_236890_2_;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    private boolean trimBranches(int p_236885_1_, int p_236885_2_) {
        return (double)p_236885_2_ >= (double)p_236885_1_ * 0.2;
    }

    private boolean makeLimb(IWorldGenerationReader p_236887_1_, Random p_236887_2_, BlockPos p_236887_3_, BlockPos p_236887_4_, boolean p_236887_5_, Set<BlockPos> p_236887_6_, MutableBoundingBox p_236887_7_, BaseTreeFeatureConfig p_236887_8_) {
        if (!p_236887_5_ && Objects.equals(p_236887_3_, p_236887_4_)) {
            return true;
        }
        BlockPos blockpos = p_236887_4_.func_177982_a(-p_236887_3_.func_177958_n(), -p_236887_3_.func_177956_o(), -p_236887_3_.func_177952_p());
        int i = this.getSteps(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = p_236887_3_.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (p_236887_5_) {
                AshTreeTrunkPlacer.func_236913_a_((IWorldWriter)p_236887_1_, (BlockPos)blockpos1, (BlockState)((BlockState)p_236887_8_.field_227368_m_.func_225574_a_(p_236887_2_, blockpos1).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)this.getLogAxis(p_236887_3_, blockpos1))), (MutableBoundingBox)p_236887_7_);
                p_236887_6_.add(blockpos1.func_185334_h());
                continue;
            }
            if (TreeFeature.func_236410_c_((IWorldGenerationBaseReader)p_236887_1_, (BlockPos)blockpos1)) continue;
            return false;
        }
        return true;
    }

    private int getSteps(BlockPos p_236888_1_) {
        int i = MathHelper.func_76130_a((int)p_236888_1_.func_177958_n());
        int j = MathHelper.func_76130_a((int)p_236888_1_.func_177956_o());
        int k = MathHelper.func_76130_a((int)p_236888_1_.func_177952_p());
        return Math.max(i, Math.max(j, k));
    }

    private Direction.Axis getLogAxis(BlockPos p_236889_1_, BlockPos p_236889_2_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_236889_2_.func_177958_n() - p_236889_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_236889_2_.func_177952_p() - p_236889_1_.func_177952_p()));
        if (k > 0) {
            direction$axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return direction$axis;
    }

    static class Foliage {
        private final FoliagePlacer.Foliage attachment;
        private final int branchBase;

        public Foliage(BlockPos p_i232055_1_, int p_i232055_2_) {
            this.attachment = new FoliagePlacer.Foliage(p_i232055_1_, 0, false);
            this.branchBase = p_i232055_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

