/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.cymru.entity;

import dev.driscollcreations.explorercraft.cymru.entity.WizardTrades;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WizardEntity
extends AbstractVillagerEntity
implements IMerchant {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(WizardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int spellTime;

    public WizardEntity(EntityType<? extends WizardEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FireballAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(8, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(10, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, p_234199_0_ -> p_234199_0_ instanceof IMob && !(p_234199_0_ instanceof CreeperEntity)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)Boolean.FALSE);
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (this.func_213706_dY().isEmpty()) {
                this.setUnhappy();
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(5) == 0) {
                    this.field_213724_bz = null;
                    this.setUnhappy();
                }
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_213713_b(MerchantOffer merchantOffer) {
        if (merchantOffer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] itemsForScales = (VillagerTrades.ITrade[])WizardTrades.WIZARD_TRADES.get(1);
        VillagerTrades.ITrade[] scalesForItems = (VillagerTrades.ITrade[])WizardTrades.WIZARD_TRADES.get(2);
        VillagerTrades.ITrade[] scalesForWelshItems = (VillagerTrades.ITrade[])WizardTrades.WIZARD_TRADES.get(3);
        if (itemsForScales != null && scalesForItems != null && scalesForWelshItems != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, itemsForScales, 5);
            this.func_213717_a(merchantoffers, scalesForItems, 3);
            this.func_213717_a(merchantoffers, scalesForWelshItems, 2);
        }
    }

    private void setUnhappy() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213719_ec() > 0) {
            this.func_213720_r(this.func_213719_ec() - 1);
        }
        if (this.field_70170_p.field_72995_K && this.isCharged()) {
            double d0 = 0.7;
            double d1 = 0.5;
            double d2 = 0.2;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < 10.0f) {
            ++this.spellTime;
            if (this.spellTime > 31 && this.func_110143_aJ() <= 10.0f) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 100));
                this.spellTime = 1;
            }
        }
        super.func_70636_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    private void setCharged(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_213716_dX() ? SoundEvents.field_219723_nb : SoundEvents.field_219708_mT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_219713_mY;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219709_mU;
    }

    protected SoundEvent func_213721_r(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.field_219724_nc : SoundEvents.field_219714_mZ;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_219724_nc;
    }

    static class FireballAttackGoal
    extends Goal {
        private final WizardEntity wizard;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public FireballAttackGoal(WizardEntity wizard) {
            this.wizard = wizard;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.wizard.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.wizard.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.wizard.setCharged(false);
            this.lastSeen = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingentity = this.wizard.func_70638_az();
            if (livingentity != null) {
                boolean flag = this.wizard.func_70635_at().func_75522_a((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.wizard.func_70068_e((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.wizard.func_70652_k((Entity)livingentity);
                    }
                    this.wizard.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.func_226277_ct_() - this.wizard.func_226277_ct_();
                    double d2 = livingentity.func_226283_e_(0.5) - this.wizard.func_226283_e_(0.5);
                    double d3 = livingentity.func_226281_cx_() - this.wizard.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            this.wizard.field_70170_p.func_217378_a((PlayerEntity)null, 1018, this.wizard.func_233580_cy_(), 0);
                            for (int i = 0; i < 1; ++i) {
                                SmallFireballEntity smallfireballentity = new SmallFireballEntity(this.wizard.field_70170_p, (LivingEntity)this.wizard, d1 + this.wizard.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.wizard.func_70681_au().nextGaussian() * (double)f);
                                smallfireballentity.func_70107_b(smallfireballentity.func_226277_ct_(), this.wizard.func_226283_e_(0.5) + 0.5, smallfireballentity.func_226281_cx_());
                                this.wizard.field_70170_p.func_217376_c((Entity)smallfireballentity);
                            }
                        }
                    }
                    this.wizard.func_70671_ap().func_75651_a((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.wizard.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                }
                this.wizard.setCharged(this.attackStep > 1);
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.wizard.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

