/*
 * Decompiled with CFR 0.152.
 */
package dev.driscollcreations.explorercraft.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class VanillaTweaksConfig {
    public static ForgeConfigSpec.BooleanValue swimmingHorse;
    public static ForgeConfigSpec.BooleanValue spawnSlimeChunkCaves;
    public static ForgeConfigSpec.BooleanValue spawnNoctilucas;
    public static ForgeConfigSpec.BooleanValue spawnForestedMountain;
    public static ForgeConfigSpec.IntValue forestedMountainRarity;
    public static ForgeConfigSpec.BooleanValue spawnMarbleInForestedMountains;
    public static ForgeConfigSpec.BooleanValue spawnMarbleInOverworld;
    public static ForgeConfigSpec.IntValue marbleVeinSizeInForestedMountains;
    public static ForgeConfigSpec.IntValue marbleChanceInForestedMountains;
    public static ForgeConfigSpec.IntValue marbleVeinSizeInOverworld;
    public static ForgeConfigSpec.IntValue marbleChanceInOverworld;
    public static ForgeConfigSpec.BooleanValue spawnTempleRuins;
    public static ForgeConfigSpec.BooleanValue spawnBasaltInOverworld;
    public static ForgeConfigSpec.IntValue basaltVeinSizeInOverworld;
    public static ForgeConfigSpec.IntValue basaltChanceInOverworld;
    public static ForgeConfigSpec.BooleanValue spawnRuby;
    public static ForgeConfigSpec.BooleanValue spawnAmethyst;

    public static void init(ForgeConfigSpec.Builder common, ForgeConfigSpec.Builder client) {
        common.push("Vanilla Tweaks");
        common.comment("Control how the vanilla tweaks to the game function");
        swimmingHorse = common.comment("Allow Horses to swim - (They wont buck you off if in deep water)").translation("explorercraft.config.swimmingHorse").define("swimmingHorse", true);
        spawnSlimeChunkCaves = common.comment("Spawn slimey caves in Overworld").translation("explorercraft.config.spawnSpawnChunkCaves").define("spawnSpawnChunkCaves", true);
        spawnNoctilucas = common.comment("Allow noctilucas to spawn naturally in the world").translation("explorercraft.config.spawnNoctilucas").define("spawnNoctilucas", true);
        spawnForestedMountain = common.comment("Spawn Forested Mountains in Overworld").translation("explorercraft.config.spawnForestedMountain").define("spawnForestedMountain", true);
        forestedMountainRarity = common.comment("Forested Mountain rarity - Higher equals more frequent").translation("explorercraft.config.forestedMountainRarity").defineInRange("forestedMountainRarity", 5, 0, 100);
        spawnMarbleInForestedMountains = common.comment("Spawn Marble in Forested Mountain (has a much higher ratio)").translation("explorercraft.config.spawnMarbleInForestedMountains").define("spawnMarbleInForestedMountains", true);
        spawnMarbleInOverworld = common.comment("Spawn Marble in Overworld").translation("explorercraft.config.spawnMarbleInOverworld").define("spawnMarbleInOverworld", true);
        marbleVeinSizeInForestedMountains = common.comment("Size of Marble vein in the Forested Mountain biome").translation("explorercraft.config.marbleVeinSizeInForestedMountains").defineInRange("marbleVeinSizeInForestedMountains", 64, 0, 64);
        marbleChanceInForestedMountains = common.comment("Chance of spawning Marble in the Forested Mountain biome").translation("explorercraft.config.marbleChanceInForestedMountains").defineInRange("marbleChanceInForestedMountains", 60, 0, 100);
        marbleVeinSizeInOverworld = common.comment("Size of Marble vein generated all over the Overworld").translation("explorercraft.config.marbleVeinSizeInOverworld").defineInRange("marbleVeinSizeInOverworld", 20, 0, 64);
        marbleChanceInOverworld = common.comment("Chance of spawning Marble in the Overworld").translation("explorercraft.config.marbleChanceInOverworld").defineInRange("marbleChanceInOverworld", 10, 0, 100);
        spawnTempleRuins = common.comment("Spawn Temple Ruins in the Forested Mountains").translation("explorercraft.config.spawnTempleRuins").define("spawnTempleRuins", true);
        spawnBasaltInOverworld = common.comment("Spawn Basalt in Overworld").translation("explorercraft.config.spawnBasaltInOverworld").define("spawnBasaltInOverworld", true);
        basaltVeinSizeInOverworld = common.comment("Size of Basalt vein generated all over the Overworld").translation("explorercraft.config.basaltVeinSizeInOverworld").defineInRange("basaltVeinSizeInOverworld", 33, 0, 64);
        basaltChanceInOverworld = common.comment("Chance of spawning Basalt in the Overworld").translation("explorercraft.config.basaltChanceInOverworld").defineInRange("basaltChanceInOverworld", 10, 0, 100);
        spawnRuby = common.comment("Spawn Ruby in the Forested Mountains").translation("explorercraft.config.spawnRuby").define("spawnRuby", true);
        spawnAmethyst = common.comment("Spawn Amethysdt in the Overworld").translation("explorercraft.config.spawnAmethyst").define("spawnAmethyst", true);
        common.pop();
    }
}

