/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.proxy;

import com.google.common.collect.ImmutableMap;
import com.zathrox.explorercraft.common.world.WorldGeneration;
import com.zathrox.explorercraft.core.Explorercraft;
import com.zathrox.explorercraft.core.config.Config;
import com.zathrox.explorercraft.core.data.ExplorercraftDataGenerator;
import com.zathrox.explorercraft.core.events.ExplorerPlayerEvents;
import com.zathrox.explorercraft.core.registry.ExplorerBannerPattern;
import com.zathrox.explorercraft.core.registry.ExplorerBiomes;
import com.zathrox.explorercraft.core.registry.ExplorerEnchantments;
import com.zathrox.explorercraft.core.registry.ExplorerEntities;
import com.zathrox.explorercraft.core.registry.ExplorerItems;
import com.zathrox.explorercraft.core.util.ExplorerTrades;
import com.zathrox.explorercraft.core.util.ExplorerVanillaCompat;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public class CommonProxy {
    private static final Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ITrade[]>> VANILLA_TRADES = new HashMap<VillagerProfession, Int2ObjectMap<VillagerTrades.ITrade[]>>();

    public CommonProxy() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.common_config);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::postInit);
        Config.loadConfig(Config.common_config, FMLPaths.CONFIGDIR.get().resolve("explorercraft-common.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)new ExplorercraftDataGenerator());
        ExplorerBannerPattern.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExplorerBiomes.BIOMES.register(modEventBus);
        ExplorerEnchantments.ENCHANTMENTS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new ExplorerPlayerEvents());
    }

    protected void preInit(FMLCommonSetupEvent event) {
        Explorercraft.LOGGER.debug("CommonProxy preInit method");
        WorldGeneration.setup();
        ExplorerVanillaCompat.setup();
        this.changeVanillaFields();
    }

    protected void init(InterModEnqueueEvent event) {
        Explorercraft.LOGGER.debug("CommonProxy init method");
    }

    protected void postInit(InterModProcessEvent event) {
        Explorercraft.LOGGER.debug("CommonProxy postInit method");
        ExplorerEntities.registerEntityWorldSpawns();
        ExplorerBiomes.registerBiomes();
        EnchantmentType.BOW.func_77557_a(ExplorerItems.JADE_BOW);
    }

    void changeVanillaFields() {
        this.addVillagerTrades(VillagerProfession.field_221156_f, ExplorerTrades.newTradeMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ExplorerTrades.EmeraldForItemsTrade((IItemProvider)ExplorerItems.LEEK, 22, 16, 2), new ExplorerTrades.EmeraldForItemsTrade((IItemProvider)ExplorerItems.RICE, 32, 16, 2)})));
        this.addVillagerTrades(VillagerProfession.field_221153_c, ExplorerTrades.newTradeMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)3, (Object)new VillagerTrades.ITrade[]{new ExplorerTrades.EmeraldForItemsTrade((IItemProvider)ExplorerItems.LAMB_SHANK, 7, 16, 20)})));
        this.addVillagerTrades(VillagerProfession.field_221155_e, ExplorerTrades.newTradeMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)3, (Object)new VillagerTrades.ITrade[]{new ExplorerTrades.ItemsForEmeraldsTrade(ExplorerItems.NOCTILUCA, 5, 1, 15)})));
        this.addVillagerTrades(VillagerProfession.field_221154_d, ExplorerTrades.newTradeMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)5, (Object)new VillagerTrades.ITrade[]{new ExplorerTrades.EmeraldForMapTrade(14, "explorercraft:Wizard_Tower", MapDecoration.Type.MANSION, 6, 10)})));
    }

    public void addVillagerTrades(VillagerProfession prof, Int2ObjectMap<VillagerTrades.ITrade[]> newTrades) {
        Int2ObjectMap<VillagerTrades.ITrade[]> profTrades = VANILLA_TRADES.getOrDefault(prof, (Int2ObjectMap<VillagerTrades.ITrade[]>)new Int2ObjectOpenHashMap());
        Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
        Int2ObjectMap<VillagerTrades.ITrade[]> newProfList = newTrades;
        for (int i = 1; i < 6; ++i) {
            mutableTrades.put(i, (Object)NonNullList.func_191196_a());
        }
        newProfList.int2ObjectEntrySet().forEach(arg_0 -> CommonProxy.lambda$addVillagerTrades$2((Int2ObjectMap)mutableTrades, arg_0));
        profTrades.int2ObjectEntrySet().forEach(arg_0 -> CommonProxy.lambda$addVillagerTrades$3((Int2ObjectMap)mutableTrades, arg_0));
        MinecraftForge.EVENT_BUS.post((Event)new VillagerTradesEvent((Int2ObjectMap)mutableTrades, prof));
        mutableTrades.int2ObjectEntrySet().forEach(e -> {
            VillagerTrades.ITrade[] cfr_ignored_0 = (VillagerTrades.ITrade[])newProfList.put(e.getIntKey(), (Object)((List)e.getValue()).toArray(new VillagerTrades.ITrade[0]));
        });
        VillagerTrades.field_221239_a.put(prof, newProfList);
    }

    private static /* synthetic */ void lambda$addVillagerTrades$3(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
        Arrays.stream((Object[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$addVillagerTrades$2(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
        Arrays.stream((Object[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$null$0(Int2ObjectMap copy, Int2ObjectMap.Entry ent) {
        VillagerTrades.ITrade[] cfr_ignored_0 = (VillagerTrades.ITrade[])copy.put(ent.getIntKey(), (Object)Arrays.copyOf((Object[])ent.getValue(), ((VillagerTrades.ITrade[])ent.getValue()).length));
    }

    static {
        VillagerTrades.field_221239_a.entrySet().forEach(e -> {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap();
            ((Int2ObjectMap)e.getValue()).int2ObjectEntrySet().forEach(arg_0 -> CommonProxy.lambda$null$0((Int2ObjectMap)copy, arg_0));
            VANILLA_TRADES.put((VillagerProfession)e.getKey(), (Int2ObjectMap<VillagerTrades.ITrade[]>)copy);
        });
    }
}

