/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class WizardTowerFeature
extends Feature<NoFeatureConfig> {
    public static final MinecraftServer worldServer = ServerLifecycleHooks.getCurrentServer();

    public WizardTowerFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    @Nullable
    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int width = 7;
        int depth = 8;
        int height = 20;
        TemplateManager templateManager = ((ServerWorld)worldIn.func_201672_e()).func_217485_w().func_186340_h();
        Template template = templateManager.func_200219_b(new ResourceLocation("explorercraft", "wizard_tower_v2"));
        if (template == null) {
            System.out.println("Could not find structure at " + new ResourceLocation("explorercraft", "structures/wizard_tower_v2"));
            return false;
        }
        BlockPos worldHeight = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos);
        if (worldHeight.func_177956_o() <= 100) {
            return false;
        }
        PlacementSettings placementSettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(null);
        Rotation rotation = Rotation.values()[rand.nextInt(Rotation.values().length)];
        if (rotation == Rotation.CLOCKWISE_90) {
            if (WizardTowerFeature.canSpawnClockwise90(worldIn, pos, width, depth = -depth, height)) {
                template.func_186260_a(worldIn, pos.func_177979_c(4), placementSettings.func_186220_a(rotation));
                System.out.println("WIZARD TOWER GENERATED CLOCKWISE_90 AT: " + pos);
            }
        } else if (rotation == Rotation.CLOCKWISE_180) {
            if (WizardTowerFeature.canSpawnClockwise180(worldIn, pos, width = -width, depth = -depth, height)) {
                template.func_186260_a(worldIn, pos.func_177979_c(4), placementSettings.func_186220_a(rotation));
                System.out.println("WIZARD TOWER GENERATED CLOCKWISE_180 AT: " + pos);
                return true;
            }
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            if (WizardTowerFeature.canSpawnClockwise270(worldIn, pos, width = -width, depth, height)) {
                template.func_186260_a(worldIn, pos.func_177979_c(4), placementSettings.func_186220_a(rotation));
                System.out.println("WIZARD TOWER GENERATED CLOCKWISE_270 AT: " + pos);
                return true;
            }
        } else if (rotation == Rotation.NONE && WizardTowerFeature.canSpawnHere(worldIn, pos, width, depth, height)) {
            template.func_186260_a(worldIn, pos.func_177979_c(4), placementSettings.func_186220_a(rotation));
            System.out.println("WIZARD TOWER GENERATED DEFAULT AT: " + pos);
            return true;
        }
        return false;
    }

    public static boolean canReplace(IWorld world, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_185904_a();
        return material.func_76220_a() || material == Material.field_151585_k || material == Material.field_151584_j || material == Material.field_151577_b || material != Material.field_151579_a;
    }

    public static boolean canSpawnHere(IWorld world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WizardTowerFeature.canReplace(world, posAboveGround);
        boolean corner2Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(width, 0, 0));
        boolean corner4Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(0, 0, depth));
        boolean corner3Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(width, 0, depth));
        return posAboveGround.func_177956_o() > height && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    private static boolean canSpawnClockwise90(IWorld world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WizardTowerFeature.canReplace(world, posAboveGround);
        boolean corner2Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(depth, 0, 0));
        boolean corner4Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(0, 0, width));
        boolean corner3Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(depth, 0, width));
        return posAboveGround.func_177956_o() > height && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    private static boolean canSpawnClockwise180(IWorld world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WizardTowerFeature.canReplace(world, posAboveGround);
        boolean corner2Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(width, 0, 0));
        boolean corner4Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(0, 0, depth));
        boolean corner3Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(width, 0, depth));
        return posAboveGround.func_177956_o() > height && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    private static boolean canSpawnClockwise270(IWorld world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WizardTowerFeature.canReplace(world, posAboveGround);
        boolean corner2Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(depth, 0, 0));
        boolean corner4Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(0, 0, width));
        boolean corner3Air = WizardTowerFeature.canReplace(world, posAboveGround.func_177982_a(depth, 0, width));
        return posAboveGround.func_177956_o() > height && corner1Air && corner2Air && corner3Air && corner4Air;
    }
}

