/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.zathrox.explorercraft.common.blocks.RiceBlock;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class RicePaddyFeature
extends Feature<NoFeatureConfig> {
    private final Block block = Blocks.field_150355_j;
    private static final Random randomAge = new Random();
    private static final BlockState water = Blocks.field_150355_j.func_176223_P();
    private static final BlockState base = ExplorerBlocks.RICE_BASE.func_176223_P();

    public RicePaddyFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> count) {
        super(count);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos position, NoFeatureConfig config) {
        position = position.func_177982_a(-8, 0, -8);
        while (position.func_177956_o() > 5 && world.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() <= 4) {
            return false;
        }
        position = position.func_177979_c(4);
        boolean[] aboolean = new boolean[2048];
        int i = rand.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = rand.nextDouble() * 6.0 + 3.0;
            double d1 = rand.nextDouble() * 4.0 + 2.0;
            double d2 = rand.nextDouble() * 6.0 + 3.0;
            double d3 = rand.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = rand.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && aboolean[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && aboolean[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && aboolean[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && aboolean[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && aboolean[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && aboolean[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = world.func_180495_p(position.func_177982_a(k1, k, l2)).func_185904_a();
                    if (k >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (k >= 4 || material.func_76220_a() || world.func_180495_p(position.func_177982_a(k1, k, l2)).func_177230_c() == this.block) continue;
                    return false;
                }
            }
        }
        ArrayList<BlockPos> possibles = new ArrayList<BlockPos>();
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 5; ++i4) {
                    BlockPos target;
                    if (!aboolean[(l1 * 16 + i3) * 8 + i4]) continue;
                    BlockPos down = target = position.func_177982_a(l1, i4, i3);
                    BlockState state = world.func_180495_p(down);
                    boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockReader)world, down, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t));
                    if (i4 >= 4) {
                        if (world.func_180495_p(target) == ExplorerBlocks.RICE_TOP.func_176223_P() || world.func_180495_p(target) == base || world.func_180495_p(target) == ExplorerBlocks.BAMBOO_LOG.func_176223_P() || world.func_180495_p(target.func_177984_a()).func_177230_c() == ExplorerBlocks.BAMBOO_LOG || isSoil) continue;
                        world.func_180501_a(target, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    if (world.func_180495_p(target.func_177984_a()).func_177230_c() == ExplorerBlocks.BAMBOO_LOG && isSoil) {
                        world.func_180501_a(target, Blocks.field_150346_d.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(target, Blocks.field_150355_j.func_176223_P(), 2);
                    Block below = world.func_180495_p(target.func_177977_b()).func_177230_c();
                    if (below != Blocks.field_150346_d && below != Blocks.field_150349_c && below != Blocks.field_150354_m) continue;
                    possibles.add(target);
                }
            }
        }
        int riceCount = 0;
        int riceMax = rand.nextInt(6) + 1;
        while (riceCount <= riceMax && possibles.size() > 0) {
            BlockPos rice = (BlockPos)possibles.remove(rand.nextInt(possibles.size()));
            if (!world.func_175710_j(rice.func_177984_a()) || !world.func_175623_d(rice.func_177984_a())) continue;
            BlockState top = (BlockState)ExplorerBlocks.RICE_TOP.func_176223_P().func_206870_a((IProperty)RiceBlock.field_176488_a, (Comparable)Integer.valueOf(0 + randomAge.nextInt(6)));
            world.func_180501_a(rice, base, 2);
            world.func_180501_a(rice.func_177984_a(), top, 3);
            ++riceCount;
        }
        if (this.block.func_176223_P().func_185904_a() == Material.field_151587_i) {
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k3 = 0; k3 < 16; ++k3) {
                    for (int k4 = 0; k4 < 8; ++k4) {
                        boolean flag1;
                        boolean bl = flag1 = !aboolean[(j2 * 16 + k3) * 8 + k4] && (j2 < 15 && aboolean[((j2 + 1) * 16 + k3) * 8 + k4] || j2 > 0 && aboolean[((j2 - 1) * 16 + k3) * 8 + k4] || k3 < 15 && aboolean[(j2 * 16 + k3 + 1) * 8 + k4] || k3 > 0 && aboolean[(j2 * 16 + (k3 - 1)) * 8 + k4] || k4 < 7 && aboolean[(j2 * 16 + k3) * 8 + k4 + 1] || k4 > 0 && aboolean[(j2 * 16 + k3) * 8 + (k4 - 1)]);
                        if (!flag1 || k4 >= 4 && rand.nextInt(2) == 0 || !world.func_180495_p(position.func_177982_a(j2, k4, k3)).func_185904_a().func_76220_a()) continue;
                        world.func_180501_a(position.func_177982_a(j2, k4, k3), Blocks.field_150348_b.func_176223_P(), 2);
                    }
                }
            }
        }
        return true;
    }
}

