/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.zathrox.explorercraft.common.world.feature.AbstractTreeFeature2;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class ECBirchTreeFeature
extends AbstractTreeFeature2<NoFeatureConfig> {
    private static final BlockState LOG = Blocks.field_196619_M.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196647_Y.func_176223_P();
    private final boolean useExtraRandomHeight;

    public ECBirchTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean extraRandomHeightIn) {
        super(configIn);
        this.useExtraRandomHeight = extraRandomHeightIn;
        this.setSapling((IPlantable)Blocks.field_196676_v);
    }

    @Override
    public boolean place(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundsIn) {
        int i = rand.nextInt(3) + 5;
        if (this.useExtraRandomHeight) {
            i += rand.nextInt(7);
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (ECBirchTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (ECBirchTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (int l1 = position.func_177956_o() - 3 + i; l1 <= position.func_177956_o() + i; ++l1) {
                    int j2 = l1 - (position.func_177956_o() + i);
                    int k2 = 1 - j2 / 2;
                    for (int l2 = position.func_177958_n() - k2; l2 <= position.func_177958_n() + k2; ++l2) {
                        int i3 = l2 - position.func_177958_n();
                        for (int j1 = position.func_177952_p() - k2; j1 <= position.func_177952_p() + k2; ++j1) {
                            BlockPos blockpos;
                            int k1 = j1 - position.func_177952_p();
                            if (Math.abs(i3) == k2 && Math.abs(k1) == k2 && (rand.nextInt(2) == 0 || j2 == 0) || !ECBirchTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos = new BlockPos(l2, l1, j1))) continue;
                            this.setLogState(changedBlocks, (IWorldWriter)worldIn, blockpos, LEAF, boundsIn);
                        }
                    }
                }
                for (int i2 = 0; i2 < i; ++i2) {
                    if (!ECBirchTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, position.func_177981_b(i2))) continue;
                    this.setLogState(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(i2), LOG, boundsIn);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

