/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.world;

import com.mojang.datafixers.Dynamic;
import com.zathrox.explorercraft.common.world.blockstateProvider.SnowdoniaFlowerBlockStateProvider;
import com.zathrox.explorercraft.common.world.feature.AshTreeFeature;
import com.zathrox.explorercraft.common.world.feature.BambooTreeFeature;
import com.zathrox.explorercraft.common.world.feature.ECBigTreeFeature;
import com.zathrox.explorercraft.common.world.feature.ECBirchTreeFeature;
import com.zathrox.explorercraft.common.world.feature.ECTreeFeature;
import com.zathrox.explorercraft.common.world.feature.JapaneseMapleTreeFeature;
import com.zathrox.explorercraft.common.world.feature.KwanzanCherryTreeFeature;
import com.zathrox.explorercraft.common.world.feature.LotusFlowerFeature;
import com.zathrox.explorercraft.common.world.feature.MudSurfaceBuilder;
import com.zathrox.explorercraft.common.world.feature.NoctilucaFeature;
import com.zathrox.explorercraft.common.world.feature.RicePaddyFeature;
import com.zathrox.explorercraft.common.world.feature.SlimeBlockFeature;
import com.zathrox.explorercraft.common.world.feature.TallDarkOakTreeFeature;
import com.zathrox.explorercraft.common.world.feature.WildLeekFeature;
import com.zathrox.explorercraft.common.world.feature.WillowTreeFeature;
import com.zathrox.explorercraft.common.world.feature.structure.SlateDungeonFeature;
import com.zathrox.explorercraft.common.world.feature.structure.WizardTowerFeature;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExplorerFeature {
    public static final SurfaceBuilder<SurfaceBuilderConfig> MUD_SURFACE_BUILDER = new MudSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
    public static final SurfaceBuilderConfig MUD_SURFACE = new SurfaceBuilderConfig(ExplorerBlocks.MUD.func_176223_P(), ExplorerBlocks.MUD.func_176223_P(), ExplorerBlocks.MUD.func_176223_P());
    public static final BlockClusterFeatureConfig SNOWDONIA_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SnowdoniaFlowerBlockStateProvider(), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig GREEN_GLOWSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ExplorerBlocks.GREEN_MUSHROOM.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig PINK_GLOWSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ExplorerBlocks.PINK_MUSHROOM.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig LUPINE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(ExplorerBlocks.LUPINE.func_176223_P(), 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig CATTAIL_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ExplorerBlocks.CATTAIL.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig TALL_CATTAIL_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ExplorerBlocks.TALL_CATTAIL.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final DeferredRegister<Feature<?>> FEATURES = new DeferredRegister(ForgeRegistries.FEATURES, "explorercraft");
    public static final Feature<NoFeatureConfig> FANCY_TREE = new ECBigTreeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> BIRCH_TREE = new ECBirchTreeFeature(NoFeatureConfig::func_214639_a, false);
    public static final Feature<NoFeatureConfig> NORMAL_TREE = new ECTreeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> WILD_LEEK = new WildLeekFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> RICE_PADDY = new RicePaddyFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> LOTUS_FLOWERS = new LotusFlowerFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<CountConfig> NOCTILUCA = new NoctilucaFeature(CountConfig::func_214687_a);
    public static final Feature<NoFeatureConfig> ASH_TREE = new AshTreeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> BAMBOO_TREE = new BambooTreeFeature(NoFeatureConfig::func_214639_a, true);
    public static final Feature<NoFeatureConfig> CHERRY_TREE = new KwanzanCherryTreeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> MAPLE_TREE = new JapaneseMapleTreeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> TALL_DARK_OAK_TREE = new TallDarkOakTreeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> WILLOW_TREE = new WillowTreeFeature((Function<Dynamic<?>, ? extends NoFeatureConfig>)((Function<Dynamic<?>, NoFeatureConfig>)NoFeatureConfig::func_214639_a));
    public static final Feature<NoFeatureConfig> SLIME_BLOCK = new SlimeBlockFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> WIZARD_TOWER = new WizardTowerFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> SLATE_DUNGEON = new SlateDungeonFeature(NoFeatureConfig::func_214639_a);

    public static void surfacebuilderRegistering(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ExplorerFeature.register(registry, MUD_SURFACE_BUILDER, "mud_surface_builder");
    }

    private static <T extends IPlacementConfig, G extends Placement<T>> G register(String key, G p_214999_1_) {
        return (G)((Placement)Registry.func_218325_a((Registry)Registry.field_218380_r, (String)key, p_214999_1_));
    }

    public static void featureRegistering(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ExplorerFeature.register(registry, FANCY_TREE, "fancy_tree");
        ExplorerFeature.register(registry, BIRCH_TREE, "birch_tree");
        ExplorerFeature.register(registry, NORMAL_TREE, "normal_tree");
        ExplorerFeature.register(registry, WILD_LEEK, "wild_leek");
        ExplorerFeature.register(registry, RICE_PADDY, "rice_paddy");
        ExplorerFeature.register(registry, LOTUS_FLOWERS, "lotus_flowers");
        ExplorerFeature.register(registry, NOCTILUCA, "noctiluca");
        ExplorerFeature.register(registry, ASH_TREE, "ash_tree");
        ExplorerFeature.register(registry, BAMBOO_TREE, "bamboo_tree");
        ExplorerFeature.register(registry, CHERRY_TREE, "cherry_tree");
        ExplorerFeature.register(registry, MAPLE_TREE, "maple_tree");
        ExplorerFeature.register(registry, TALL_DARK_OAK_TREE, "tall_dark_oak_tree");
        ExplorerFeature.register(registry, WILLOW_TREE, "willow_tree");
        ExplorerFeature.register(registry, SLIME_BLOCK, "slime_block");
        ExplorerFeature.register(registry, WIZARD_TOWER, "wizard_tower_feature");
        ExplorerFeature.register(registry, SLATE_DUNGEON, "slate_dungeon");
    }

    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T entry, String registryKey) {
        entry.setRegistryName(new ResourceLocation("explorercraft", registryKey.toLowerCase().replace(' ', '_')));
        registry.register(entry);
        return entry;
    }
}

