/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.entity;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkeletaurEntity
extends MonsterEntity {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(SkeletaurEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public SkeletaurEntity(EntityType<? extends SkeletaurEntity> p_i50194_1_, World p_i50194_2_) {
        super(p_i50194_1_, p_i50194_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal(this, 1.2, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 2.3f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190036_ha;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187860_ff;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        super.func_184601_bQ(p_184601_1_);
        return SoundEvents.field_187862_fg;
    }

    protected boolean shouldBurnInDay() {
        return true;
    }

    public void func_70636_d() {
        if (this.func_70089_S()) {
            boolean flag;
            boolean bl = flag = this.shouldBurnInDay() && this.func_204609_dp();
            if (flag) {
                ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_213361_c(EquipmentSlotType.HEAD);
                            this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isAttacking()) {
            double d0 = 0.7;
            double d1 = 0.5;
            double d2 = 0.2;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    static class MeleeAttackGoal
    extends Goal {
        protected final SkeletaurEntity attacker;
        protected int attackTick;
        private final double speedTowardsTarget;
        private final boolean longMemory;
        private Path path;
        private int delayCounter;
        private double targetX;
        private double targetY;
        private double targetZ;
        protected final int attackInterval = 20;
        private long field_220720_k;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        Random random = new Random();

        public MeleeAttackGoal(SkeletaurEntity creature, double speedIn, boolean useLongMemory) {
            this.attacker = creature;
            this.speedTowardsTarget = speedIn;
            this.longMemory = useLongMemory;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            long i = this.attacker.field_70170_p.func_82737_E();
            if (i - this.field_220720_k < 20L) {
                return false;
            }
            this.field_220720_k = i;
            LivingEntity livingentity = this.attacker.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.delayCounter <= 0) {
                    this.path = this.attacker.func_70661_as().func_75494_a((Entity)livingentity, 0);
                    this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.attacker.func_70661_as().func_75494_a((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.attacker.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.attacker.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (!this.longMemory) {
                return !this.attacker.func_70661_as().func_75500_f();
            }
            if (!this.attacker.func_213389_a(new BlockPos((Entity)livingentity))) {
                return false;
            }
            return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
        }

        public void func_75249_e() {
            this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
            this.attacker.func_213395_q(true);
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            LivingEntity livingentity = this.attacker.func_70638_az();
            if (!EntityPredicates.field_188444_d.test(livingentity)) {
                this.attacker.func_70624_b(null);
            }
            this.attacker.setAttacking(false);
            this.attacker.func_213395_q(false);
            this.attacker.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.attacker.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
            --this.delayCounter;
            if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = livingentity.func_226277_ct_();
                this.targetY = livingentity.func_226278_cu_();
                this.targetZ = livingentity.func_226281_cx_();
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.func_70661_as().func_75497_a((Entity)livingentity, this.speedTowardsTarget)) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d0 && this.attackTick <= 0) {
                this.attackTick = 20;
                if (this.random.nextInt(15) == 0) {
                    this.attacker.func_184609_a(Hand.MAIN_HAND);
                } else {
                    this.attacker.setAttacking(true);
                }
                this.attacker.func_70652_k((Entity)enemy);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return this.attacker.func_213311_cf() * 2.0f * this.attacker.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
        }
    }
}

