/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class ExplorerVillagerUtil {
    public static Int2ObjectMap<VillagerTrades.ITrade[]> newTradeMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    @Deprecated
    public static Int2ObjectMap<VillagerTrades.ITrade[]> combineTradeMap(Int2ObjectMap<VillagerTrades.ITrade[]> originalMap, ImmutableMap<Integer, VillagerTrades.ITrade[]> newMap) {
        Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)originalMap;
        map.putAll(newMap);
        return map;
    }

    public static class ItemsForEmeraldsAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack field_221200_a;
        private final int field_221201_b;
        private final int field_221202_c;
        private final ItemStack field_221203_d;
        private final int field_221204_e;
        private final int field_221205_f;
        private final int field_221206_g;
        private final float field_221207_h;

        public ItemsForEmeraldsAndItemsTrade(IItemProvider p_i50533_1_, int p_i50533_2_, Item p_i50533_3_, int p_i50533_4_, int p_i50533_5_, int p_i50533_6_) {
            this(p_i50533_1_, p_i50533_2_, 1, p_i50533_3_, p_i50533_4_, p_i50533_5_, p_i50533_6_);
        }

        public ItemsForEmeraldsAndItemsTrade(IItemProvider p_i50534_1_, int p_i50534_2_, int p_i50534_3_, Item p_i50534_4_, int p_i50534_5_, int p_i50534_6_, int p_i50534_7_) {
            this.field_221200_a = new ItemStack(p_i50534_1_);
            this.field_221201_b = p_i50534_2_;
            this.field_221202_c = p_i50534_3_;
            this.field_221203_d = new ItemStack((IItemProvider)p_i50534_4_);
            this.field_221204_e = p_i50534_5_;
            this.field_221205_f = p_i50534_6_;
            this.field_221206_g = p_i50534_7_;
            this.field_221207_h = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.field_221202_c), new ItemStack((IItemProvider)this.field_221200_a.func_77973_b(), this.field_221201_b), new ItemStack((IItemProvider)this.field_221203_d.func_77973_b(), this.field_221204_e), this.field_221205_f, this.field_221206_g, this.field_221207_h);
        }
    }

    public static class ItemWithPotionForEmeraldsAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack field_221219_a;
        private final int field_221220_b;
        private final int field_221221_c;
        private final int field_221222_d;
        private final int field_221223_e;
        private final Item field_221224_f;
        private final int field_221225_g;
        private final float field_221226_h;

        public ItemWithPotionForEmeraldsAndItemsTrade(Item p_i50526_1_, int p_i50526_2_, Item p_i50526_3_, int p_i50526_4_, int p_i50526_5_, int p_i50526_6_, int p_i50526_7_) {
            this.field_221219_a = new ItemStack((IItemProvider)p_i50526_3_);
            this.field_221221_c = p_i50526_5_;
            this.field_221222_d = p_i50526_6_;
            this.field_221223_e = p_i50526_7_;
            this.field_221224_f = p_i50526_1_;
            this.field_221225_g = p_i50526_2_;
            this.field_221220_b = p_i50526_4_;
            this.field_221226_h = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151166_bC, this.field_221221_c);
            List list = Registry.field_212621_j.func_201756_e().filter(p_221218_0_ -> !p_221218_0_.func_185170_a().isEmpty() && PotionBrewing.func_222124_a((Potion)p_221218_0_)).collect(Collectors.toList());
            Potion potion = (Potion)list.get(p_221182_2_.nextInt(list.size()));
            ItemStack itemstack1 = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)this.field_221219_a.func_77973_b(), this.field_221220_b), (Potion)potion);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)this.field_221224_f, this.field_221225_g), itemstack1, this.field_221222_d, this.field_221223_e, this.field_221226_h);
        }
    }

    public static class EnchantedItemForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack field_221195_a;
        private final int field_221196_b;
        private final int field_221197_c;
        private final int field_221198_d;
        private final float field_221199_e;

        public EnchantedItemForEmeraldsTrade(Item p_i50535_1_, int p_i50535_2_, int p_i50535_3_, int p_i50535_4_) {
            this(p_i50535_1_, p_i50535_2_, p_i50535_3_, p_i50535_4_, 0.05f);
        }

        public EnchantedItemForEmeraldsTrade(Item p_i50536_1_, int p_i50536_2_, int p_i50536_3_, int p_i50536_4_, float p_i50536_5_) {
            this.field_221195_a = new ItemStack((IItemProvider)p_i50536_1_);
            this.field_221196_b = p_i50536_2_;
            this.field_221197_c = p_i50536_3_;
            this.field_221198_d = p_i50536_4_;
            this.field_221199_e = p_i50536_5_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            int i = 5 + p_221182_2_.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.func_77504_a((Random)p_221182_2_, (ItemStack)new ItemStack((IItemProvider)this.field_221195_a.func_77973_b()), (int)i, (boolean)false);
            int j = Math.min(this.field_221196_b + i, 64);
            ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_151166_bC, j);
            return new MerchantOffer(itemstack1, itemstack, this.field_221197_c, this.field_221198_d, this.field_221199_e);
        }
    }

    public static class EnchantedBookForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final int field_221194_a;

        public EnchantedBookForEmeraldsTrade(int p_i50537_1_) {
            this.field_221194_a = p_i50537_1_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            Enchantment enchantment = (Enchantment)Registry.field_212628_q.func_186801_a(p_221182_2_);
            int i = MathHelper.func_76136_a((Random)p_221182_2_, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            ItemStack itemstack = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i));
            int j = 2 + p_221182_2_.nextInt(5 + i * 10) + 3 * i;
            if (enchantment.func_185261_e()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, j), new ItemStack((IItemProvider)Items.field_151122_aG), itemstack, 12, this.field_221194_a, 0.2f);
        }
    }

    public static class EmeraldForVillageTypeItemTrade
    implements VillagerTrades.ITrade {
        private final Map<IVillagerType, Item> field_221190_a;
        private final int field_221191_b;
        private final int field_221192_c;
        private final int field_221193_d;

        public EmeraldForVillageTypeItemTrade(int p_i50538_1_, int p_i50538_2_, int p_i50538_3_, Map<IVillagerType, Item> p_i50538_4_) {
            Registry.field_218369_K.func_201756_e().filter(p_221188_1_ -> !p_i50538_4_.containsKey(p_221188_1_)).findAny().ifPresent(p_221189_0_ -> {
                throw new IllegalStateException("Missing trade for villager type: " + Registry.field_218369_K.func_177774_c(p_221189_0_));
            });
            this.field_221190_a = p_i50538_4_;
            this.field_221191_b = p_i50538_1_;
            this.field_221192_c = p_i50538_2_;
            this.field_221193_d = p_i50538_3_;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            if (p_221182_1_ instanceof IVillagerDataHolder) {
                ItemStack itemstack = new ItemStack((IItemProvider)this.field_221190_a.get(((IVillagerDataHolder)p_221182_1_).func_213700_eh().func_221129_a()), this.field_221191_b);
                return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.field_221192_c, this.field_221193_d, 0.05f);
            }
            return null;
        }
    }

    public static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final int field_221227_a;
        private final String field_221228_b;
        private final MapDecoration.Type field_221229_c;
        private final int field_221230_d;
        private final int field_221231_e;

        public EmeraldForMapTrade(int p_i50525_1_, String p_i50525_2_, MapDecoration.Type p_i50525_3_, int p_i50525_4_, int p_i50525_5_) {
            this.field_221227_a = p_i50525_1_;
            this.field_221228_b = p_i50525_2_;
            this.field_221229_c = p_i50525_3_;
            this.field_221230_d = p_i50525_4_;
            this.field_221231_e = p_i50525_5_;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            World world = p_221182_1_.field_70170_p;
            BlockPos blockpos = world.func_211157_a(this.field_221228_b, new BlockPos(p_221182_1_), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)world, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_190905_a((World)world, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.field_221229_c);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.field_221228_b.toLowerCase(Locale.ROOT), new Object[0]));
                return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.field_221227_a), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.field_221230_d, this.field_221231_e, 0.2f);
            }
            return null;
        }
    }

    public static class DyedArmorForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final Item field_221233_a;
        private final int field_221234_b;
        private final int field_221235_c;
        private final int field_221236_d;

        public DyedArmorForEmeraldsTrade(Item p_i50540_1_, int p_i50540_2_) {
            this(p_i50540_1_, p_i50540_2_, 12, 1);
        }

        public DyedArmorForEmeraldsTrade(Item p_i50541_1_, int p_i50541_2_, int p_i50541_3_, int p_i50541_4_) {
            this.field_221233_a = p_i50541_1_;
            this.field_221234_b = p_i50541_2_;
            this.field_221235_c = p_i50541_3_;
            this.field_221236_d = p_i50541_4_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151166_bC, this.field_221234_b);
            ItemStack itemstack1 = new ItemStack((IItemProvider)this.field_221233_a);
            if (this.field_221233_a instanceof DyeableArmorItem) {
                ArrayList list = Lists.newArrayList();
                list.add(DyedArmorForEmeraldsTrade.func_221232_a(p_221182_2_));
                if (p_221182_2_.nextFloat() > 0.7f) {
                    list.add(DyedArmorForEmeraldsTrade.func_221232_a(p_221182_2_));
                }
                if (p_221182_2_.nextFloat() > 0.8f) {
                    list.add(DyedArmorForEmeraldsTrade.func_221232_a(p_221182_2_));
                }
                itemstack1 = IDyeableArmorItem.func_219975_a((ItemStack)itemstack1, (List)list);
            }
            return new MerchantOffer(itemstack, itemstack1, this.field_221235_c, this.field_221236_d, 0.2f);
        }

        private static DyeItem func_221232_a(Random p_221232_0_) {
            return DyeItem.func_195961_a((DyeColor)DyeColor.func_196056_a((int)p_221232_0_.nextInt(16)));
        }
    }

    public static class SuspiciousStewForEmeraldTrade
    implements VillagerTrades.ITrade {
        final Effect field_221214_a;
        final int field_221215_b;
        final int field_221216_c;
        private final float field_221217_d;

        public SuspiciousStewForEmeraldTrade(Effect p_i50527_1_, int p_i50527_2_, int p_i50527_3_) {
            this.field_221214_a = p_i50527_1_;
            this.field_221215_b = p_i50527_2_;
            this.field_221216_c = p_i50527_3_;
            this.field_221217_d = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_222115_pz, 1);
            SuspiciousStewItem.func_220037_a((ItemStack)itemstack, (Effect)this.field_221214_a, (int)this.field_221215_b);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 1), itemstack, 12, this.field_221216_c, this.field_221217_d);
        }
    }

    public static class EmeraldForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item itemstack;
        private final int stackSize;
        private final int recievedSize;
        private final int maxUses;
        private final float givenExp;

        public EmeraldForItemsTrade(IItemProvider item, int amount, int maxUses, int p_i50539_4_) {
            this.itemstack = item.func_199767_j();
            this.stackSize = amount;
            this.recievedSize = maxUses;
            this.maxUses = p_i50539_4_;
            this.givenExp = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity player, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.itemstack, this.stackSize);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.recievedSize, this.maxUses, this.givenExp);
        }
    }

    public static class ItemsForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack itemstack;
        private final int stackSize;
        private final int recievedSize;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block block, int stackSize, int recievedSize, int maxUses, int givenExp) {
            this(new ItemStack((IItemProvider)block), stackSize, recievedSize, maxUses, givenExp);
        }

        public ItemsForEmeraldsTrade(Item item, int stackSize, int recievedSize, int givenExp) {
            this(new ItemStack((IItemProvider)item), stackSize, recievedSize, 12, givenExp);
        }

        public ItemsForEmeraldsTrade(Item item, int stackSize, int recievedSize, int maxUses, int givenExp) {
            this(new ItemStack((IItemProvider)item), stackSize, recievedSize, maxUses, givenExp);
        }

        public ItemsForEmeraldsTrade(ItemStack stack, int stackSize, int recievedSize, int maxUses, int givenExp) {
            this(stack, stackSize, recievedSize, maxUses, givenExp, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack stack, int stackSize, int recievedSize, int maxUses, int givenExp, float priceMultiplier) {
            this.itemstack = stack;
            this.stackSize = stackSize;
            this.recievedSize = recievedSize;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.stackSize), new ItemStack((IItemProvider)this.itemstack.func_77973_b(), this.recievedSize), this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }
}

