/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.registry;

import com.zathrox.explorercraft.common.world.biome.BiomeBambooForest;
import com.zathrox.explorercraft.common.world.biome.BiomeForestedMountains;
import com.zathrox.explorercraft.common.world.biome.BiomeFungalForest;
import com.zathrox.explorercraft.common.world.biome.BiomeSnowdonia;
import com.zathrox.explorercraft.core.config.BiomeConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="explorercraft")
public class ExplorerBiomes {
    @ObjectHolder(value="bamboo_forest")
    public static final Biome BAMBOO_FOREST = null;
    @ObjectHolder(value="forested_mountain")
    public static final Biome FORESTED_MOUNTAIN = null;
    @ObjectHolder(value="snowdonia")
    public static final Biome SNOWDONIA = null;
    @ObjectHolder(value="fungal_forest")
    public static final Biome FUNGAL_FOREST = null;

    public static void registerBiomes() {
        ExplorerBiomes.addBiomesToManager(BAMBOO_FOREST, (Integer)BiomeConfig.bambooForestWeight.get(), false, (Boolean)BiomeConfig.spawnBambooForest.get(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET);
        ExplorerBiomes.addBiomesToManager(FORESTED_MOUNTAIN, (Integer)BiomeConfig.forestedMountainWeight.get(), false, (Boolean)BiomeConfig.spawnForestedMountain.get(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST);
        ExplorerBiomes.addBiomesToManager(SNOWDONIA, (Integer)BiomeConfig.snowdoniaWeight.get(), false, (Boolean)BiomeConfig.spawnSnowdonia.get(), BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WET);
        ExplorerBiomes.addBiomesToManager(FUNGAL_FOREST, (Integer)BiomeConfig.fungalForestWeight.get(), false, (Boolean)BiomeConfig.spawnFungalForest.get(), BiomeManager.BiomeType.WARM, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST);
    }

    public static void addBiomesToManager(Biome biome, int weight, Boolean village, Boolean allowed, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        if (allowed.booleanValue()) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
            BiomeManager.addSpawnBiome((Biome)biome);
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        }
    }

    @Mod.EventBusSubscriber(modid="explorercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static abstract class Registration {
        @SubscribeEvent
        public static void onRegister(RegistryEvent.Register<Biome> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(new BiomeBambooForest().setRegistryName(new ResourceLocation("explorercraft", "bamboo_forest")));
            registry.register(new BiomeForestedMountains().setRegistryName(new ResourceLocation("explorercraft", "forested_mountain")));
            registry.register(new BiomeSnowdonia().setRegistryName(new ResourceLocation("explorercraft", "snowdonia")));
            registry.register(new BiomeFungalForest().setRegistryName(new ResourceLocation("explorercraft", "fungal_forest")));
        }
    }
}

