/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.core.proxy;

import com.zathrox.explorercraft.client.ClientForgeEventSubscriber;
import com.zathrox.explorercraft.client.render.BrushStoogeRenderer;
import com.zathrox.explorercraft.client.render.EnderGhastRenderer;
import com.zathrox.explorercraft.client.render.EnderreeperRenderer;
import com.zathrox.explorercraft.client.render.InfectedCreeperRenderer;
import com.zathrox.explorercraft.client.render.InfectedSkeletonRenderer;
import com.zathrox.explorercraft.client.render.InfectedZombieRenderer;
import com.zathrox.explorercraft.client.render.WizardRenderer;
import com.zathrox.explorercraft.common.entity.BrushStoogeEntity;
import com.zathrox.explorercraft.common.entity.EnderGhastEntity;
import com.zathrox.explorercraft.common.entity.EnderreeperEntity;
import com.zathrox.explorercraft.common.entity.InfectedCreeperEntity;
import com.zathrox.explorercraft.common.entity.InfectedSkeletonEntity;
import com.zathrox.explorercraft.common.entity.InfectedZombieEntity;
import com.zathrox.explorercraft.common.entity.WizardEntity;
import com.zathrox.explorercraft.core.Explorercraft;
import com.zathrox.explorercraft.core.config.Config;
import com.zathrox.explorercraft.core.proxy.CommonProxy;
import com.zathrox.explorercraft.core.registry.ExplorerBiomes;
import com.zathrox.explorercraft.core.registry.ExplorerBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public ClientProxy() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.client_config);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        Config.loadConfig(Config.client_config, FMLPaths.CONFIGDIR.get().resolve("explorercraft-client.toml").toString());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Explorercraft.LOGGER.debug("ClientProxy clientSetup method");
        RenderingRegistry.registerEntityRenderingHandler(BrushStoogeEntity.class, manager -> new BrushStoogeRenderer(manager));
        RenderingRegistry.registerEntityRenderingHandler(EnderreeperEntity.class, manager -> new EnderreeperRenderer(manager));
        RenderingRegistry.registerEntityRenderingHandler(EnderGhastEntity.class, manager -> new EnderGhastRenderer(manager));
        RenderingRegistry.registerEntityRenderingHandler(InfectedSkeletonEntity.class, manager -> new InfectedSkeletonRenderer(manager));
        RenderingRegistry.registerEntityRenderingHandler(InfectedZombieEntity.class, manager -> new InfectedZombieRenderer(manager));
        RenderingRegistry.registerEntityRenderingHandler(InfectedCreeperEntity.class, manager -> new InfectedCreeperRenderer(manager));
        RenderingRegistry.registerEntityRenderingHandler(WizardEntity.class, manager -> new WizardRenderer(manager));
        MinecraftForge.EVENT_BUS.register((Object)new ClientForgeEventSubscriber());
    }

    private void registerBlockColours(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, world, pos, tint_index) -> world != null && pos != null ? BiomeColors.func_217613_a((IEnviromentBlockReader)world, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{ExplorerBlocks.LOTUS_FLOWER, ExplorerBlocks.SHORT_GRASS, ExplorerBlocks.WILLOW_LEAVES, ExplorerBlocks.WILLOW});
    }

    private void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, tintIndex) -> ExplorerBiomes.FUNGAL_FOREST.func_180627_b((BlockPos)null), new IItemProvider[]{ExplorerBlocks.LOTUS_FLOWER});
        itemColors.func_199877_a((stack, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{ExplorerBlocks.WILLOW_LEAVES, ExplorerBlocks.WILLOW});
        itemColors.func_199877_a((stack, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{ExplorerBlocks.SHORT_GRASS});
        itemColors.func_199877_a((stack, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{ExplorerBlocks.SHORT_GRASS});
    }

    @Override
    protected void postInit(InterModProcessEvent event) {
        super.postInit(event);
        this.registerBlockColours(new ColorHandlerEvent.Block(Minecraft.func_71410_x().func_184125_al()));
        this.registerItemColors(new ColorHandlerEvent.Item(Minecraft.func_71410_x().getItemColors(), Minecraft.func_71410_x().func_184125_al()));
    }
}

