/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.common.entity;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EnderGhastEntity
extends GhastEntity {
    public EnderGhastEntity(EntityType<? extends GhastEntity> p_i50206_1_, World worldIn) {
        super(p_i50206_1_, worldIn);
        this.field_70728_aV = 5;
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new FireballAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p_213812_1_ -> Math.abs(p_213812_1_.field_70163_u - this.field_70163_u) <= 4.0));
    }

    public int func_70641_bl() {
        return 1;
    }

    public static boolean spawnConditions(EntityType<EnderGhastEntity> entityType, IWorld world, SpawnReason reason, BlockPos blockPos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && random.nextInt(20) == 0 && EnderGhastEntity.func_223315_a(entityType, (IWorld)world, (SpawnReason)reason, (BlockPos)blockPos, (Random)random);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 3.1f;
    }

    static class RandomFlyGoal
    extends Goal {
        private final GhastEntity parentEntity;

        public RandomFlyGoal(GhastEntity ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.5);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final GhastEntity parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(GhastEntity ghast) {
            super((MobEntity)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                Vec3d vec3d = new Vec3d(this.field_75646_b - this.parentEntity.field_70165_t, this.field_75647_c - this.parentEntity.field_70163_u, this.field_75644_d - this.parentEntity.field_70161_v);
                double d0 = vec3d.func_72433_c();
                if (this.func_220673_a(vec3d = vec3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vec3d.func_186678_a(0.2)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean func_220673_a(Vec3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_195586_b((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final GhastEntity parentEntity;

        public LookAroundGoal(GhastEntity ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vec3d vec3d = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = livingentity.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class FireballAttackGoal
    extends Goal {
        private final GhastEntity parentEntity;
        public int attackTimer;

        public FireballAttackGoal(GhastEntity ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.func_175454_a(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)livingentity)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 10) {
                    world.func_217378_a((PlayerEntity)null, 1015, new BlockPos((Entity)this.parentEntity), 0);
                }
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    Vec3d vec3d = this.parentEntity.func_70676_i(1.0f);
                    double d2 = livingentity.field_70165_t - (this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0);
                    double d3 = livingentity.func_174813_aQ().field_72338_b + (double)(livingentity.func_213302_cg() / 2.0f) - (0.5 + this.parentEntity.field_70163_u + (double)(this.parentEntity.func_213302_cg() / 2.0f));
                    double d4 = livingentity.field_70161_v - (this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0);
                    world.func_217378_a((PlayerEntity)null, 1016, new BlockPos((Entity)this.parentEntity), 0);
                    DragonFireballEntity fireballentity = new DragonFireballEntity(world, (LivingEntity)this.parentEntity, d2, d3, d4);
                    fireballentity.field_70165_t = this.parentEntity.field_70165_t + vec3d.field_72450_a * 4.0;
                    fireballentity.field_70163_u = this.parentEntity.field_70163_u + (double)(this.parentEntity.func_213302_cg() / 2.0f) + 0.5;
                    fireballentity.field_70161_v = this.parentEntity.field_70161_v + vec3d.field_72449_c * 4.0;
                    world.func_217376_c((Entity)fireballentity);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.func_175454_a(this.attackTimer > 10);
        }
    }
}

