/*
 * Decompiled with CFR 0.152.
 */
package com.zathrox.explorercraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.zathrox.explorercraft.client.model.EnderreeperModel;
import com.zathrox.explorercraft.client.render.layer.EnderreeperChargeLayer;
import com.zathrox.explorercraft.common.entity.EnderreeperEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderreeperRenderer
extends MobRenderer<EnderreeperEntity, EnderreeperModel<EnderreeperEntity>> {
    private static final ResourceLocation ENDERREEPER_TEXTURES = new ResourceLocation("explorercraft:textures/entities/enderreeper.png");

    public EnderreeperRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new EnderreeperModel(), 0.5f);
        this.func_177094_a(new EnderreeperChargeLayer((IEntityRenderer<EnderreeperEntity, EnderreeperModel<EnderreeperEntity>>)this));
    }

    protected void preRenderCallback(EnderreeperEntity entitylivingbaseIn, float partialTickTime) {
        float f = entitylivingbaseIn.getEnderreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        GlStateManager.scalef((float)f2, (float)f3, (float)f2);
    }

    protected int getColorMultiplier(EnderreeperEntity entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.getEnderreeperFlashIntensity(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }

    protected ResourceLocation getEntityTexture(EnderreeperEntity entity) {
        return ENDERREEPER_TEXTURES;
    }
}

