/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world.test;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import zathrox.explorercraft.world.test.WorldGenStructureBase;

public class WorldGenLargeDungeon
extends WorldGenStructureBase {
    private int firstFloorWidth;
    private int firstFloorLength;

    public WorldGenLargeDungeon(World w, Random r) {
        super(w, r);
    }

    @Override
    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        this.firstFloorWidth = (random.nextInt(5) + 5) * 3;
        this.firstFloorLength = (random.nextInt(5) + 5) * 2;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.genStructureSpace(x, y, z, this.firstFloorWidth, this.firstFloorLength, 4);
        this.genXWall(x, y, z, this.firstFloorWidth, 4);
        this.genXWall(x, y, z + this.firstFloorLength, this.firstFloorWidth, 4);
        this.genZWall(x, y, z, this.firstFloorLength, 4);
        this.genZWall(x + this.firstFloorWidth, y, z, this.firstFloorLength, 4);
        this.genFlat(x, y, z, this.firstFloorWidth, this.firstFloorLength);
        this.genFlat(x, y + 4, z, this.firstFloorWidth, this.firstFloorLength);
        for (int i = 1; i <= this.firstFloorWidth - 1; ++i) {
            for (int j = 1; j <= this.firstFloorLength - 1; ++j) {
                if ((this.nextTo(x + i, y + 1, z + j, this.cobble) || this.nextTo(x + i, y + 1, z + j, this.cobble)) && !this.nextTo(x + i, y + 1, z + j, this.chest) && random.nextInt(15) == 0) {
                    TileEntityChest chest;
                    IBlockState block = Blocks.field_150486_ae.func_176223_P();
                    world.func_175656_a(new BlockPos(x + i, y + 1, z + j), block);
                    if (block == this.chest && (chest = (TileEntityChest)world.func_175625_s(new BlockPos(x + i, y + 1, z + j))) instanceof TileEntityChest) {
                        chest.func_189404_a(LootTableList.field_186422_d, random.nextLong());
                    }
                }
                if (!world.func_175623_d(new BlockPos(x + i, y + 1, z + j)) || random.nextInt(100 - this.firstFloorWidth) != 0) continue;
                world.func_175656_a(new BlockPos(x + i, y + 1, z + j), Blocks.field_150474_ac.func_176223_P());
                TileEntityMobSpawner mobSpawner = (TileEntityMobSpawner)world.func_175625_s(new BlockPos(x + i, y + 1, z + j));
                mobSpawner.func_145881_a().func_190894_a(this.getRandomMob());
            }
        }
        world.func_175656_a(new BlockPos(x + this.firstFloorWidth / 2, y + 1, z + this.firstFloorLength / 2), Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner mobSpawner = (TileEntityMobSpawner)world.func_175625_s(new BlockPos(x + this.firstFloorWidth / 2, y + 1, z + this.firstFloorLength / 2));
        mobSpawner.func_145881_a().func_190894_a(this.getRandomMob());
        return true;
    }

    private void genXWall(int x, int y, int z, int width, int height) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                IBlockState block = this.cobble;
                if (this.random.nextInt(3) == 0) {
                    block = this.mossyCobble;
                }
                this.world.func_175656_a(new BlockPos(x + i, y + j, z), block);
            }
        }
    }

    private void genZWall(int x, int y, int z, int width, int height) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                IBlockState block = this.cobble;
                if (this.random.nextInt(3) == 0) {
                    block = this.mossyCobble;
                }
                this.world.func_175656_a(new BlockPos(x, y + j, z + i), block);
            }
        }
    }

    private void genFlat(int x, int y, int z, int width, int height) {
        for (int i = 0; i <= width; ++i) {
            for (int j = 0; j <= height; ++j) {
                IBlockState block = this.cobble;
                if (this.random.nextInt(3) == 0) {
                    block = this.mossyCobble;
                }
                this.world.func_175656_a(new BlockPos(x + i, y, z + j), block);
            }
        }
    }

    private ResourceLocation getRandomMob() {
        int i = this.random.nextInt(6);
        if (i == 0) {
            return EntityList.func_191306_a(EntitySkeleton.class);
        }
        if (i == 1) {
            return EntityList.func_191306_a(EntityCreeper.class);
        }
        if (i == 2) {
            return EntityList.func_191306_a(EntitySpider.class);
        }
        if (i == 3 && this.random.nextInt(20) == 0) {
            return EntityList.func_191306_a(EntityBlaze.class);
        }
        if (i == 4) {
            return EntityList.func_191306_a(EntityHusk.class);
        }
        return EntityList.func_191306_a(EntityZombie.class);
    }
}

