/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world.test;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import zathrox.explorercraft.init.BlockReg;

public class WorldGenElvenTrees
extends WorldGenerator {
    private IBlockState log = BlockReg.CHERRY_LOG.func_176223_P();
    private IBlockState leaves = BlockReg.CHERRY_LEAVES.func_176223_P();
    int type = 0;
    int metadata = 2;

    public WorldGenElvenTrees(int type) {
        this.type = type;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return this.generate(world, random, pos, 0);
    }

    public boolean generate(World world, Random random, BlockPos pos, int type) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (world.func_180495_p(new BlockPos(x, (y = pos.func_177956_o()) - 1, z = pos.func_177952_p())).func_185904_a() == Material.field_151577_b || world.func_180495_p(new BlockPos(x, y - 1, z)).func_185904_a() == Material.field_151578_c) {
            return this.generateElvenTree(world, random, x, y, z);
        }
        return true;
    }

    public boolean generateElvenTree(World world, Random random, int x, int y, int z) {
        int height = random.nextInt(10) + 2;
        if (height < 5) {
            height = 6;
        }
        if (!this.canGenElvenTree(world, random, x, y, z, height)) {
            return false;
        }
        if (!this.canGenElvenTree(world, random, x, y, z, height + 1)) {
            return false;
        }
        if (!this.canGenElvenTree(world, random, x, y, z, height + 2)) {
            return false;
        }
        if (!this.canGenElvenTree(world, random, x, y, z, height + 3)) {
            return false;
        }
        if (!this.canGenElvenTree(world, random, x, y, z, height - 1)) {
            return false;
        }
        if (!this.canGenElvenTree(world, random, x, y, z, height - 2)) {
            return false;
        }
        if (!this.canGenElvenTree(world, random, x, y, z, height - 3)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            world.func_175656_a(new BlockPos(x, y + i, z), this.log);
        }
        world.func_175656_a(new BlockPos(x, y + height + 1, z), this.leaves);
        world.func_175656_a(new BlockPos(x, y + height - 1, z + 1), this.leaves);
        world.func_175656_a(new BlockPos(x, y + height - 1, z - 1), this.leaves);
        world.func_175656_a(new BlockPos(x + 1, y + height - 1, z), this.leaves);
        world.func_175656_a(new BlockPos(x - 1, y + height - 1, z), this.leaves);
        world.func_175656_a(new BlockPos(x, y + height, z), this.leaves);
        world.func_175656_a(new BlockPos(x, y + height, z - 1), this.leaves);
        world.func_175656_a(new BlockPos(x, y + height, z - 2), this.leaves);
        world.func_175656_a(new BlockPos(x, y + height, z + 1), this.leaves);
        world.func_175656_a(new BlockPos(x, y + height, z + 2), this.leaves);
        world.func_175656_a(new BlockPos(x + 1, y + height, z), this.leaves);
        world.func_175656_a(new BlockPos(x + 2, y + height, z), this.leaves);
        world.func_175656_a(new BlockPos(x + 1, y + height, z + 1), this.leaves);
        world.func_175656_a(new BlockPos(x + 1, y + height, z + 2), this.leaves);
        world.func_175656_a(new BlockPos(x + 1, y + height, z - 1), this.leaves);
        world.func_175656_a(new BlockPos(x + 1, y + height, z - 2), this.leaves);
        world.func_175656_a(new BlockPos(x + 2, y + height, z + 1), this.leaves);
        world.func_175656_a(new BlockPos(x + 2, y + height, z + 2), this.leaves);
        world.func_175656_a(new BlockPos(x + 2, y + height, z - 1), this.leaves);
        world.func_175656_a(new BlockPos(x + 2, y + height, z - 2), this.leaves);
        world.func_175656_a(new BlockPos(x - 1, y + height, z), this.leaves);
        world.func_175656_a(new BlockPos(x - 2, y + height, z), this.leaves);
        world.func_175656_a(new BlockPos(x - 1, y + height, z - 1), this.leaves);
        world.func_175656_a(new BlockPos(x - 1, y + height, z - 2), this.leaves);
        world.func_175656_a(new BlockPos(x - 1, y + height, z + 1), this.leaves);
        world.func_175656_a(new BlockPos(x - 1, y + height, z + 2), this.leaves);
        world.func_175656_a(new BlockPos(x - 2, y + height, z - 1), this.leaves);
        world.func_175656_a(new BlockPos(x - 2, y + height, z - 2), this.leaves);
        world.func_175656_a(new BlockPos(x - 2, y + height, z + 1), this.leaves);
        world.func_175656_a(new BlockPos(x - 2, y + height, z + 2), this.leaves);
        return true;
    }

    public boolean canGenElvenTree(World world, Random random, int x, int y, int z, int height) {
        if (!world.func_175623_d(new BlockPos(x, y + height, z)) && world.func_180495_p(new BlockPos(x, y + height, z)) != this.leaves && world.func_180495_p(new BlockPos(x, y + height, z)) != this.log) {
            return false;
        }
        if (!world.func_175623_d(new BlockPos(x + 2, y + height, z + 2)) && world.func_180495_p(new BlockPos(x + 2, y + height, z + 2)) != this.leaves && world.func_180495_p(new BlockPos(x + 2, y + height, z + 2)) != this.log) {
            return false;
        }
        if (!world.func_175623_d(new BlockPos(x - 2, y + height, z - 2)) && world.func_180495_p(new BlockPos(x - 2, y + height, z - 2)) != this.leaves && world.func_180495_p(new BlockPos(x - 2, y + height, z - 2)) != this.log) {
            return false;
        }
        if (!world.func_175623_d(new BlockPos(x + 2, y + height, z - 2)) && world.func_180495_p(new BlockPos(x + 2, y + height, z - 2)) != this.leaves && world.func_180495_p(new BlockPos(x + 2, y + height, z - 2)) != this.log) {
            return false;
        }
        return world.func_175623_d(new BlockPos(x - 2, y + height, z + 2)) || world.func_180495_p(new BlockPos(x - 2, y + height, z + 2)) == this.leaves || world.func_180495_p(new BlockPos(x - 2, y + height, z + 2)) == this.log;
    }

    public boolean generateElvenTree2(World world, Random random, int x, int y, int z) {
        int i;
        int height = random.nextInt(10) + 2;
        if (height < 5) {
            height = 6;
        }
        for (i = 0; i <= height; ++i) {
            world.func_175656_a(new BlockPos(x, y + i, z), this.log);
        }
        for (i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                world.func_175656_a(new BlockPos(x - 1, y + height - 1 + i, z - 2 + j), this.leaves);
                world.func_175656_a(new BlockPos(x - 2 + j, y + height - 1 + i, z - 1), this.leaves);
                world.func_175656_a(new BlockPos(x - 1, y + height - 1 + i, z + 2 + j), this.leaves);
                world.func_175656_a(new BlockPos(x + 2 + j, y + height - 1 + i, z - 1), this.leaves);
                world.func_175656_a(new BlockPos(x - 1 + i, y + height + 1, z - 1 + j), this.leaves);
            }
        }
        return true;
    }

    public boolean generateNormalTree(World world, Random random, int par3, int par4, int par5) {
        int i = random.nextInt(3) + 5;
        boolean flag = true;
        if (par4 < 1 || par4 + i + 1 > 256) {
            return false;
        }
        for (int j = par4; j <= par4 + 1 + i; ++j) {
            int byte0 = 1;
            if (j == par4) {
                byte0 = 0;
            }
            if (j >= par4 + 1 + i - 2) {
                byte0 = 2;
            }
            for (int j1 = par3 - byte0; j1 <= par3 + byte0 && flag; ++j1) {
                for (int i2 = par5 - byte0; i2 <= par5 + byte0 && flag; ++i2) {
                    if (j >= 0 && j < 256) {
                        IBlockState k2 = world.func_180495_p(new BlockPos(j1, j, i2));
                        if (world.func_175623_d(new BlockPos(j1, j, i2)) || k2 == this.leaves) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        IBlockState k = world.func_180495_p(new BlockPos(par3, par4 - 1, par5));
        if (k != Blocks.field_150346_d.func_176223_P() && k != Blocks.field_150349_c.func_176223_P() || par4 >= 256 - i - 1) {
            return false;
        }
        this.func_175903_a(world, new BlockPos(par3, par4 - 1, par5), Blocks.field_150346_d.func_176223_P());
        for (int l = par4 - 3 + i; l <= par4 + i; ++l) {
            int k1 = l - (par4 + i);
            int j2 = 1 - k1 / 2;
            for (int l2 = par3 - j2; l2 <= par3 + j2; ++l2) {
                int i3 = l2 - par3;
                for (int j3 = par5 - j2; j3 <= par5 + j2; ++j3) {
                    int k3 = j3 - par5;
                    BlockPos blockpos = new BlockPos(l2, l, j3);
                    IBlockState state2 = world.func_180495_p(blockpos);
                    if (Math.abs(i3) == j2 && Math.abs(k3) == j2 && (random.nextInt(2) == 0 || k1 == 0) || !state2.func_177230_c().isAir(state2, (IBlockAccess)world, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)world, blockpos)) continue;
                    this.func_175903_a(world, blockpos, this.leaves);
                }
            }
        }
        for (int i1 = 0; i1 < i; ++i1) {
            IBlockState l1 = world.func_180495_p(new BlockPos(par3, par4 + i1, par5));
            if (!l1.func_177230_c().isAir(l1, (IBlockAccess)world, new BlockPos(par3, par4 + i1, par5)) && l1 != this.leaves) continue;
            this.func_175903_a(world, new BlockPos(par3, par4 + i1, par5), this.log);
        }
        return true;
    }
}

