/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.world.generation;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import zathrox.explorercraft.util.interfaces.IStructure;

public class WorldGenSlateDungeon
extends WorldGenerator
implements IStructure {
    public static String structureName;
    public static int structureWidth;
    public static int structureDepth;
    public static int structureHeight;
    public static boolean rotationAllowed;

    public WorldGenSlateDungeon(String name, int width, int depth, int height, boolean rotateAllowed) {
        structureName = name;
        structureWidth = width - 1;
        structureDepth = depth - 1;
        structureHeight = height;
        rotationAllowed = rotateAllowed;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        WorldGenSlateDungeon.generateStructure(worldIn, position, rand, structureWidth, structureDepth, structureHeight, rotationAllowed);
        return true;
    }

    public static void generateStructure(World world, BlockPos pos, Random rand, int width, int depth, int height, boolean rotateAllowed) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("explorercraft", structureName));
        if (template != null) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            if (rotateAllowed) {
                Rotation rotation = Rotation.values()[rand.nextInt(Rotation.values().length)];
                if (rotation == Rotation.CLOCKWISE_90) {
                    if (WorldGenSlateDungeon.canSpawnClockwise90(world, pos, width, depth = -depth, height)) {
                        template.func_186260_a(world, pos.func_177979_c(4), settings.func_186220_a(rotation));
                        System.out.println(structureName + " GENERATED CLOCKWISE_90 AT: " + pos);
                    }
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    if (WorldGenSlateDungeon.canSpawnClockwise180(world, pos, width = -width, depth = -depth, height)) {
                        template.func_186260_a(world, pos.func_177979_c(4), settings.func_186220_a(rotation));
                        System.out.println(structureName + " GENERATED CLOCKWISE_180 AT: " + pos);
                    }
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                    if (WorldGenSlateDungeon.canSpawnClockwise270(world, pos, width = -width, depth, height)) {
                        template.func_186260_a(world, pos.func_177979_c(4), settings.func_186220_a(rotation));
                        System.out.println(structureName + " GENERATED CLOCKWISE_270 AT: " + pos);
                    }
                } else if (rotation == Rotation.NONE && WorldGenSlateDungeon.canSpawnHere(world, pos, width, depth, height)) {
                    template.func_186260_a(world, pos.func_177979_c(4), settings.func_186220_a(rotation));
                    System.out.println(structureName + " GENERATED DEFAULT AT: " + pos);
                }
            } else if (WorldGenSlateDungeon.canSpawnHere(world, pos, width, depth, height)) {
                template.func_186260_a(world, pos.func_177979_c(4), settings.func_186220_a(Rotation.NONE));
                System.out.println(structureName + " GENERATED NO ROTATION AT: " + pos);
            }
        }
    }

    public static boolean canReplace(World world, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_185904_a();
        return material.func_76220_a() || material == Material.field_151585_k || material == Material.field_151584_j || material == Material.field_151577_b;
    }

    public static boolean canSpawnHere(World world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WorldGenSlateDungeon.canReplace(world, posAboveGround);
        boolean corner2Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(width, 0, 0));
        boolean corner4Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(0, 0, depth));
        boolean corner3Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(width, 0, depth));
        return posAboveGround.func_177956_o() > 20 && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    private static boolean canSpawnClockwise90(World world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WorldGenSlateDungeon.canReplace(world, posAboveGround);
        boolean corner2Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(depth, 0, 0));
        boolean corner4Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(0, 0, width));
        boolean corner3Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(depth, 0, width));
        return posAboveGround.func_177956_o() > 20 && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    private static boolean canSpawnClockwise180(World world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WorldGenSlateDungeon.canReplace(world, posAboveGround);
        boolean corner2Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(width, 0, 0));
        boolean corner4Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(0, 0, depth));
        boolean corner3Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(width, 0, depth));
        return posAboveGround.func_177956_o() > 20 && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    private static boolean canSpawnClockwise270(World world, BlockPos posAboveGround, int width, int depth, int height) {
        boolean corner1Air = WorldGenSlateDungeon.canReplace(world, posAboveGround);
        boolean corner2Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(depth, 0, 0));
        boolean corner4Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(0, 0, width));
        boolean corner3Air = WorldGenSlateDungeon.canReplace(world, posAboveGround.func_177982_a(depth, 0, width));
        return posAboveGround.func_177956_o() > 20 && corner1Air && corner2Air && corner3Air && corner4Air;
    }
}

